/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableGlowingData;
import org.spongepowered.api.data.manipulator.mutable.entity.GlowingData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.OptBool;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeGlowingData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class GlowingDataProcessor
extends AbstractEntitySingleDataProcessor<Entity, Boolean, Value<Boolean>, GlowingData, ImmutableGlowingData> {
    public GlowingDataProcessor() {
        super(Entity.class, Keys.GLOWING);
    }

    @Override
    protected boolean set(Entity dataHolder, Boolean value) {
        dataHolder.func_184195_f(((Boolean)Preconditions.checkNotNull((Object)value, (Object)"value")).booleanValue());
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(Entity dataHolder) {
        return OptBool.of(dataHolder.func_184202_aL());
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return ImmutableSpongeValue.cachedOf(Keys.GLOWING, value, false);
    }

    @Override
    protected Value<Boolean> constructValue(Boolean actualValue) {
        return new SpongeValue<Boolean>(Keys.GLOWING, false, actualValue);
    }

    @Override
    protected GlowingData createManipulator() {
        return new SpongeGlowingData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

