/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.potion.PotionEffect;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutablePotionEffectData;
import org.spongepowered.api.data.manipulator.mutable.PotionEffectData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.common.data.manipulator.mutable.SpongePotionEffectData;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;
import org.spongepowered.common.mixin.core.entity.projectile.EntityTippedArrowAccessor;

public class TippedArrowPotionDataProcessor
extends AbstractSingleDataSingleTargetProcessor<EntityTippedArrow, List<org.spongepowered.api.effect.potion.PotionEffect>, ListValue<org.spongepowered.api.effect.potion.PotionEffect>, PotionEffectData, ImmutablePotionEffectData> {
    public TippedArrowPotionDataProcessor() {
        super(Keys.POTION_EFFECTS, EntityTippedArrow.class);
    }

    @Override
    protected boolean set(EntityTippedArrow dataHolder, List<org.spongepowered.api.effect.potion.PotionEffect> value) {
        ((EntityTippedArrowAccessor)dataHolder).accessor$getCustomPotionEffects().clear();
        for (org.spongepowered.api.effect.potion.PotionEffect effect : value) {
            PotionEffect mcEffect = new PotionEffect(((PotionEffect)effect).func_188419_a(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.getShowParticles());
            dataHolder.func_184558_a(mcEffect);
        }
        return false;
    }

    @Override
    protected Optional<List<org.spongepowered.api.effect.potion.PotionEffect>> getVal(EntityTippedArrow dataHolder) {
        Set<PotionEffect> effects = ((EntityTippedArrowAccessor)dataHolder).accessor$getCustomPotionEffects();
        if (effects.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<org.spongepowered.api.effect.potion.PotionEffect> apiEffects = new ArrayList<org.spongepowered.api.effect.potion.PotionEffect>();
        for (PotionEffect potionEffect : effects) {
            apiEffects.add((org.spongepowered.api.effect.potion.PotionEffect)new PotionEffect(potionEffect.func_188419_a(), potionEffect.func_76459_b(), potionEffect.func_76458_c(), potionEffect.func_82720_e(), potionEffect.func_188418_e()));
        }
        return Optional.of(apiEffects);
    }

    @Override
    protected ImmutableValue<List<org.spongepowered.api.effect.potion.PotionEffect>> constructImmutableValue(List<org.spongepowered.api.effect.potion.PotionEffect> value) {
        return new ImmutableSpongeListValue<org.spongepowered.api.effect.potion.PotionEffect>(Keys.POTION_EFFECTS, ImmutableList.copyOf(value));
    }

    @Override
    protected ListValue<org.spongepowered.api.effect.potion.PotionEffect> constructValue(List<org.spongepowered.api.effect.potion.PotionEffect> actualValue) {
        return new SpongeListValue<org.spongepowered.api.effect.potion.PotionEffect>(Keys.POTION_EFFECTS, actualValue);
    }

    @Override
    protected PotionEffectData createManipulator() {
        return new SpongePotionEffectData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (!(container instanceof EntityTippedArrow)) {
            return DataTransactionResult.failNoData();
        }
        Optional<List<org.spongepowered.api.effect.potion.PotionEffect>> effects = this.getVal((EntityTippedArrow)container);
        if (effects.isPresent()) {
            ((EntityTippedArrowAccessor)((Object)container)).accessor$getCustomPotionEffects().clear();
            return DataTransactionResult.successRemove(this.constructImmutableValue(effects.get()));
        }
        return DataTransactionResult.successNoData();
    }
}

