/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.tileentity;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tileentity.TileEntityStructure;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableStructureData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.StructureData;
import org.spongepowered.api.data.type.StructureMode;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeStructureData;
import org.spongepowered.common.data.processor.common.AbstractTileEntityDataProcessor;
import org.spongepowered.common.mixin.core.tileentity.TileEntityStructureAccessor;
import org.spongepowered.common.util.VecHelper;

public final class StructureDataProcessor
extends AbstractTileEntityDataProcessor<TileEntityStructure, StructureData, ImmutableStructureData> {
    public StructureDataProcessor() {
        super(TileEntityStructure.class);
    }

    @Override
    protected boolean doesDataExist(TileEntityStructure container) {
        return true;
    }

    @Override
    protected boolean set(TileEntityStructure container, Map<Key<?>, Object> map) {
        Vector3i size;
        Vector3i position;
        String author = (String)map.get(Keys.STRUCTURE_AUTHOR);
        if (author != null) {
            ((TileEntityStructureAccessor)container).accessor$setAuthor(author);
        }
        container.func_184406_a(((Boolean)map.get(Keys.STRUCTURE_IGNORE_ENTITIES)).booleanValue());
        container.func_189718_a(((Float)map.get(Keys.STRUCTURE_INTEGRITY)).floatValue());
        StructureMode mode = (StructureMode)map.get(Keys.STRUCTURE_MODE);
        if (mode != null) {
            ((TileEntityStructureAccessor)container).accessor$setMode((TileEntityStructure.Mode)mode);
        }
        if ((position = (Vector3i)map.get(Keys.STRUCTURE_POSITION)) != null) {
            ((TileEntityStructureAccessor)container).accessor$setPosition(VecHelper.toBlockPos((Vector3i)Preconditions.checkNotNull((Object)position, (Object)"position")));
        }
        container.func_189723_d(((Boolean)map.get(Keys.STRUCTURE_POWERED)).booleanValue());
        Long seed = (Long)map.get(Keys.STRUCTURE_SEED);
        if (seed != null) {
            container.func_189725_a(seed.longValue());
        }
        container.func_189703_e(((Boolean)map.get(Keys.STRUCTURE_SHOW_AIR)).booleanValue());
        container.func_189710_f(((Boolean)map.get(Keys.STRUCTURE_SHOW_BOUNDING_BOX)).booleanValue());
        Boolean showBoundingBox = (Boolean)map.get(Keys.STRUCTURE_SHOW_BOUNDING_BOX);
        if (showBoundingBox != null) {
            // empty if block
        }
        if ((size = (Vector3i)map.get(Keys.STRUCTURE_SIZE)) != null) {
            ((TileEntityStructureAccessor)container).accessor$setSize(VecHelper.toBlockPos((Vector3i)Preconditions.checkNotNull((Object)size, (Object)"position")));
        }
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(TileEntityStructure container) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Keys.STRUCTURE_AUTHOR, (Object)((TileEntityStructureAccessor)container).accessor$getAuthor());
        builder.put(Keys.STRUCTURE_IGNORE_ENTITIES, (Object)((TileEntityStructureAccessor)container).accessor$getIgnoreEntities());
        builder.put(Keys.STRUCTURE_INTEGRITY, (Object)Float.valueOf(((TileEntityStructureAccessor)container).accessor$getIntegrity()));
        builder.put(Keys.STRUCTURE_MODE, (Object)((TileEntityStructureAccessor)container).accessor$getMode());
        builder.put(Keys.STRUCTURE_POSITION, (Object)((TileEntityStructureAccessor)container).accessor$getPosition());
        builder.put(Keys.STRUCTURE_POWERED, (Object)container.func_189722_G());
        builder.put(Keys.STRUCTURE_SHOW_AIR, (Object)((TileEntityStructureAccessor)container).accessor$getShowAir());
        builder.put(Keys.STRUCTURE_SHOW_BOUNDING_BOX, (Object)((TileEntityStructureAccessor)container).accessor$getShowBoundingBox());
        builder.put(Keys.STRUCTURE_SIZE, (Object)((TileEntityStructureAccessor)container).accessor$getSize());
        return builder.build();
    }

    @Override
    protected StructureData createManipulator() {
        return new SpongeStructureData();
    }

    @Override
    public Optional<StructureData> fill(DataContainer container, StructureData data) {
        Optional<Vector3i> size;
        Optional<Boolean> showBoundingBox;
        Optional<Boolean> showAir;
        Optional<Boolean> powered;
        Optional<Vector3i> position;
        Optional<StructureMode> mode;
        Optional<Float> integrity;
        Optional<Boolean> ignoreEntities;
        Preconditions.checkNotNull((Object)data, (Object)"data");
        Optional<String> author = container.getString(Keys.STRUCTURE_AUTHOR.getQuery());
        if (author.isPresent()) {
            data = (StructureData)data.set(Keys.STRUCTURE_AUTHOR, author.get());
        }
        if ((ignoreEntities = container.getBoolean(Keys.STRUCTURE_IGNORE_ENTITIES.getQuery())).isPresent()) {
            data = (StructureData)data.set(Keys.STRUCTURE_IGNORE_ENTITIES, ignoreEntities.get());
        }
        if ((integrity = container.getFloat(Keys.STRUCTURE_INTEGRITY.getQuery())).isPresent()) {
            data = (StructureData)data.set(Keys.STRUCTURE_INTEGRITY, integrity.get());
        }
        if ((mode = container.getObject(Keys.STRUCTURE_MODE.getQuery(), StructureMode.class)).isPresent()) {
            data = (StructureData)data.set(Keys.STRUCTURE_MODE, mode.get());
        }
        if ((position = container.getObject(Keys.STRUCTURE_POSITION.getQuery(), Vector3i.class)).isPresent()) {
            data = (StructureData)data.set(Keys.STRUCTURE_POSITION, position.get());
        }
        if ((powered = container.getBoolean(Keys.STRUCTURE_POWERED.getQuery())).isPresent()) {
            data = (StructureData)data.set(Keys.STRUCTURE_POWERED, powered.get());
        }
        if ((showAir = container.getBoolean(Keys.STRUCTURE_SHOW_AIR.getQuery())).isPresent()) {
            data = (StructureData)data.set(Keys.STRUCTURE_SHOW_AIR, showAir.get());
        }
        if ((showBoundingBox = container.getBoolean(Keys.STRUCTURE_SHOW_BOUNDING_BOX.getQuery())).isPresent()) {
            data = (StructureData)data.set(Keys.STRUCTURE_SHOW_BOUNDING_BOX, showBoundingBox.get());
        }
        if ((size = container.getObject(Keys.STRUCTURE_SIZE.getQuery(), Vector3i.class)).isPresent()) {
            data = (StructureData)data.set(Keys.STRUCTURE_SIZE, size.get());
        }
        return Optional.of(data);
    }

    @Override
    public DataTransactionResult remove(DataHolder container) {
        return DataTransactionResult.failNoData();
    }
}

