/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.OwnershipTrackedBridge;
import org.spongepowered.common.bridge.block.BlockBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.PhaseTrackerCategory;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseStack;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.UnwindingPhaseContext;
import org.spongepowered.common.event.tracking.context.SpongeProxyBlockAccess;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.tick.NeighborNotificationContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.mixin.core.world.WorldServerAccessor;
import org.spongepowered.common.registry.type.event.SpawnTypeRegistryModule;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;
import org.spongepowered.common.world.WorldManager;

public final class PhaseTracker {
    public static final PhaseTracker CLIENT = new PhaseTracker();
    public static final PhaseTracker SERVER = new PhaseTracker();
    @Nullable
    private Thread sidedThread;
    private boolean hasRun = false;
    public static final String ASYNC_BLOCK_CHANGE_MESSAGE = "Sponge adapts the vanilla handling of block changes to power events and plugins such that it follows the known fact that block changes MUST occur on the server thread (even on clients, this exists as the InternalServer thread). It is NOT possible to change this fact and must be reported to the offending mod for async issues.";
    public static final String ASYNC_TRACKER_ACCESS = "Sponge adapts the vanilla handling of various processes, such as setting a block or spawning an entity. Sponge is designed around the concept that Minecraft is primarily performing these operations on the \"server thread\". Because of this Sponge is safeguarding common access to the PhaseTracker as the entrypoint for performing these sort of changes.";
    private static final CopyOnWriteArrayList<net.minecraft.entity.Entity> ASYNC_CAPTURED_ENTITIES = new CopyOnWriteArrayList();
    public static final BiConsumer<PrettyPrinter, PhaseContext<?>> CONTEXT_PRINTER = (printer, context) -> context.printCustom((PrettyPrinter)printer, 4);
    private static final BiConsumer<PrettyPrinter, PhaseContext<?>> PHASE_PRINTER = (printer, context) -> {
        printer.add("  - Phase: %s", context.state);
        printer.add("    Context:");
        context.printCustom((PrettyPrinter)printer, 4);
        context.printTrace((PrettyPrinter)printer);
    };
    private final PhaseStack stack = new PhaseStack();
    private boolean hasPrintedEmptyOnce = false;
    private boolean hasPrintedAboutRunnawayPhases = false;
    private boolean hasPrintedAsyncEntities = false;
    private int printRunawayCount = 0;
    private final List<IPhaseState<?>> printedExceptionsForBlocks = new ArrayList();
    private final List<IPhaseState<?>> printedExceptionsForEntities = new ArrayList();
    private final List<Tuple<IPhaseState<?>, IPhaseState<?>>> completedIncorrectStates = new ArrayList();
    private final List<IPhaseState<?>> printedExceptionsForState = new ArrayList();
    private final Set<IPhaseState<?>> printedExceptionsForUnprocessedState = new HashSet();
    private final Set<IPhaseState<?>> printedExceptionForMaximumProcessDepth = new HashSet();
    private final ConcurrentHashMap<IPhaseState<?>, ArrayDeque<? extends PhaseContext<?>>> stateContextPool = new ConcurrentHashMap();

    public void init() {
        if (this != SERVER) {
            return;
        }
        if (this.hasRun) {
            return;
        }
        this.hasRun = true;
        Task.builder().name("Sponge Async To Sync Entity Spawn Task").intervalTicks(1L).execute(() -> {
            if (ASYNC_CAPTURED_ENTITIES.isEmpty()) {
                return;
            }
            ArrayList<net.minecraft.entity.Entity> entities = new ArrayList<net.minecraft.entity.Entity>(ASYNC_CAPTURED_ENTITIES);
            ASYNC_CAPTURED_ENTITIES.removeAll(entities);
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypeRegistryModule.FORCED);
                for (net.minecraft.entity.Entity entity : entities) {
                    PhaseTracker.getInstance().spawnEntityWithCause((World)entity.func_130014_f_(), (Entity)entity);
                }
            }
        }).submit(SpongeImpl.getPlugin());
    }

    public void setThread(@Nullable Thread thread) throws IllegalAccessException {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (stackTrace.length < 3) {
            throw new IllegalAccessException("Cannot call directly to change thread.");
        }
        String callingClass = stackTrace[1].getClassName();
        String callingParent = stackTrace[2].getClassName();
        if (!("net.minecraft.client.Minecraft".equals(callingClass) && "net.minecraft.client.Minecraft".equals(callingParent) || "net.minecraft.server.MinecraftServer".equals(callingClass) && "net.minecraft.server.MinecraftServer".equals(callingParent) || "net.minecraft.server.dedicated.DedicatedServer".equals(callingClass) && "net.minecraft.client.Minecraft".equals(callingParent) || "net.minecraft.server.integrated.IntegratedServer".equals(callingClass) && "net.minecraft.client.Minecraft".equals(callingParent))) {
            throw new IllegalAccessException("Illegal Attempts to re-assign PhaseTracker threads on Sponge");
        }
        this.sidedThread = thread;
    }

    @Nullable
    public Thread getSidedThread() {
        return this.sidedThread;
    }

    public static PhaseTracker getInstance() {
        return SERVER;
    }

    public <C extends PhaseContext<C>> ArrayDeque<C> createContextPool(IPhaseState<C> state) {
        ArrayDeque pool = new ArrayDeque();
        this.stateContextPool.put(state, pool);
        return pool;
    }

    void switchToPhase(IPhaseState<?> state, PhaseContext<?> phaseContext) {
        if (!SpongeImplHooks.isMainThread()) {
            new PrettyPrinter(60).add("Illegal Async PhaseTracker Access").centre().hr().addWrapped(ASYNC_TRACKER_ACCESS, new Object[0]).add().add(new Exception("Async Block Change Detected")).log(SpongeImpl.getLogger(), Level.ERROR);
            return;
        }
        Preconditions.checkNotNull(state, (Object)"State cannot be null!");
        Preconditions.checkNotNull(phaseContext, (Object)"PhaseContext cannot be null!");
        Preconditions.checkArgument((boolean)phaseContext.isComplete(), (Object)"PhaseContext must be complete!");
        if (SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose() && this.stack.size() > 6 && this.stack.checkForRunaways(state, phaseContext)) {
            this.printRunawayPhase(state, phaseContext);
        }
        if (Sponge.isServerAvailable() && state.shouldProvideModifiers(phaseContext)) {
            SpongeImpl.getCauseStackManager().registerPhaseContextProvider(phaseContext);
        }
        this.stack.push(state, phaseContext);
    }

    void completePhase(IPhaseState<?> prevState) {
        if (!SpongeImplHooks.isMainThread()) {
            new PrettyPrinter(60).add("Illegal Async PhaseTracker Access").centre().hr().addWrapped(ASYNC_TRACKER_ACCESS, new Object[0]).add().add(new Exception("Async Block Change Detected")).log(SpongeImpl.getLogger(), Level.ERROR);
            return;
        }
        PhaseContext<?> currentContext = this.stack.peek();
        IPhaseState state = currentContext.state;
        boolean isEmpty = this.stack.isEmpty();
        if (isEmpty) {
            this.printEmptyStackOnCompletion(currentContext);
            return;
        }
        if (prevState != state) {
            this.printIncorrectPhaseCompletion(prevState, state);
            this.stack.pop();
            return;
        }
        if (SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose() && this.stack.checkForRunaways(GeneralPhase.Post.UNWINDING, null)) {
            this.printRunnawayPhaseCompletion(state);
        }
        boolean hasCaptures = currentContext.hasCaptures();
        try (UnwindingPhaseContext unwinding = UnwindingPhaseContext.unwind(state, currentContext, hasCaptures);){
            try {
                if (hasCaptures) {
                    state.unwind(currentContext);
                }
            }
            catch (Exception e) {
                this.printMessageWithCaughtException("Exception Exiting Phase", "Something happened when trying to unwind", state, currentContext, e);
            }
        }
        catch (Exception e) {
            this.printMessageWithCaughtException("Exception Post Dispatching Phase", "Something happened when trying to post dispatch state", state, currentContext, e);
        }
        this.checkPhaseContextProcessed(state, currentContext);
        this.stack.pop();
        if (this.stack.isEmpty()) {
            for (WorldServer world : WorldManager.getWorlds()) {
                WorldServerBridge mixinWorld = (WorldServerBridge)world;
                if (!mixinWorld.bridge$getProxyAccess().hasProxy()) continue;
                new PrettyPrinter().add("BlockPRoxy has extra proxies not pruned!").centre().hr().add("When completing the Phase: %s, some foreign BlockProxy was pushed, but never pruned.", state).add().add("Please analyze the following exception from the proxy:").add(new Exception()).print(System.err);
            }
        }
    }

    private void printRunnawayPhaseCompletion(IPhaseState<?> state) {
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose() && !this.hasPrintedAboutRunnawayPhases) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add("Completing Phase").centre().hr();
        printer.addWrapped(60, "Detecting a runaway phase! Potentially a problem where something isn't completing a phase!!! Sponge will stop printingafter three more times to avoid generating extra logs", new Object[0]);
        printer.add();
        printer.addWrapped(60, "%s : %s", "Completing phase", state);
        printer.add(" Phases Remaining:");
        PhaseTracker.printPhaseStackWithException(this, printer, new Exception("RunawayPhase"));
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose() && this.printRunawayCount++ > 3) {
            this.hasPrintedAboutRunnawayPhases = true;
        }
    }

    public void generateVersionInfo(PrettyPrinter printer) {
        for (PluginContainer pluginContainer : SpongeImpl.getInternalPlugins()) {
            pluginContainer.getVersion().ifPresent(version -> printer.add("%s : %s", pluginContainer.getName(), version));
        }
    }

    private void printIncorrectPhaseCompletion(IPhaseState<?> prevState, IPhaseState<?> state) {
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose() && !this.completedIncorrectStates.isEmpty()) {
            for (Tuple<IPhaseState<?>, IPhaseState<?>> tuple : this.completedIncorrectStates) {
                if (!tuple.getFirst().equals(prevState) || !tuple.getSecond().equals(state)) continue;
                return;
            }
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Completing incorrect phase").centre().hr().addWrapped("Sponge's tracking system is very dependent on knowing when a change to any world takes place, however, we are attempting to complete a \"phase\" other than the one we most recently entered. This is an error usually on Sponge's part, so a report is required on the issue tracker on GitHub.", new Object[0]).hr().add("Expected to exit phase: %s", prevState).add("But instead found phase: %s", state).add("StackTrace:").add(new Exception());
        printer.add(" Phases Remaining:");
        PhaseTracker.printPhaseStackWithException(this, printer, new Exception("Incorrect Phase Completion"));
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose()) {
            this.completedIncorrectStates.add(new Tuple(prevState, state));
        }
    }

    private void printEmptyStackOnCompletion(PhaseContext<?> context) {
        if (this.hasPrintedEmptyOnce) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Unexpectedly Completing An Empty Stack").centre().hr().addWrapped(60, "Sponge's tracking system is very dependent on knowing when a change to any world takes place, however, we have been told to complete a \"phase\" without having entered any phases. This is an error usually on Sponge's part, so a report is required on the issue tracker on GitHub.", new Object[0]).hr().add("StackTrace:").add(new Exception()).add("Phase being completed:");
        PHASE_PRINTER.accept(printer, context);
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose()) {
            this.hasPrintedEmptyOnce = true;
        }
    }

    private void printRunawayPhase(IPhaseState<?> state, PhaseContext<?> context) {
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose() && !this.hasPrintedAboutRunnawayPhases) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add("Switching Phase").centre().hr();
        printer.addWrapped(60, "Detecting a runaway phase! Potentially a problem where something isn't completing a phase!!!", new Object[0]);
        printer.add("  %s : %s", "Entering State", state);
        CONTEXT_PRINTER.accept(printer, context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        PhaseTracker.printPhaseStackWithException(this, printer, new Exception("RunawayPhase"));
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose() && this.printRunawayCount++ > SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().getMaximumRunawayCount()) {
            this.hasPrintedAboutRunnawayPhases = true;
        }
    }

    public static void printNullSourceForBlock(WorldServer worldServer, BlockPos pos, Block blockIn, BlockPos otherPos, NullPointerException e) {
        PhaseTracker instance = PhaseTracker.getInstance();
        PrettyPrinter printer = new PrettyPrinter(60).add("Null Source Block from Unknown Source!").centre().hr().addWrapped("Hey, Sponge is saving the game from crashing or spamming because some source put up a \"null\" Block as it's source for sending out a neighbor notification. This is usually unsupported as the game will silently ignore some nulls by performing \"==\" checks instead of calling methods, potentially making an NPE. Because Sponge uses the source block to build information for tracking, Sponge has to save the game from crashing by reporting this issue. Because the source is unknown, it's recommended to report this issue to SpongeCommon's issue tracker on GitHub. Please provide the following information: ", new Object[0]).add().add(" %s : %s", "Source position", pos).add(" %s : %s", "World", ((World)worldServer).getName()).add(" %s : %s", "Source Block Recovered", blockIn).add(" %s : %s", "Notified Position", otherPos).add();
        PhaseTracker.printPhaseStackWithException(instance, printer, e);
        printer.log(SpongeImpl.getLogger(), Level.WARN);
    }

    public static void printNullSourceBlockWithTile(BlockPos pos, Block blockIn, BlockPos otherPos, TileEntityType type, boolean useTile, NullPointerException e) {
        PhaseTracker instance = PhaseTracker.getInstance();
        PrettyPrinter printer = new PrettyPrinter(60).add("Null Source Block on TileEntity!").centre().hr().addWrapped("Hey, Sponge is saving the game from crashing because a TileEntity is sending out a 'null' Block as it's source (more likely) and attempting to perform a neighbor notification with it. Because this is guaranteed to lead to a crash or a spam of reports, Sponge is going ahead and fixing the issue. The offending Tile is " + type.getId(), new Object[0]).add().add("%s : %s", "Source position", pos).add("%s : %s", "Source TileEntity", type).add("%s : %s", "Recovered using TileEntity as Source", useTile).add("%s : %s", "Source Block Recovered", blockIn).add("%s : %s", "Notified Position", otherPos);
        PhaseTracker.printPhaseStackWithException(instance, printer, e);
        printer.log(SpongeImpl.getLogger(), Level.WARN);
    }

    public static void printNullSourceBlockNeighborNotificationWithNoTileSource(BlockPos pos, Block blockIn, BlockPos otherPos, NullPointerException e) {
        PhaseTracker instance = PhaseTracker.getInstance();
        PrettyPrinter printer = new PrettyPrinter(60).add("Null Source Block on TileEntity!").centre().hr().addWrapped("Hey, Sponge is saving the game from crashing because a TileEntity is sending out a 'null' Block as it's source (more likely) and attempting to perform a neighbor notification with it. Because this is guaranteed to lead to a crash or a spam of reports, Sponge is going ahead and fixing the issue. The offending Tile is unknown, so we don't have any way to configure a reporting for you", new Object[0]).add().add("%s : %s", "Source position", pos).add("%s : %s", "Source TileEntity", "UNKNOWN").add("%s : %s", "Recovered using TileEntity as Source", "false").add("%s : %s", "Source Block Recovered", blockIn).add("%s : %s", "Notified Position", otherPos);
        PhaseTracker.printPhaseStackWithException(instance, printer, e);
        printer.log(SpongeImpl.getLogger(), Level.WARN);
    }

    public static void printPhaseStackWithException(PhaseTracker instance, PrettyPrinter printer, Throwable e) {
        instance.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseContext<?>)data));
        printer.add().add(" %s :", "StackTrace").add(e).add();
        instance.generateVersionInfo(printer);
    }

    public void printMessageWithCaughtException(String header, String subHeader, @Nullable Throwable e) {
        this.printMessageWithCaughtException(header, subHeader, this.getCurrentState(), this.getCurrentContext(), e);
    }

    private void printMessageWithCaughtException(String header, String subHeader, IPhaseState<?> state, PhaseContext<?> context, @Nullable Throwable t) {
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add(header).centre().hr().add("%s %s", subHeader, state).addWrapped(60, "%s :", "PhaseContext");
        CONTEXT_PRINTER.accept(printer, context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseContext<?>)data));
        if (t != null) {
            printer.add("Stacktrace:").add(t);
            if (t.getCause() != null) {
                printer.add(t.getCause());
            }
        }
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
    }

    public void printExceptionFromPhase(Throwable e, PhaseContext<?> context) {
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose() && !this.printedExceptionsForState.isEmpty()) {
            for (IPhaseState<?> iPhaseState : this.printedExceptionsForState) {
                if (context.state != iPhaseState) continue;
                return;
            }
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Exception occurred during a PhaseState").centre().hr().addWrapped("Sponge's tracking system makes a best effort to not throw exceptions randomly but sometimes it is inevitable. In most cases, something else triggered this exception and Sponge prevented a crash by catching it. The following stacktrace can be used to help pinpoint the cause.", new Object[0]).hr().add("The PhaseState having an exception: %s", context.state).add("The PhaseContext:");
        printer.add(context.printCustom(printer, 4));
        PhaseTracker.printPhaseStackWithException(this, printer, e);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose()) {
            this.printedExceptionsForState.add(context.state);
        }
    }

    private void checkPhaseContextProcessed(IPhaseState<?> state, PhaseContext<?> context) {
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose() && this.printedExceptionsForUnprocessedState.contains(state)) {
            return;
        }
        if (context.notAllCapturesProcessed()) {
            this.printUnprocessedPhaseContextObjects(state, context);
            this.printedExceptionsForUnprocessedState.add(state);
        }
    }

    private void printUnprocessedPhaseContextObjects(IPhaseState<?> state, PhaseContext<?> context) {
        this.printMessageWithCaughtException("Failed to process all PhaseContext captured!", "During the processing of a phase, certain objects were captured in a PhaseContext. All of them should have been removed from the PhaseContext by this point", state, context, null);
    }

    private void printBlockTrackingException(PhaseContext<?> phaseData, IPhaseState<?> phaseState, Throwable e) {
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose() && !this.printedExceptionsForBlocks.isEmpty() && this.printedExceptionsForBlocks.contains(phaseState)) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Exception attempting to capture a block change!").centre().hr();
        this.printPhasestack(phaseData, e, printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose()) {
            this.printedExceptionsForBlocks.add(phaseState);
        }
    }

    private void printPhasestack(PhaseContext<?> phaseData, Throwable e, PrettyPrinter printer) {
        printer.addWrapped(60, "%s :", "PhaseContext");
        CONTEXT_PRINTER.accept(printer, phaseData);
        printer.addWrapped(60, "%s :", "Phases remaining");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseContext<?>)data));
        printer.add("Stacktrace:");
        printer.add(e);
    }

    private void printUnexpectedBlockChange(WorldServerBridge mixinWorld, BlockPos pos, IBlockState currentState, IBlockState newState) {
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose()) {
            return;
        }
        new PrettyPrinter(60).add("Unexpected World Change Detected!").centre().hr().add("Sponge's tracking system is very dependent on knowing when\na change to any world takes place, however there are chances\nwhere Sponge does not know of changes that mods may perform.\nIn cases like this, it is best to report to Sponge to get this\nchange tracked correctly and accurately.").hr().add().add("%s : %s", "World", mixinWorld).add("%s : %s", "Position", pos).add("%s : %s", "Current State", currentState).add("%s : %s", "New State", newState).add().add("StackTrace:").add(new Exception()).trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
    }

    private void printExceptionSpawningEntity(PhaseContext<?> context, Throwable e) {
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose() && !this.printedExceptionsForEntities.isEmpty() && this.printedExceptionsForEntities.contains(context.state)) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Exception attempting to capture or spawn an Entity!").centre().hr();
        this.printPhasestack(context, e, printer);
        printer.log(SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose()) {
            this.printedExceptionsForEntities.add(context.state);
        }
    }

    public static Block validateBlockForNeighborNotification(WorldServer worldServer, BlockPos pos, @Nullable Block blockIn, BlockPos otherPos, Chunk chunk) {
        if (blockIn == null) {
            PhaseContext<?> currentContext = PhaseTracker.getInstance().getCurrentContext();
            PhaseTrackerCategory trackerConfig = SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker();
            if (currentContext.state == TickPhase.Tick.TILE_ENTITY) {
                TileEntityType type = currentContext.getSource(org.spongepowered.api.block.tileentity.TileEntity.class).map(org.spongepowered.api.block.tileentity.TileEntity::getType).orElse(null);
                if (type != null) {
                    boolean useTile;
                    Map<String, Boolean> autoFixedTiles = trackerConfig.getAutoFixedTiles();
                    boolean contained = autoFixedTiles.containsKey(type.getId());
                    if (!contained) {
                        if (pos.equals((Object)currentContext.getSource(TileEntity.class).get().func_174877_v())) {
                            autoFixedTiles.put(type.getId(), true);
                        } else {
                            autoFixedTiles.put(type.getId(), false);
                        }
                    }
                    boolean bl = useTile = contained && autoFixedTiles.get(type.getId()) != false;
                    if (useTile) {
                        blockIn = ((TileEntity)currentContext.getSource()).func_145838_q();
                    } else {
                        Block block = blockIn = pos.func_177958_n() >> 4 == chunk.field_76635_g && pos.func_177952_p() >> 4 == chunk.field_76647_h ? chunk.func_177435_g(pos).func_177230_c() : worldServer.func_180495_p(pos).func_177230_c();
                    }
                    if (!contained && trackerConfig.isReportNullSourceBlocks()) {
                        PhaseTracker.printNullSourceBlockWithTile(pos, blockIn, otherPos, type, useTile, new NullPointerException("Null Source Block For TileEntity Neighbor Notification"));
                    }
                } else {
                    Block block = blockIn = pos.func_177958_n() >> 4 == chunk.field_76635_g && pos.func_177952_p() >> 4 == chunk.field_76647_h ? chunk.func_177435_g(pos).func_177230_c() : worldServer.func_180495_p(pos).func_177230_c();
                    if (trackerConfig.isReportNullSourceBlocks()) {
                        PhaseTracker.printNullSourceBlockNeighborNotificationWithNoTileSource(pos, blockIn, otherPos, new NullPointerException("Null Source Block For Neighbor Notification"));
                    }
                }
            } else {
                Block block = blockIn = pos.func_177958_n() >> 4 == chunk.field_76635_g && pos.func_177952_p() >> 4 == chunk.field_76647_h ? chunk.func_177435_g(pos).func_177230_c() : worldServer.func_180495_p(pos).func_177230_c();
                if (trackerConfig.isReportNullSourceBlocks()) {
                    PhaseTracker.printNullSourceForBlock(worldServer, pos, blockIn, otherPos, new NullPointerException("Null Source Block For Neighbor Notification"));
                }
            }
        }
        return blockIn;
    }

    String dumpStack() {
        if (this.stack.isEmpty()) {
            return "[Empty stack]";
        }
        PrettyPrinter printer = new PrettyPrinter(40);
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseContext<?>)data));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        printer.print(new PrintStream(stream));
        return stream.toString();
    }

    public IPhaseState<?> getCurrentState() {
        return this.stack.peekState();
    }

    public PhaseContext<?> getCurrentContext() {
        return this.stack.peekContext();
    }

    public void notifyBlockOfStateChange(WorldServerBridge mixinWorld, IBlockState notifyState, BlockPos notifyPos, Block sourceBlock, BlockPos sourcePos) {
        if (!SpongeImplHooks.isMainThread()) {
            new PrettyPrinter(60).add("Illegal Async PhaseTracker Access").centre().hr().addWrapped(ASYNC_TRACKER_ACCESS, new Object[0]).add().add(new Exception("Async Block Notifcation Detected")).log(SpongeImpl.getLogger(), Level.ERROR);
            return;
        }
        try {
            PhaseContext<?> peek = this.stack.peek();
            IPhaseState state = peek.state;
            if (!((BlockBridge)notifyState.func_177230_c()).bridge$hasNeighborChangedLogic()) {
                return;
            }
            if ((ShouldFire.CHANGE_BLOCK_EVENT || ShouldFire.NOTIFY_NEIGHBOR_BLOCK_EVENT) && state.doesCaptureNeighborNotifications(peek)) {
                peek.getCapturedBlockSupplier().captureNeighborNotification(mixinWorld, notifyState, notifyPos, sourceBlock, sourcePos);
                return;
            }
            state.associateNeighborStateNotifier(peek, sourcePos, notifyState.func_177230_c(), notifyPos, (WorldServer)mixinWorld, PlayerTracker.Type.NOTIFIER);
            LocatableBlock block = new SpongeLocatableBlockBuilder().world((World)((Object)mixinWorld)).position(sourcePos.func_177958_n(), sourcePos.func_177956_o(), sourcePos.func_177952_p()).state((BlockState)sourceBlock.func_176223_P()).build();
            try (NeighborNotificationContext context = TickPhase.Tick.NEIGHBOR_NOTIFY.createPhaseContext().source(block).sourceBlock(sourceBlock).setNotifiedBlockPos(notifyPos).setNotifiedBlockState(notifyState).setSourceNotification(sourcePos).allowsCaptures(state);){
                state.provideNotifierForNeighbors(peek, context);
                context.buildAndSwitch();
                if (PhaseTracker.checkMaxBlockProcessingDepth(state, peek, context.getDepth())) {
                    return;
                }
                notifyState.func_189546_a((net.minecraft.world.World)((WorldServer)mixinWorld), notifyPos, sourceBlock, sourcePos);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception while updating neighbours");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being updated");
            crashreportcategory.func_189529_a("Source block type", () -> {
                try {
                    return String.format("ID #%d (%s // %s)", Block.func_149682_b((Block)sourceBlock), sourceBlock.func_149739_a(), sourceBlock.getClass().getCanonicalName());
                }
                catch (Throwable var2) {
                    return "ID #" + Block.func_149682_b((Block)sourceBlock);
                }
            });
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)notifyPos, (IBlockState)notifyState);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setBlockState(WorldServerBridge mixinWorld, BlockPos pos, IBlockState newState, BlockChangeFlag flag) {
        ChunkBridge mixinChunk;
        IBlockState originalBlockState;
        boolean isComplete;
        if (!SpongeImplHooks.isMainThread()) {
            new PrettyPrinter(60).add("Illegal Async Block Change").centre().hr().addWrapped(ASYNC_BLOCK_CHANGE_MESSAGE, new Object[0]).add().add(" %s : %s", "World", mixinWorld).add(" %s : %d, %d, %d", "Block Pos", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).add(" %s : %s", "BlockState", newState).add().addWrapped("Sponge is not going to allow this block change to take place as doing so can lead to further issues, not just with sponge or plugins, but other mods as well.", new Object[0]).add().add(new Exception("Async Block Change Detected")).log(SpongeImpl.getLogger(), Level.ERROR);
            return false;
        }
        SpongeBlockChangeFlag spongeFlag = (SpongeBlockChangeFlag)flag;
        WorldServer minecraftWorld = (WorldServer)mixinWorld;
        Chunk chunk = minecraftWorld.func_175726_f(pos);
        if (chunk.func_76621_g()) {
            return false;
        }
        IBlockState currentState = chunk.func_177435_g(pos);
        int oldLight = SpongeImplHooks.getChunkPosLight(currentState, (net.minecraft.world.World)minecraftWorld, pos);
        int oldOpacity = SpongeImplHooks.getBlockLightOpacity(currentState, (IBlockAccess)minecraftWorld, pos);
        if (currentState == newState) {
            SpongeProxyBlockAccess proxyAccess = mixinWorld.bridge$getProxyAccess();
            if (!proxyAccess.hasProxy()) return false;
            if (proxyAccess.func_180495_p(pos) == currentState) return false;
            proxyAccess.onChunkChanged(pos, newState);
            return false;
        }
        PhaseContext<?> context = this.stack.peek();
        IPhaseState phaseState = context.state;
        boolean bl = isComplete = phaseState == GeneralPhase.State.COMPLETE;
        if (!isComplete || SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose()) {
            // empty if block
        }
        if ((originalBlockState = (mixinChunk = (ChunkBridge)chunk).bridge$setBlockState(pos, newState, currentState, spongeFlag)) == null) {
            return false;
        }
        if (SpongeImplHooks.getBlockLightOpacity(newState, (IBlockAccess)minecraftWorld, pos) != oldOpacity || SpongeImplHooks.getChunkPosLight(newState, (net.minecraft.world.World)minecraftWorld, pos) != oldLight) {
            minecraftWorld.field_72984_F.func_76320_a("checkLight");
            minecraftWorld.func_175664_x(pos);
            minecraftWorld.field_72984_F.func_76319_b();
        }
        if (phaseState.doesBulkBlockCapture(context) && ShouldFire.CHANGE_BLOCK_EVENT) {
            return true;
        }
        if (phaseState.doesBlockEventTracking(context) && ShouldFire.CHANGE_BLOCK_EVENT) {
            try {
                SpongeBlockSnapshot originalBlockSnapshot = context.getSingleSnapshot();
                if (ShouldFire.CHANGE_BLOCK_EVENT_POST || originalBlockSnapshot.blockChange.shouldFire()) {
                    Transaction<BlockSnapshot> transaction = TrackingUtil.TRANSACTION_CREATION.apply(originalBlockSnapshot).get();
                    ImmutableList transactions = ImmutableList.of(transaction);
                    Cause currentCause = Sponge.getCauseStackManager().getCurrentCause();
                    ChangeBlockEvent normalEvent = originalBlockSnapshot.blockChange.createEvent(currentCause, (ImmutableList<Transaction<BlockSnapshot>>)transactions);
                    try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                        if (originalBlockSnapshot.blockChange.shouldFire()) {
                            SpongeImpl.postEvent(normalEvent);
                            if (normalEvent.isCancelled()) {
                                transaction.setValid(false);
                            }
                        }
                        if (ShouldFire.CHANGE_BLOCK_EVENT_POST) {
                            Cause normalizedEvent = currentCause.with(normalEvent);
                            ChangeBlockEvent.Post post = phaseState.createChangeBlockPostEvent(context, (ImmutableList<Transaction<BlockSnapshot>>)transactions, normalizedEvent);
                            SpongeImpl.postEvent(post);
                            if (post.isCancelled()) {
                                transaction.setValid(false);
                            }
                        }
                        if (!transaction.isValid()) {
                            transaction.getOriginal().restore(true, BlockChangeFlags.NONE);
                            if (phaseState.tracksBlockSpecificDrops(context)) {
                                context.getBlockDropSupplier().removeAllIfNotEmpty(pos);
                            }
                            boolean bl22 = false;
                            return bl22;
                        }
                        TrackingUtil.performTransactionProcess(transaction, context, 0);
                        boolean bl2 = true;
                        return bl2;
                    }
                }
            }
            catch (Exception | NoClassDefFoundError e) {
                this.printBlockTrackingException(context, phaseState, e);
                return false;
            }
        }
        if (spongeFlag.isNotifyClients() && chunk.func_150802_k()) {
            minecraftWorld.func_184138_a(pos, originalBlockState, newState, spongeFlag.getRawFlag());
        }
        Block block = newState.func_177230_c();
        if (spongeFlag.updateNeighbors()) {
            minecraftWorld.func_175722_b(pos, originalBlockState.func_177230_c(), true);
            if (!newState.func_185912_n()) return true;
            minecraftWorld.func_175666_e(pos, block);
            return true;
        }
        if (!spongeFlag.notifyObservers()) return true;
        minecraftWorld.func_190522_c(pos, block);
        return true;
    }

    public boolean spawnEntity(WorldServer world, net.minecraft.entity.Entity entity) {
        User user;
        EntityThrowable throwable;
        EntityLivingBase thrower;
        boolean isForced;
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null!");
        if (entity instanceof EntityItem && SpongeImplHooks.isRestoringBlocks((net.minecraft.world.World)world)) {
            return false;
        }
        if (((EntityBridge)entity).bridge$isConstructing()) {
            ((EntityBridge)entity).bridge$fireConstructors();
        }
        WorldServerBridge mixinWorldServer = (WorldServerBridge)world;
        PhaseContext<?> context = this.stack.peek();
        IPhaseState phaseState = context.state;
        boolean bl = isForced = entity.field_98038_p || entity instanceof EntityPlayer;
        if (!isForced && !phaseState.doesAllowEntitySpawns()) {
            return false;
        }
        int chunkX = MathHelper.func_76128_c((double)(entity.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(entity.field_70161_v / 16.0));
        if (!isForced && !((WorldServerAccessor)world).accessor$isChunkLoaded(chunkX, chunkZ, true)) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            world.field_73010_i.add(entityplayer);
            world.func_72854_c();
            SpongeImplHooks.firePlayerJoinSpawnEvent((EntityPlayerMP)entityplayer);
        } else if (entity instanceof IEntityOwnable) {
            IEntityOwnable ownable = (IEntityOwnable)entity;
            net.minecraft.entity.Entity owner = ownable.func_70902_q();
            if (owner instanceof EntityPlayer) {
                context.owner = (User)owner;
                if (entity instanceof OwnershipTrackedBridge) {
                    ((OwnershipTrackedBridge)entity).tracked$setOwnerReference((User)owner);
                } else {
                    ((Entity)entity).setCreator(ownable.func_184753_b());
                }
            }
        } else if (entity instanceof EntityThrowable && (thrower = (throwable = (EntityThrowable)entity).func_85052_h()) != null && (user = thrower instanceof OwnershipTrackedBridge ? (User)((OwnershipTrackedBridge)thrower).tracked$getOwnerReference().orElse(null) : (User)thrower) != null) {
            context.owner = user;
            if (entity instanceof OwnershipTrackedBridge) {
                ((OwnershipTrackedBridge)entity).tracked$setOwnerReference(user);
            } else {
                ((Entity)entity).setCreator(user.getUniqueId());
            }
        }
        if (!isForced && (ShouldFire.SPAWN_ENTITY_EVENT || entity instanceof Projectile || ShouldFire.CHANGE_BLOCK_EVENT && phaseState.doesBulkBlockCapture(context) && phaseState.tracksBlockSpecificDrops(context) && context.getCaptureBlockPos().getPos().isPresent())) {
            try {
                return phaseState.spawnEntityOrCapture(context, (Entity)entity, chunkX, chunkZ);
            }
            catch (Exception | NoClassDefFoundError e) {
                this.printExceptionSpawningEntity(context, e);
                return false;
            }
        }
        net.minecraft.entity.Entity customEntity = SpongeImplHooks.getCustomEntityIfItem(entity);
        net.minecraft.entity.Entity finalEntityToSpawn = customEntity == null ? entity : customEntity;
        world.func_72964_e(chunkX, chunkZ).func_76612_a(finalEntityToSpawn);
        world.field_72996_f.add(finalEntityToSpawn);
        ((WorldServerAccessor)world).accessor$onEntityAdded(finalEntityToSpawn);
        return true;
    }

    public boolean spawnEntityWithCause(World world, Entity entity) {
        boolean isForced;
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null!");
        if (((EntityBridge)((Object)entity)).bridge$isConstructing()) {
            ((EntityBridge)((Object)entity)).bridge$fireConstructors();
        }
        net.minecraft.entity.Entity minecraftEntity = (net.minecraft.entity.Entity)entity;
        WorldServer worldServer = (WorldServer)world;
        WorldServerBridge mixinWorldServer = (WorldServerBridge)worldServer;
        int chunkX = MathHelper.func_76128_c((double)(minecraftEntity.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(minecraftEntity.field_70161_v / 16.0));
        boolean bl = isForced = minecraftEntity.field_98038_p || minecraftEntity instanceof EntityPlayer;
        if (!isForced && !((WorldServerAccessor)((Object)world)).accessor$isChunkLoaded(chunkX, chunkZ, true)) {
            return false;
        }
        ArrayList<Entity> entities = new ArrayList<Entity>(1);
        entities.add(entity);
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
        SpongeImpl.postEvent(event);
        if (entity instanceof EntityPlayer || !event.isCancelled()) {
            EntityUtil.processEntitySpawn(entity, Optional::empty);
        }
        return true;
    }

    public static boolean isEntitySpawnInvalid(Entity entity) {
        if (Sponge.isServerAvailable() && (Sponge.getServer().isMainThread() || SpongeImpl.getServer().func_71241_aa())) {
            return false;
        }
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().captureEntitiesAsync()) {
            if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose()) {
                return true;
            }
            if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().verboseErrors() && PhaseTracker.getInstance().hasPrintedAsyncEntities) {
                return true;
            }
            new PrettyPrinter(60).add("Async Entity Spawn Warning").centre().hr().add("An entity was attempting to spawn off the \"main\" server thread").add().add("Details of the spawning are disabled according to the Sponge").add("configuration file. A stack trace of the attempted spawn should").add("provide information about how it was being spawned. Sponge is").add("currently configured to NOT attempt to capture this spawn and").add("spawn the entity at an appropriate time, while on the main server").add("thread.").add().add("Details of the spawn:").add("%s : %s", "Entity", entity).add("Stacktrace").add(new Exception("Async entity spawn attempt")).trace(SpongeImpl.getLogger(), Level.WARN);
            PhaseTracker.getInstance().hasPrintedAsyncEntities = true;
            return true;
        }
        ASYNC_CAPTURED_ENTITIES.add((net.minecraft.entity.Entity)entity);
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().isVerbose()) {
            return true;
        }
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker().verboseErrors() && PhaseTracker.getInstance().hasPrintedAsyncEntities) {
            return true;
        }
        new PrettyPrinter(60).add("Async Entity Spawn Warning").centre().hr().add("An entity was attempting to spawn off the \"main\" server thread").add().add("Delayed spawning is ENABLED for Sponge.").add("The entity is safely captured by Sponge while off the main").add("server thread, and therefore will be spawned the next tick.").add("Some cases where a mod is expecting the entity back while").add("async can cause issues with said mod.").add().add("Details of the spawn:").add("%s : %s", "Entity", entity).add("Stacktrace").add(new Exception("Async entity spawn attempt")).trace(SpongeImpl.getLogger(), Level.WARN);
        PhaseTracker.getInstance().hasPrintedAsyncEntities = true;
        return true;
    }

    public static boolean checkMaxBlockProcessingDepth(IPhaseState<?> state, PhaseContext<?> context, int currentDepth) {
        SpongeConfig<GlobalConfig> globalConfigAdapter = SpongeImpl.getGlobalConfigAdapter();
        PhaseTrackerCategory trackerConfig = globalConfigAdapter.getConfig().getPhaseTracker();
        int maxDepth = trackerConfig.getMaxBlockProcessingDepth();
        if (maxDepth == 100 && state == TickPhase.Tick.NEIGHBOR_NOTIFY) {
            maxDepth = 1000;
            trackerConfig.resetMaxDepthTo1000();
            globalConfigAdapter.save();
        }
        if (currentDepth < maxDepth) {
            return false;
        }
        PhaseTracker tracker = PhaseTracker.getInstance();
        if (!trackerConfig.isVerbose() && tracker.printedExceptionForMaximumProcessDepth.contains(state)) {
            return true;
        }
        tracker.printedExceptionForMaximumProcessDepth.add(state);
        String message = String.format("Sponge is still trying to process captured blocks after %s iterations of depth-first processing. This is likely due to a mod doing something unusual.", currentDepth);
        tracker.printMessageWithCaughtException("Maximum block processing depth exceeded!", message, state, context, null);
        return true;
    }

    public void ensureEmpty() {
        if (!this.stack.isEmpty()) {
            PrettyPrinter printer = new PrettyPrinter(60);
            printer.add("Phases Not Completed").centre().hr();
            printer.add("One or more phases were started but were not properly completed by the end of the server tick. They will be automatically closed, but this is an issue that should be reported to Sponge.");
            this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseContext<?>)data));
            printer.add();
            this.generateVersionInfo(printer);
            printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
            while (!this.stack.isEmpty()) {
                this.getCurrentContext().close();
            }
        }
    }
}

