/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.UnwindingPhaseContext;
import org.spongepowered.common.event.tracking.context.BlockTransaction;
import org.spongepowered.common.event.tracking.context.MultiBlockCaptureSupplier;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class UnwindingState
implements IPhaseState<UnwindingPhaseContext> {
    private final String desc = TrackingUtil.phaseStateToString("General", this);

    public static UnwindingState getInstance() {
        return Holder.INSTANCE;
    }

    private UnwindingState() {
    }

    @Override
    public UnwindingPhaseContext createPhaseContext() {
        throw new UnsupportedOperationException("Use UnwindingPhaseContext#unwind(IPhaseState, PhaseContext)! Cannot create a context based on Post state!");
    }

    @Override
    public boolean requiresPost() {
        return false;
    }

    @Override
    public boolean ignoresBlockUpdateTick(UnwindingPhaseContext context) {
        return true;
    }

    @Override
    public boolean ignoresScheduledUpdates() {
        return false;
    }

    @Override
    public boolean alreadyCapturingEntitySpawns() {
        return true;
    }

    @Override
    public boolean alreadyCapturingEntityTicks() {
        return true;
    }

    @Override
    public boolean alreadyCapturingTileTicks() {
        return true;
    }

    @Override
    public boolean alreadyProcessingBlockItemDrops() {
        return true;
    }

    @Override
    public boolean allowsGettingQueuedRemovedTiles() {
        return true;
    }

    @Override
    public boolean hasSpecificBlockProcess(UnwindingPhaseContext context) {
        return !context.isPostingSpecialProcess();
    }

    @Override
    public BlockTransaction.ChangeBlock captureBlockChange(UnwindingPhaseContext phaseContext, BlockPos pos, SpongeBlockSnapshot originalBlockSnapshot, IBlockState newState, BlockChangeFlag flags, @Nullable TileEntity tileEntity) {
        if (!phaseContext.isPostingSpecialProcess()) {
            return phaseContext.getCapturedBlockSupplier().logBlockChange(originalBlockSnapshot, newState, flags);
        }
        if (!this.doesBulkBlockCapture(phaseContext)) {
            phaseContext.setSingleSnapshot(originalBlockSnapshot);
            return null;
        }
        phaseContext.getCapturedBlockSupplier().put(originalBlockSnapshot, newState);
        return null;
    }

    @Override
    public boolean tracksTileEntityChanges(UnwindingPhaseContext context) {
        return context.allowsBulkBlockCaptures() && !context.isPostingSpecialProcess() && context.usesMulti && context.tracksTiles;
    }

    @Override
    public boolean doesCaptureNeighborNotifications(UnwindingPhaseContext context) {
        return context.allowsBulkBlockCaptures() && !context.isPostingSpecialProcess() && context.usesMulti && context.tracksNeighborNotifications;
    }

    @Override
    public boolean getShouldCancelAllTransactions(UnwindingPhaseContext context, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent.Post postEvent, ListMultimap<BlockPos, BlockEventData> scheduledEvents, boolean noCancelledTransactions) {
        return context.allowsBulkBlockCaptures() && context.isPostingSpecialProcess() && context.getUnwindingState().getShouldCancelAllTransactions(context.getUnwindingContext(), blockEvents, postEvent, scheduledEvents, noCancelledTransactions);
    }

    @Override
    public void processCancelledTransaction(UnwindingPhaseContext context, Transaction<BlockSnapshot> transaction, BlockSnapshot original) {
        if (context.isPostingSpecialProcess()) {
            context.getCapturedBlockSupplier().cancelTransaction(original);
        }
        IPhaseState.super.processCancelledTransaction(context, transaction, original);
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, UnwindingPhaseContext context) {
        IPhaseState<?> phaseState = context.getUnwindingState();
        Object unwinding = context.getUnwindingContext();
        phaseState.appendContextPreExplosion(explosionContext, unwinding);
    }

    @Override
    public void associateNeighborStateNotifier(UnwindingPhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        IPhaseState<?> unwindingState = context.getUnwindingState();
        Object unwindingContext = context.getUnwindingContext();
        unwindingState.associateNeighborStateNotifier(unwindingContext, sourcePos, block, notifyPos, minecraftWorld, notifier);
    }

    @Override
    public void unwind(UnwindingPhaseContext context) {
        IPhaseState<?> unwindingState = context.getUnwindingState();
        Object unwindingContext = context.getUnwindingContext();
        try {
            List<Entity> contextEntities = context.getCapturedEntitiesOrEmptyList();
            List<EntityItem> contextItems = context.getCapturedItemsOrEmptyList();
            MultiBlockCaptureSupplier originalSupplier = context.getCapturedBlockSupplier();
            if (context.usesMulti) {
                TrackingUtil.processBlockCaptures(context, 0, originalSupplier);
                do {
                    try (AutoCloseable ignored = context::popBlockSupplier;){
                        MultiBlockCaptureSupplier recursiveSupplier = context.getCapturedBlockSupplier();
                        if (recursiveSupplier.isEmpty()) continue;
                        context.pushNewCaptureSupplier();
                        TrackingUtil.processBlockCaptures(context, 0, recursiveSupplier);
                    }
                } while (context.blockSuppliers != null && !context.blockSuppliers.isEmpty());
            } else {
                TrackingUtil.processBlockCaptures(context);
            }
            if (contextEntities.isEmpty() && contextItems.isEmpty()) {
                return;
            }
            if (!contextEntities.isEmpty()) {
                ArrayList<Entity> entities = new ArrayList<Entity>(contextEntities);
                contextEntities.clear();
                unwindingState.postProcessSpawns(unwindingContext, entities);
            }
            if (!contextItems.isEmpty()) {
                ArrayList<EntityItem> items = new ArrayList<EntityItem>(contextItems);
                contextItems.clear();
                SpongeCommonEventFactory.callSpawnEntity(items, unwindingContext);
            }
        }
        catch (Exception e) {
            PhaseTracker.getInstance().printExceptionFromPhase(e, context);
        }
    }

    @Override
    public void postProcessSpecificBlockChange(UnwindingPhaseContext currentContext, BlockTransaction.ChangeBlock changeBlock, int depth) {
        if (PhaseTracker.checkMaxBlockProcessingDepth(this, currentContext, depth)) {
            return;
        }
        currentContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            ArrayList<Entity> capturedEntities = new ArrayList<Entity>((Collection<Entity>)entities);
            currentContext.getUnwindingState().postProcessSpawns(currentContext.getUnwindingContext(), capturedEntities);
        });
        MultiBlockCaptureSupplier original = currentContext.getCapturedBlockSupplier();
        if (!original.isEmpty()) {
            try {
                if (currentContext.usesMulti) {
                    TrackingUtil.processBlockCaptures(currentContext, depth + 1, original);
                    do {
                        try (AutoCloseable ignored = currentContext::popBlockSupplier;){
                            MultiBlockCaptureSupplier recursiveSupplier = currentContext.getCapturedBlockSupplier();
                            if (recursiveSupplier.isEmpty()) continue;
                            currentContext.pushNewCaptureSupplier();
                            TrackingUtil.processBlockCaptures(currentContext, depth + 1, recursiveSupplier);
                        }
                    } while (currentContext.blockSuppliers != null && !currentContext.blockSuppliers.isEmpty());
                } else {
                    TrackingUtil.processBlockCaptures(currentContext, depth + 1, original);
                }
            }
            catch (Exception e) {
                PhaseTracker.getInstance().printExceptionFromPhase(e, currentContext);
            }
        }
    }

    @Override
    public boolean spawnEntityOrCapture(UnwindingPhaseContext context, Entity entity, int chunkX, int chunkZ) {
        return context.getCapturedEntities().add(entity);
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }

    @Override
    public void performOnBlockAddedSpawns(UnwindingPhaseContext context, int depth) {
        if (PhaseTracker.checkMaxBlockProcessingDepth(this, context, depth)) {
            return;
        }
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            ArrayList<Entity> capturedEntities = new ArrayList<Entity>((Collection<Entity>)entities);
            context.getUnwindingState().postProcessSpawns(context.getUnwindingContext(), capturedEntities);
        });
        TrackingUtil.processBlockCaptures(context, depth, context.getCapturedBlockSupplier());
    }

    @Override
    public void performPostBlockNotificationsAndNeighborUpdates(UnwindingPhaseContext context, IBlockState newState, SpongeBlockChangeFlag changeFlag, int depth) {
        if (context.isPostingSpecialProcess()) {
            return;
        }
        if (PhaseTracker.checkMaxBlockProcessingDepth(this, context, depth)) {
            return;
        }
        context.setBulkBlockCaptures(false);
        TrackingUtil.processBlockCaptures(context, depth, context.getCapturedBlockSupplier());
    }

    @Override
    public boolean doesBulkBlockCapture(UnwindingPhaseContext context) {
        return !context.isPostingSpecialProcess() && context.allowsBulkBlockCaptures();
    }

    @Override
    public boolean alreadyCapturingBlockTicks(UnwindingPhaseContext context) {
        return true;
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> snapshotTransaction, UnwindingPhaseContext context) {
        IPhaseState<?> unwindingState = context.getUnwindingState();
        Object unwindingContext = context.getUnwindingContext();
        unwindingState.postBlockTransactionApplication(blockChange, snapshotTransaction, unwindingContext);
    }

    public String toString() {
        return this.desc;
    }

    private static final class Holder {
        static final UnwindingState INSTANCE = new UnwindingState();

        private Holder() {
        }
    }
}

