/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.lang.ref.WeakReference;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.world.World;
import org.spongepowered.common.bridge.world.WorldServerBridge;

public final class CaptureBlockPos
implements AutoCloseable {
    @Nullable
    private BlockPos pos;
    @Nullable
    private WeakReference<WorldServerBridge> mixinWorldReference;

    public Optional<BlockPos> getPos() {
        return Optional.ofNullable(this.pos);
    }

    public CaptureBlockPos setPos(@Nullable BlockPos pos) {
        this.pos = pos;
        return this;
    }

    public void setWorld(@Nullable WorldServerBridge world) {
        this.mixinWorldReference = world == null ? null : new WeakReference<WorldServerBridge>(world);
    }

    public void setWorld(@Nullable WorldServer world) {
        this.mixinWorldReference = world == null ? null : new WeakReference<WorldServerBridge>((WorldServerBridge)world);
    }

    public Optional<WorldServerBridge> getMixinWorld() {
        return this.mixinWorldReference == null ? Optional.empty() : Optional.ofNullable(this.mixinWorldReference.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaptureBlockPos that = (CaptureBlockPos)o;
        return Objects.equal((Object)this.pos, (Object)that.pos);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pos});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pos", (Object)this.pos).add("world", this.getMixinWorld().map(w -> ((World)((Object)w)).getName())).toString();
    }

    @Override
    public void close() {
        this.pos = null;
    }
}

