/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketClickWindow;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.OwnershipTrackedBridge;
import org.spongepowered.common.bridge.inventory.ContainerBridge;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class BasicInventoryPacketState
extends PacketState<InventoryPacketContext> {
    final int stateId;
    final int stateMask;
    private static Set<Class<?>> containersFailedCapture = new ReferenceOpenHashSet();

    public BasicInventoryPacketState() {
        this(0, 0);
    }

    public BasicInventoryPacketState(int stateId) {
        this(stateId, 262143);
    }

    public BasicInventoryPacketState(int stateId, int stateMask) {
        this.stateId = stateId & stateMask;
        this.stateMask = stateMask;
    }

    @Override
    public boolean doesBulkBlockCapture(InventoryPacketContext context) {
        return false;
    }

    @Nullable
    public ClickInventoryEvent createInventoryEvent(EntityPlayerMP playerMP, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<Entity> capturedEntities, int usedButton, @Nullable Slot slot) {
        return null;
    }

    protected boolean shouldFire() {
        return ShouldFire.CLICK_INVENTORY_EVENT;
    }

    @Override
    public boolean matches(int packetState) {
        return this.stateMask != 0 && (packetState & this.stateMask & this.stateId) == (packetState & this.stateMask);
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, InventoryPacketContext context) {
        ((TrackedInventoryBridge)playerMP.field_71070_bA).bridge$setCaptureInventory(true);
    }

    @Override
    public boolean shouldCaptureEntity() {
        return true;
    }

    @Override
    public InventoryPacketContext createNewContext() {
        return (InventoryPacketContext)((InventoryPacketContext)new InventoryPacketContext(this).addCaptures()).addEntityDropCaptures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unwind(InventoryPacketContext context) {
        List<SlotTransaction> slotTransactions;
        TrackedInventoryBridge trackedInventory;
        block49: {
            Iterator iterator;
            ArrayList<Entity> capturedItems;
            net.minecraft.inventory.Container openContainer;
            EntityPlayerMP player;
            block51: {
                int usedButton;
                Transaction<ItemStackSnapshot> cursorTransaction;
                CPacketClickWindow packetIn;
                block50: {
                    player = context.getPacketPlayer();
                    trackedInventory = (TrackedInventoryBridge)player.field_71070_bA;
                    if (!trackedInventory.bridge$capturingInventory() && !context.hasCaptures()) {
                        trackedInventory.bridge$getCapturedSlotTransactions().clear();
                        return;
                    }
                    packetIn = (CPacketClickWindow)context.getPacket();
                    cursorTransaction = this.getCursorTransaction(context, player);
                    openContainer = player.field_71070_bA;
                    slotTransactions = trackedInventory.bridge$getCapturedSlotTransactions();
                    usedButton = packetIn.func_149543_e();
                    capturedItems = new ArrayList<Entity>();
                    context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> items.stream().map(entity -> (Entity)entity).forEach(capturedItems::add));
                    context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(capturedItems::addAll);
                    if (this.shouldFire()) break block50;
                    if (!ShouldFire.SPAWN_ENTITY_EVENT || capturedItems.isEmpty()) break block49;
                    iterator = capturedItems.iterator();
                    break block51;
                }
                Slot slot = null;
                if (packetIn.func_149544_d() >= 0) {
                    slot = ((ContainerBridge)((Object)trackedInventory)).bridge$getContainerSlot(packetIn.func_149544_d());
                }
                try (CauseStackManager.StackFrame stackFrame = Sponge.getCauseStackManager().pushCauseFrame();){
                    ClickInventoryEvent inventoryEvent;
                    Sponge.getCauseStackManager().pushCause(openContainer);
                    Sponge.getCauseStackManager().pushCause(player);
                    if (slotTransactions.isEmpty() && packetIn.func_149544_d() >= 0 && capturedItems.isEmpty()) {
                        if (player.field_71070_bA.field_75152_c != packetIn.func_149548_c()) {
                            return;
                        }
                        if (!((ContainerBridge)((Object)trackedInventory)).bridge$capturePossible()) {
                            if (!containersFailedCapture.add(trackedInventory.getClass())) return;
                            SpongeImpl.getLogger().warn("Changes in modded Container were not captured. Inventory events will not fire for this. Container: " + openContainer.getClass());
                            return;
                        }
                        if (slot != null) {
                            ItemStackSnapshot item = slot.peek().map(ItemStack::createSnapshot).orElse(ItemStackSnapshot.NONE);
                            slotTransactions.add(new SlotTransaction(slot, item, item));
                        }
                    }
                    if ((inventoryEvent = this.createInventoryEvent(player, ContainerUtil.fromNative(openContainer), cursorTransaction, new ArrayList<SlotTransaction>(slotTransactions), capturedItems, usedButton, slot)) == null) return;
                    if (!(inventoryEvent instanceof ClickInventoryEvent.Drag)) {
                        PacketPhaseUtil.validateCapturedTransactions(packetIn.func_149544_d(), openContainer, inventoryEvent.getTransactions());
                    }
                    SpongeImpl.postEvent(inventoryEvent);
                    if (inventoryEvent.isCancelled() || !inventoryEvent.getCursorTransaction().isValid()) {
                        PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, inventoryEvent.getCursorTransaction().getOriginal());
                    } else if (inventoryEvent.getCursorTransaction().getCustom().isPresent()) {
                        PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, inventoryEvent.getCursorTransaction().getFinal());
                    }
                    PacketPhaseUtil.handleSlotRestore((EntityPlayer)player, openContainer, inventoryEvent.getTransactions(), inventoryEvent.isCancelled());
                    if (!inventoryEvent.isCancelled()) {
                        if (inventoryEvent instanceof SpawnEntityEvent) {
                            BasicInventoryPacketState.processSpawnedEntities(player, (SpawnEntityEvent)((Object)inventoryEvent));
                            return;
                        }
                        if (capturedItems.isEmpty()) return;
                        stackFrame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
                        SpongeCommonEventFactory.callSpawnEntity(capturedItems, context);
                        return;
                    }
                    if (!(inventoryEvent instanceof ClickInventoryEvent.Drop)) return;
                    capturedItems.clear();
                    return;
                }
                finally {
                    slotTransactions.clear();
                    trackedInventory.bridge$setCaptureInventory(false);
                }
            }
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                if (entity instanceof OwnershipTrackedBridge) {
                    ((OwnershipTrackedBridge)((Object)entity)).tracked$setOwnerReference((Player)player);
                    continue;
                }
                entity.setCreator(player.func_110124_au());
            }
            Throwable throwable = null;
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                Sponge.getCauseStackManager().pushCause(openContainer);
                Sponge.getCauseStackManager().pushCause(player);
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
                SpongeCommonEventFactory.callSpawnEntity(capturedItems, context);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        slotTransactions.clear();
        trackedInventory.bridge$setCaptureInventory(false);
    }

    public Transaction<ItemStackSnapshot> getCursorTransaction(InventoryPacketContext context, EntityPlayerMP player) {
        ItemStackSnapshot lastCursor = context.getCursor();
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
        return new Transaction<ItemStackSnapshot>(lastCursor, newCursor);
    }
}

