/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.network.play.client.CPacketEnchantItem;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.AffectEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public final class EnchantItemPacketState
extends BasicInventoryPacketState {
    @Override
    public void unwind(InventoryPacketContext context) {
        EntityPlayerMP player = context.getPacketPlayer();
        TrackedInventoryBridge trackedInventory = (TrackedInventoryBridge)player.field_71070_bA;
        if (!trackedInventory.bridge$capturingInventory()) {
            trackedInventory.bridge$getCapturedSlotTransactions().clear();
            return;
        }
        CPacketEnchantItem packetIn = (CPacketEnchantItem)context.getPacket();
        ItemStackSnapshot lastCursor = context.getCursor();
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(lastCursor, newCursor);
        Container openContainer = player.field_71070_bA;
        List<SlotTransaction> slotTransactions = trackedInventory.bridge$getCapturedSlotTransactions();
        int usedButton = packetIn.func_149537_d();
        ArrayList<Entity> capturedItems = new ArrayList<Entity>();
        for (EntityItem entityItem : context.getCapturedItems()) {
            capturedItems.add((Entity)entityItem);
        }
        context.getCapturedItems().clear();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            Sponge.getCauseStackManager().pushCause(openContainer);
            ClickInventoryEvent inventoryEvent = this.createInventoryEvent(player, ContainerUtil.fromNative(openContainer), transaction, Lists.newArrayList(slotTransactions), capturedItems, usedButton, null);
            if (trackedInventory.bridge$getCapturedSlotTransactions().isEmpty() && capturedItems.isEmpty()) {
                trackedInventory.bridge$setCaptureInventory(false);
                return;
            }
            if (inventoryEvent != null) {
                if (inventoryEvent instanceof AffectEntityEvent && ((AffectEntityEvent)((Object)inventoryEvent)).getEntities().isEmpty()) {
                    slotTransactions.clear();
                    trackedInventory.bridge$setCaptureInventory(false);
                    return;
                }
                if (!(inventoryEvent instanceof ClickInventoryEvent.Drag)) {
                    PacketPhaseUtil.validateCapturedTransactions(packetIn.func_149539_c(), openContainer, inventoryEvent.getTransactions());
                }
                SpongeImpl.postEvent(inventoryEvent);
                if (inventoryEvent.isCancelled() || PacketPhaseUtil.allTransactionsInvalid(inventoryEvent.getTransactions())) {
                    if (inventoryEvent instanceof ClickInventoryEvent.Drop) {
                        capturedItems.clear();
                    }
                    PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, inventoryEvent.getCursorTransaction().getOriginal());
                    PacketPhaseUtil.handleSlotRestore((EntityPlayer)player, openContainer, inventoryEvent.getTransactions(), true);
                } else {
                    PacketPhaseUtil.handleSlotRestore((EntityPlayer)player, openContainer, inventoryEvent.getTransactions(), false);
                    if (!inventoryEvent.getCursorTransaction().isValid()) {
                        PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, inventoryEvent.getCursorTransaction().getOriginal());
                    } else if (inventoryEvent.getCursorTransaction().getCustom().isPresent()) {
                        PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, inventoryEvent.getCursorTransaction().getFinal());
                    }
                    if (inventoryEvent instanceof SpawnEntityEvent) {
                        EnchantItemPacketState.processSpawnedEntities(player, (SpawnEntityEvent)((Object)inventoryEvent));
                    } else {
                        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
                            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                            SpongeCommonEventFactory.callSpawnEntity(entities, context);
                        });
                    }
                }
            }
        }
        slotTransactions.clear();
        trackedInventory.bridge$setCaptureInventory(false);
    }
}

