/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickContext;

public final class NeighborNotificationContext
extends LocationBasedTickContext<NeighborNotificationContext> {
    @Nullable
    private BlockPos sourceNotification;
    @Nullable
    private Block sourceNotifier;
    @Nullable
    private BlockPos notifiedBlockPos;
    @Nullable
    private IBlockState notifiedBlockState;
    @Nullable
    BlockSnapshot notificationSnapshot;
    private int depth;

    NeighborNotificationContext(IPhaseState<NeighborNotificationContext> phaseState) {
        super(phaseState);
    }

    @Override
    public NeighborNotificationContext source(Object owner) {
        Block block;
        super.source(owner);
        if (owner instanceof LocatableBlock && (block = ((IBlockState)((LocatableBlock)owner).getBlockState()).func_177230_c()) instanceof TrackableBridge) {
            TrackableBridge mixinBlock = (TrackableBridge)block;
            ((NeighborNotificationContext)((NeighborNotificationContext)((NeighborNotificationContext)this.setBlockEvents(mixinBlock.bridge$allowsBlockEventCreation())).setBulkBlockCaptures(mixinBlock.bridge$allowsBlockBulkCapture())).setEntitySpawnEvents(mixinBlock.bridge$allowsEntityEventCreation())).setBulkEntityCaptures(mixinBlock.bridge$allowsEntityBulkCapture());
        }
        return this;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        super.printCustom(printer, indent);
        String s = String.format("%1$" + indent + "s", "");
        if (this.sourceNotifier != null) {
            printer.add(s + "- %s: %s", "SourceBlock", this.sourceNotifier);
        }
        if (this.sourceNotification != null) {
            printer.add(s + "- %s: %s", "SourcePos", this.sourceNotification);
        }
        if (this.notifiedBlockState != null) {
            printer.add(s + "- %s: %s", "NotifiedBlockState", this.notifiedBlockState);
        }
        if (this.notifiedBlockPos != null) {
            printer.add(s + "- %s: %s", "NotifiedPos", this.notifiedBlockPos);
        }
        return printer;
    }

    @Override
    protected void reset() {
        super.reset();
        this.sourceNotification = null;
        this.sourceNotifier = null;
        this.notifiedBlockPos = null;
        this.notifiedBlockState = null;
        this.notificationSnapshot = null;
        this.depth = -1;
    }

    public NeighborNotificationContext allowsCaptures(IPhaseState<?> state) {
        if (state.isWorldGeneration()) {
            this.setBlockEvents(false);
            this.setBulkBlockCaptures(false);
            this.setEntitySpawnEvents(false);
            this.setBulkEntityCaptures(false);
        }
        return this;
    }

    public NeighborNotificationContext sourceBlock(Block sourceBlock) {
        this.sourceNotifier = sourceBlock;
        return this;
    }

    public NeighborNotificationContext setSourceNotification(@Nullable BlockPos sourceNotification) {
        this.sourceNotification = sourceNotification;
        return this;
    }

    public NeighborNotificationContext setNotifiedBlockPos(@Nullable BlockPos notifiedBlockPos) {
        this.notifiedBlockPos = notifiedBlockPos;
        return this;
    }

    public NeighborNotificationContext setNotifiedBlockState(@Nullable IBlockState notifiedBlockState) {
        this.notifiedBlockState = notifiedBlockState;
        return this;
    }

    public NeighborNotificationContext setSourceNotification(@Nullable BlockSnapshot neighborNotificationSource) {
        this.notificationSnapshot = neighborNotificationSource;
        return this;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }
}

