/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl.comp;

import com.flowpowered.math.vector.Vector2i;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.GridInventory;
import org.spongepowered.api.item.inventory.type.InventoryColumn;
import org.spongepowered.api.item.inventory.type.InventoryRow;
import org.spongepowered.common.item.inventory.adapter.impl.AbstractInventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.AdapterLogic;
import org.spongepowered.common.item.inventory.adapter.impl.comp.Inventory2DAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.comp.GridInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.InventoryColumnLens;
import org.spongepowered.common.item.inventory.lens.comp.InventoryRowLens;

public class GridInventoryAdapter
extends Inventory2DAdapter
implements GridInventory {
    protected final GridInventoryLens gridLens;
    protected final List<InventoryRow> rows = new ArrayList<InventoryRow>();
    protected final List<InventoryColumn> columns = new ArrayList<InventoryColumn>();

    public GridInventoryAdapter(Fabric inventory, GridInventoryLens root) {
        this(inventory, root, null);
    }

    public GridInventoryAdapter(Fabric inventory, GridInventoryLens root, Inventory parent) {
        super(inventory, root, parent);
        this.gridLens = root;
    }

    @Override
    public int getColumns() {
        return this.lens2d.getWidth();
    }

    @Override
    public int getRows() {
        return this.lens2d.getHeight();
    }

    @Override
    public Vector2i getDimensions() {
        return new Vector2i(this.getColumns(), this.getRows());
    }

    @Override
    public Optional<Slot> getSlot(int x, int y) {
        return AbstractInventoryAdapter.forSlot(this.bridge$getFabric(), this.getSlotLens(x, y), this);
    }

    @Override
    public Optional<InventoryRow> getRow(int y) {
        try {
            InventoryRowLens rowLens = this.gridLens.getRow(y);
            return Optional.ofNullable((InventoryRow)((Object)rowLens.getAdapter(this.bridge$getFabric(), this)));
        }
        catch (IndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<InventoryColumn> getColumn(int x) {
        try {
            InventoryColumnLens columnLens = this.gridLens.getColumn(x);
            return Optional.ofNullable((InventoryColumn)((Object)columnLens.getAdapter(this.bridge$getFabric(), this)));
        }
        catch (IndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<ItemStack> poll(int x, int y) {
        return AdapterLogic.pollSequential(this.bridge$getFabric(), this.getSlotLens(x, y));
    }

    @Override
    public Optional<ItemStack> poll(int x, int y, int limit) {
        return AdapterLogic.pollSequential(this.bridge$getFabric(), this.getSlotLens(x, y), limit);
    }

    @Override
    public Optional<ItemStack> peek(int x, int y) {
        return AdapterLogic.peekSequential(this.bridge$getFabric(), this.getSlotLens(x, y));
    }

    @Override
    public Optional<ItemStack> peek(int x, int y, int limit) {
        return AdapterLogic.peekSequential(this.bridge$getFabric(), this.getSlotLens(x, y), limit);
    }

    @Override
    public InventoryTransactionResult set(int x, int y, ItemStack stack) {
        return AdapterLogic.insertSequential(this.bridge$getFabric(), this.getSlotLens(x, y), stack);
    }
}

