/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.minecraft.container;

import java.util.Collections;
import java.util.List;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.RealLens;

public class ContainerLens
extends RealLens {
    protected List<Lens> viewedInventories;
    private List<Lens> additonal = Collections.emptyList();

    public ContainerLens(int size, Class<? extends Inventory> adapter, SlotProvider slots, List<Lens> lenses) {
        this(size, adapter, slots, lenses, Collections.emptyList());
    }

    public ContainerLens(int size, Class<? extends Inventory> adapter, SlotProvider slots, List<Lens> lenses, List<Lens> additonal) {
        this(size, adapter);
        this.viewedInventories = lenses;
        this.additonal = additonal;
        this.init(slots);
    }

    public ContainerLens(int size, Class<? extends Inventory> adapter) {
        super(0, size, adapter);
    }

    protected void init(SlotProvider slots) {
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            this.addChild(slots.getSlot(slot), new SlotIndex(ord));
            ++ord;
            ++slot;
        }
        for (Lens lens : this.viewedInventories) {
            this.addSpanningChild(lens, new InventoryProperty[0]);
        }
        for (Lens lens : this.additonal) {
            this.addChild(lens, new InventoryProperty[0]);
        }
    }
}

