/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.query.result;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.AbstractInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.MutableLensSet;
import org.spongepowered.common.item.inventory.query.Query;
import org.spongepowered.common.item.inventory.query.result.QueryResult;

public class MinecraftResultAdapterProvider
implements Query.ResultAdapterProvider {
    private MutableLensSet resultSet;

    @Override
    public QueryResult getResultAdapter(Fabric inventory, MutableLensSet matches, Inventory parent) {
        this.resultSet = matches;
        return new MinecraftQueryResultAdapter(inventory, parent);
    }

    protected MutableLensSet getResultSet() {
        return this.resultSet;
    }

    protected int getResultSize() {
        IntOpenHashSet slots = new IntOpenHashSet();
        for (Lens lens : this.getResultSet()) {
            slots.addAll((IntCollection)lens.getSlots());
        }
        return slots.size();
    }

    public class MinecraftQueryResultAdapter
    extends AbstractInventoryAdapter
    implements QueryResult {
        public MinecraftQueryResultAdapter(Fabric inventory, Inventory parent) {
            super(inventory, null, parent);
        }

        @Override
        protected Lens initRootLens() {
            return new MinecraftQueryLens(MinecraftResultAdapterProvider.this.getResultSize(), MinecraftResultAdapterProvider.this.getResultSet());
        }

        public class MinecraftQueryLens
        extends QueryResult.QueryLens {
            public MinecraftQueryLens(int size, MutableLensSet resultSet) {
                super(size, resultSet);
            }

            @Override
            public InventoryAdapter getAdapter(Fabric inv, Inventory parent) {
                return MinecraftQueryResultAdapter.this;
            }
        }
    }
}

