/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.world.World;
import org.spongepowered.common.item.recipe.crafting.AbstractSpongeCraftingRecipe;

public class DelegateSpongeCraftingRecipe
extends AbstractSpongeCraftingRecipe {
    private final CraftingRecipe recipe;
    private final String id;

    public DelegateSpongeCraftingRecipe(CraftingRecipe recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"recipe");
        this.recipe = recipe;
        this.id = recipe.getId();
    }

    public CraftingRecipe getDelegate() {
        return this.recipe;
    }

    @Override
    public ItemStackSnapshot getExemplaryResult() {
        return this.recipe.getExemplaryResult();
    }

    @Override
    public boolean isValid(CraftingGridInventory grid, World world) {
        return this.recipe.isValid(grid, world);
    }

    @Override
    public ItemStackSnapshot getResult(CraftingGridInventory grid) {
        return this.recipe.getResult(grid);
    }

    @Override
    public List<ItemStackSnapshot> getRemainingItems(CraftingGridInventory grid) {
        return this.recipe.getRemainingItems(grid);
    }

    @Override
    public Optional<String> getGroup() {
        return this.recipe.getGroup();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.recipe.getName();
    }

    public boolean func_192399_d() {
        return true;
    }
}

