/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.launch.transformer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.CheckClassAdapter;
import org.spongepowered.common.launch.transformer.SpongeSuperclassRegistry;

public class SpongeSuperclassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        String superclass = SpongeSuperclassRegistry.getSuperclass(name);
        if (superclass != null) {
            ClassNode node = this.readClass(basicClass);
            node.methods.stream().forEach(m -> this.transformMethod((MethodNode)m, name, node.superName, superclass));
            node.superName = superclass;
            node.accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)new ClassWriter(0)));
            ClassWriter writer = new ClassWriter(0);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    private void transformMethod(MethodNode node, String name, String originalSuperclass, String superClass) {
        for (MethodInsnNode insn : this.findSuper(node, originalSuperclass, name)) {
            insn.owner = superClass;
        }
    }

    private List<MethodInsnNode> findSuper(MethodNode method, String originalSuperClass, String name) {
        ArrayList<MethodInsnNode> nodes = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode node : method.instructions.toArray()) {
            if (node.getOpcode() != 183 || !originalSuperClass.equals(((MethodInsnNode)node).owner)) continue;
            nodes.add((MethodInsnNode)node);
        }
        return nodes;
    }

    private ClassNode readClass(byte[] basicClass) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }
}

