/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.property.PropertyStore;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.effect.Viewer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.EnderPearl;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.text.BookView;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatType;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Functional;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.ChunkPreGenerate;
import org.spongepowered.api.world.ChunkRegenerateFlag;
import org.spongepowered.api.world.Dimension;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.EntityUniverse;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.worker.MutableBiomeVolumeWorker;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.mixin.core.network.play.server.SPacketBlockChangeAccessor;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.util.BookFaker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeDimension;
import org.spongepowered.common.world.extent.ExtentViewDownsize;
import org.spongepowered.common.world.extent.worker.SpongeMutableBiomeVolumeWorker;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;
import org.spongepowered.common.world.pregen.SpongeChunkPreGenerateTask;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

@Mixin(value={net.minecraft.world.World.class})
public abstract class WorldMixin_API
implements World {
    @Shadow
    @Final
    public boolean field_72995_K;
    @Shadow
    @Final
    public WorldProvider field_73011_w;
    @Shadow
    @Final
    public Random field_73012_v;
    @Shadow
    @Final
    public Profiler field_72984_F;
    @Shadow
    @Final
    public List<EntityPlayer> field_73010_i;
    @Shadow
    @Final
    public List<net.minecraft.entity.Entity> field_72996_f;
    @Shadow
    @Final
    public List<TileEntity> field_147482_g;
    @Shadow
    @Final
    protected ISaveHandler field_73019_z;
    @Shadow
    protected List<IWorldEventListener> field_73021_x;
    @Shadow
    private int field_181546_a;
    @Shadow
    protected WorldInfo field_72986_A;
    @Nullable
    private Context worldContext;
    boolean processingExplosion = false;
    @Nullable
    private SpongeDimension api$dimension;
    private MessageChannel impl$messageChannel;

    @Shadow
    public abstract net.minecraft.world.border.WorldBorder shadow$func_175723_af();

    @Shadow
    public net.minecraft.world.World func_175643_b() {
        throw new RuntimeException("Bad things have happened");
    }

    @Shadow
    public abstract net.minecraft.world.chunk.Chunk func_175726_f(BlockPos var1);

    @Shadow
    public abstract WorldInfo func_72912_H();

    @Shadow
    public abstract Biome func_180494_b(BlockPos var1);

    @Shadow
    public abstract net.minecraft.world.chunk.Chunk func_72964_e(int var1, int var2);

    @Shadow
    public abstract List<net.minecraft.entity.Entity> func_175644_a(Class<net.minecraft.entity.Entity> var1, com.google.common.base.Predicate<net.minecraft.entity.Entity> var2);

    @Shadow
    public abstract <T extends net.minecraft.entity.Entity> List<T> func_175647_a(Class<? extends T> var1, AxisAlignedBB var2, com.google.common.base.Predicate<? super T> var3);

    @Shadow
    public abstract MinecraftServer func_73046_m();

    @Shadow
    public abstract boolean func_175656_a(BlockPos var1, IBlockState var2);

    @Shadow
    public abstract boolean func_180501_a(BlockPos var1, IBlockState var2, int var3);

    @Shadow
    public abstract void func_184148_a(EntityPlayer var1, double var2, double var4, double var6, SoundEvent var8, SoundCategory var9, float var10, float var11);

    @Shadow
    public abstract BlockPos func_175725_q(BlockPos var1);

    @Shadow
    public abstract List<AxisAlignedBB> func_184144_a(net.minecraft.entity.Entity var1, AxisAlignedBB var2);

    @Shadow
    public abstract int func_189649_b(int var1, int var2);

    @Shadow
    public abstract IBlockState func_180495_p(BlockPos var1);

    @Shadow
    @Nullable
    public abstract TileEntity func_175625_s(BlockPos var1);

    @Override
    public Collection<Player> getPlayers() {
        return ImmutableList.copyOf((Collection)this.field_73010_i);
    }

    @Override
    public UUID getUniqueId() {
        WorldProperties properties = this.getProperties();
        UUID worldId = properties.getUniqueId();
        if (worldId == null) {
            WorldInfoBridge mixinWorldInfo = (WorldInfoBridge)((Object)properties);
            mixinWorldInfo.bridge$setUniqueId(UUID.randomUUID());
            return properties.getUniqueId();
        }
        return worldId;
    }

    @Override
    public Optional<Chunk> getChunk(int x, int y, int z) {
        if (!SpongeChunkLayout.instance.isValidChunk(x, y, z)) {
            return Optional.empty();
        }
        WorldServer worldserver = (WorldServer)this;
        return Optional.ofNullable((Chunk)worldserver.func_72863_F().func_186026_b(x, z));
    }

    @Override
    public Optional<Chunk> loadChunk(int x, int y, int z, boolean shouldGenerate) {
        if (!SpongeChunkLayout.instance.isValidChunk(x, y, z)) {
            return Optional.empty();
        }
        WorldServer worldserver = (WorldServer)this;
        if (!shouldGenerate) {
            return Optional.ofNullable((Chunk)worldserver.func_72863_F().func_186028_c(x, z));
        }
        return Optional.ofNullable((Chunk)worldserver.func_72863_F().func_186025_d(x, z));
    }

    @Override
    public Optional<Chunk> regenerateChunk(int cx, int cy, int cz, ChunkRegenerateFlag flag) {
        return Optional.empty();
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return this.func_189649_b(x, z);
    }

    @Override
    public int getPrecipitationLevelAt(int x, int z) {
        return this.func_175725_q(new BlockPos(x, 0, z)).func_177956_o();
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return (BlockState)this.func_180495_p(new BlockPos(x, y, z));
    }

    @Override
    public BlockType getBlockType(int x, int y, int z) {
        return (BlockType)this.func_72964_e(x >> 4, z >> 4).func_177435_g(new BlockPos(x, y, z)).func_177230_c();
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        return this.setBlock(x, y, z, block, BlockChangeFlags.ALL);
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        return (BiomeType)this.func_180494_b(new BlockPos(x, y, z));
    }

    @Override
    public void setBiome(int x, int y, int z, BiomeType biome) {
        this.checkBiomeBounds(x, y, z);
        ((Chunk)this.func_72964_e(x >> 4, z >> 4)).setBiome(x, y, z, biome);
    }

    @Override
    public Collection<Entity> getEntities() {
        return Lists.newArrayList((Iterable)this.field_72996_f);
    }

    @Override
    public Collection<Entity> getEntities(Predicate<Entity> filter) {
        return this.func_175644_a(net.minecraft.entity.Entity.class, Functional.java8ToGuava(filter));
    }

    @Override
    public Entity createEntity(EntityType type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return this.createEntity(type, position, false);
    }

    @Override
    public Entity createEntityNaturally(EntityType type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return this.createEntity(type, position, true);
    }

    private Entity createEntity(EntityType type, Vector3d position, boolean naturally) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull((Object)type, (Object)"The entity type cannot be null!");
        Preconditions.checkNotNull((Object)position, (Object)"The position cannot be null!");
        Entity entity = null;
        Class<? extends Entity> entityClass = type.getEntityClass();
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        if (entityClass.isAssignableFrom(EntityPlayerMP.class) || entityClass.isAssignableFrom(MultiPartEntityPart.class)) {
            throw new IllegalArgumentException("Cannot construct " + type.getId() + " please look to using entity types correctly!");
        }
        net.minecraft.world.World world = (net.minecraft.world.World)this;
        if (entityClass.isAssignableFrom(EntityLightningBolt.class)) {
            entity = (Entity)new EntityLightningBolt(world, x, y, z, false);
        } else if (entityClass.isAssignableFrom(EntityEnderPearl.class)) {
            EntityArmorStand tempEntity = new EntityArmorStand(world, x, y, z);
            tempEntity.field_70163_u -= (double)tempEntity.func_70047_e();
            entity = (Entity)new EntityEnderPearl(world, (EntityLivingBase)tempEntity);
            ((EnderPearl)entity).setShooter(ProjectileSource.UNKNOWN);
        }
        if (entityClass.isAssignableFrom(EntityFallingBlock.class)) {
            entity = (Entity)new EntityFallingBlock(world, x, y, z, Blocks.field_150354_m.func_176223_P());
        } else if (entityClass.isAssignableFrom(EntityItem.class)) {
            entity = (Entity)new EntityItem(world, x, y, z, new ItemStack(Blocks.field_150348_b));
        }
        if (entity == null) {
            try {
                entity = (Entity)ConstructorUtils.invokeConstructor(entityClass, (Object[])new Object[]{this});
                ((net.minecraft.entity.Entity)entity).func_70107_b(x, y, z);
            }
            catch (Exception e) {
                throw new RuntimeException("There was an issue attempting to construct " + type.getId(), e);
            }
        }
        if (naturally && entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_180482_a(world.func_175649_E(new BlockPos(x, y, z)), null);
        }
        if (entity instanceof EntityPainting) {
            ((EntityPainting)entity).field_70522_e = EntityPainting.EnumArt.KEBAB;
        }
        return entity;
    }

    @Override
    public Optional<Entity> createEntity(DataContainer entityContainer) {
        return Optional.empty();
    }

    @Override
    public Optional<Entity> createEntity(DataContainer entityContainer, Vector3d position) {
        return Optional.empty();
    }

    @Override
    public Optional<Entity> restoreSnapshot(EntitySnapshot snapshot, Vector3d position) {
        EntitySnapshot entitySnapshot = (EntitySnapshot)snapshot.withLocation(new Location<World>(this, position));
        return entitySnapshot.restore();
    }

    @Override
    public WorldBorder getWorldBorder() {
        return (WorldBorder)this.shadow$func_175723_af();
    }

    @Override
    public ChunkPreGenerate.Builder newChunkPreGenerate(Vector3d center, double diameter) {
        return new SpongeChunkPreGenerateTask.Builder(this, center, diameter);
    }

    @Override
    public Dimension getDimension() {
        if (this.api$dimension == null) {
            this.api$dimension = new SpongeDimension(this.field_73011_w);
        }
        return this.api$dimension;
    }

    @Override
    public Optional<Entity> getEntity(UUID uuid) {
        for (net.minecraft.entity.Entity entity : this.field_72996_f) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return Optional.of((Entity)entity);
        }
        return Optional.empty();
    }

    @Override
    public Iterable<Chunk> getLoadedChunks() {
        if (((WorldBridge)((Object)this)).bridge$isFake()) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)((WorldServer)this).func_72863_F().func_189548_a());
    }

    @Override
    public boolean unloadChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"Chunk cannot be null!");
        return chunk.unloadChunk();
    }

    @Override
    public WorldProperties getProperties() {
        return (WorldProperties)this.field_72986_A;
    }

    @Override
    public Context getContext() {
        if (this.worldContext == null) {
            WorldInfo worldInfo = this.func_72912_H();
            if (worldInfo == null) {
                worldInfo = new WorldInfo(new WorldSettings(0L, GameType.NOT_SET, false, false, WorldType.field_77137_b), "sponge$dummy_World");
            }
            this.worldContext = new Context("world", worldInfo.func_76065_j());
        }
        return this.worldContext;
    }

    @Override
    public Optional<org.spongepowered.api.block.tileentity.TileEntity> getTileEntity(int x, int y, int z) {
        TileEntity tileEntity = this.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity == null) {
            return Optional.empty();
        }
        return Optional.of((org.spongepowered.api.block.tileentity.TileEntity)tileEntity);
    }

    @Override
    public Vector3i getBiomeMin() {
        return Constants.World.BIOME_MIN;
    }

    @Override
    public Vector3i getBiomeMax() {
        return Constants.World.BIOME_MAX;
    }

    @Override
    public Vector3i getBiomeSize() {
        return Constants.World.BIOME_SIZE;
    }

    @Override
    public Vector3i getBlockMin() {
        return Constants.World.BLOCK_MIN;
    }

    @Override
    public Vector3i getBlockMax() {
        return Constants.World.BLOCK_MAX;
    }

    @Override
    public Vector3i getBlockSize() {
        return Constants.World.BLOCK_SIZE;
    }

    @Override
    public boolean containsBiome(int x, int y, int z) {
        return VecHelper.inBounds(x, y, z, Constants.World.BIOME_MIN, Constants.World.BIOME_MAX);
    }

    @Override
    public boolean containsBlock(int x, int y, int z) {
        return VecHelper.inBounds(x, y, z, Constants.World.BLOCK_MIN, Constants.World.BLOCK_MAX);
    }

    private void checkBiomeBounds(int x, int y, int z) {
        if (!this.containsBiome(x, y, z)) {
            throw new PositionOutOfBoundsException(new Vector3i(x, y, z), Constants.World.BIOME_MIN, Constants.World.BIOME_MAX);
        }
    }

    protected void checkBlockBounds(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            throw new PositionOutOfBoundsException(new Vector3i(x, y, z), Constants.World.BLOCK_MIN, Constants.World.BLOCK_MAX);
        }
    }

    @Override
    public void sendMessage(ChatType type, Text message) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        Preconditions.checkNotNull((Object)message, (Object)"message");
        this.getMessageChannel().send(message, type);
    }

    @Override
    public void sendMessage(Text message) {
        this.sendMessage(ChatTypes.CHAT, message);
    }

    @Override
    public MessageChannel getMessageChannel() {
        if (this.impl$messageChannel == null) {
            return MessageChannel.fixed(this.getPlayers());
        }
        return this.impl$messageChannel;
    }

    @Override
    public void setMessageChannel(MessageChannel channel) {
        this.impl$messageChannel = channel;
    }

    @Override
    public void sendTitle(Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"title");
        for (Player player : this.getPlayers()) {
            player.sendTitle(title);
        }
    }

    @Override
    public void sendBookView(BookView bookView) {
        Preconditions.checkNotNull((Object)bookView, (Object)"bookView");
        BookFaker.fakeBookView(bookView, this.getPlayers());
    }

    @Override
    public void resetTitle() {
        this.getPlayers().forEach(Viewer::resetTitle);
    }

    @Override
    public void clearTitle() {
        this.getPlayers().forEach(Viewer::clearTitle);
    }

    @Override
    public Collection<org.spongepowered.api.block.tileentity.TileEntity> getTileEntities() {
        return Lists.newArrayList(this.field_147482_g);
    }

    @Override
    public Collection<org.spongepowered.api.block.tileentity.TileEntity> getTileEntities(Predicate<org.spongepowered.api.block.tileentity.TileEntity> filter) {
        return this.field_147482_g.stream().filter(filter).collect(Collectors.toList());
    }

    @Override
    public void triggerExplosion(org.spongepowered.api.world.explosion.Explosion explosion) {
        Preconditions.checkNotNull((Object)explosion, (Object)"explosion");
        ((Explosion)explosion).func_77278_a();
        ((Explosion)explosion).func_77279_a(true);
    }

    @Override
    public Extent getExtentView(Vector3i newMin, Vector3i newMax) {
        return new ExtentViewDownsize(this, newMin, newMax);
    }

    @Override
    public MutableBiomeVolumeWorker<World> getBiomeWorker() {
        return new SpongeMutableBiomeVolumeWorker<World>(this);
    }

    @Override
    public MutableBlockVolumeWorker<World> getBlockWorker() {
        return new SpongeMutableBlockVolumeWorker<World>(this);
    }

    @Override
    public BlockSnapshot createSnapshot(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            return BlockSnapshot.NONE;
        }
        WorldMixin_API world = this;
        BlockState state = world.getBlock(x, y, z);
        Optional<org.spongepowered.api.block.tileentity.TileEntity> te = world.getTileEntity(x, y, z);
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled().blockState(state).worldId(world.getUniqueId()).position(new Vector3i(x, y, z));
        Optional<UUID> creator = this.getCreator(x, y, z);
        Optional<UUID> notifier = this.getNotifier(x, y, z);
        if (creator.isPresent()) {
            builder.creator(creator.get());
        }
        if (notifier.isPresent()) {
            builder.notifier(notifier.get());
        }
        if (te.isPresent()) {
            org.spongepowered.api.block.tileentity.TileEntity tileEntity = te.get();
            for (DataManipulator<?, ?> manipulator : ((CustomDataHolderBridge)((Object)tileEntity)).bridge$getCustomManipulators()) {
                builder.add((DataManipulator)manipulator);
            }
            NBTTagCompound compound = new NBTTagCompound();
            ((TileEntity)tileEntity).func_189515_b(compound);
            builder.unsafeNbt(compound);
        }
        return builder.build();
    }

    @Override
    public boolean restoreSnapshot(BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return snapshot.restore(force, flag);
    }

    @Override
    public boolean restoreSnapshot(int x, int y, int z, BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        snapshot = (BlockSnapshot)snapshot.withLocation(new Location<World>(this, new Vector3i(x, y, z)));
        return snapshot.restore(force, flag);
    }

    @Override
    public Optional<UUID> getCreator(int x, int y, int z) {
        return Optional.empty();
    }

    @Override
    public Optional<UUID> getNotifier(int x, int y, int z) {
        return Optional.empty();
    }

    @Override
    public void setCreator(int x, int y, int z, @Nullable UUID uuid) {
    }

    @Override
    public void setNotifier(int x, int y, int z, @Nullable UUID uuid) {
    }

    @Override
    public Optional<AABB> getBlockSelectionBox(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = this.func_180495_p(pos);
        AxisAlignedBB box = state.func_185900_c((IBlockAccess)this, pos);
        try {
            return Optional.of(VecHelper.toSpongeAABB(box).offset(x, y, z));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    @Override
    public Set<Entity> getIntersectingEntities(AABB box, Predicate<Entity> filter) {
        Preconditions.checkNotNull((Object)box, (Object)"box");
        Preconditions.checkNotNull(filter, (Object)"filter");
        return this.func_175647_a(net.minecraft.entity.Entity.class, VecHelper.toMinecraftAABB(box), entity -> filter.test((Entity)entity)).stream().map(entity -> (Entity)entity).collect(Collectors.toSet());
    }

    @Override
    public Set<AABB> getIntersectingBlockCollisionBoxes(AABB box) {
        Preconditions.checkNotNull((Object)box, (Object)"box");
        return this.func_184144_a(null, VecHelper.toMinecraftAABB(box)).stream().map(VecHelper::toSpongeAABB).collect(Collectors.toSet());
    }

    @Override
    public Set<AABB> getIntersectingCollisionBoxes(Entity owner, AABB box) {
        Preconditions.checkNotNull((Object)owner, (Object)"owner");
        Preconditions.checkNotNull((Object)box, (Object)"box");
        return this.func_184144_a((net.minecraft.entity.Entity)owner, VecHelper.toMinecraftAABB(box)).stream().map(VecHelper::toSpongeAABB).collect(Collectors.toSet());
    }

    @Override
    public Set<EntityUniverse.EntityHit> getIntersectingEntities(Vector3d start, Vector3d end, Predicate<EntityUniverse.EntityHit> filter) {
        Preconditions.checkNotNull((Object)start, (Object)"start");
        Preconditions.checkNotNull((Object)end, (Object)"end");
        Vector3d diff = end.sub(start);
        return this.getIntersectingEntities(start, diff.normalize(), diff.length(), filter);
    }

    @Override
    public Set<EntityUniverse.EntityHit> getIntersectingEntities(Vector3d start, Vector3d direction, double distance, Predicate<EntityUniverse.EntityHit> filter) {
        Preconditions.checkNotNull((Object)start, (Object)"start");
        Preconditions.checkNotNull((Object)direction, (Object)"direction");
        Preconditions.checkNotNull(filter, (Object)"filter");
        direction = direction.normalize();
        if (direction.getX() == 0.0 && direction.getZ() == 0.0) {
            return this.getIntersectingEntities(start, direction.getY(), distance, filter);
        }
        int chunkWidth = SpongeChunkLayout.CHUNK_SIZE.getX();
        int xPlaneIncrement = direction.getX() >= 0.0 ? chunkWidth : -chunkWidth;
        int zPlaneIncrement = direction.getZ() >= 0.0 ? chunkWidth : -chunkWidth;
        double xInChunk = GenericMath.mod(start.getX(), (double)chunkWidth);
        double zInChunk = GenericMath.mod(start.getZ(), (double)chunkWidth);
        int xPlaneNext = (int)(start.getX() - xInChunk);
        int zPlaneNext = (int)(start.getZ() - zInChunk);
        if (xInChunk != 0.0 && direction.getX() < 0.0) {
            xPlaneNext += chunkWidth;
        }
        if (zInChunk != 0.0 && direction.getZ() < 0.0) {
            zPlaneNext += chunkWidth;
        }
        double xPlaneT = ((double)xPlaneNext - start.getX()) / direction.getX();
        double zPlaneT = ((double)zPlaneNext - start.getZ()) / direction.getZ();
        double currentT = 0.0;
        double xCurrent = start.getX();
        double yCurrent = start.getY();
        double zCurrent = start.getZ();
        double remainingDistance = distance;
        HashSet<EntityUniverse.EntityHit> intersecting = new HashSet<EntityUniverse.EntityHit>();
        do {
            double zNext;
            double xNext;
            double nextT;
            if (xPlaneT < zPlaneT) {
                nextT = xPlaneT;
                xNext = xPlaneNext;
                zNext = direction.getZ() * nextT + start.getZ();
                xPlaneT = ((double)(xPlaneNext += xPlaneIncrement) - start.getX()) / direction.getX();
            } else {
                nextT = zPlaneT;
                xNext = direction.getX() * nextT + start.getX();
                zNext = zPlaneNext;
                zPlaneT = ((double)(zPlaneNext += zPlaneIncrement) - start.getZ()) / direction.getZ();
            }
            double yNext = direction.getY() * Math.min(nextT, distance) + start.getY();
            if (nextT >= 0.0) {
                ChunkBridge nearIntersections;
                int zChunk;
                xInChunk = GenericMath.mod(xCurrent, (double)chunkWidth);
                int xChunk = (int)(xCurrent - (xInChunk == 0.0 && direction.getX() < 0.0 ? (double)chunkWidth : xInChunk));
                Optional<Chunk> chunk = this.getChunkAtBlock(xChunk, 0, zChunk = (int)(zCurrent - ((zInChunk = GenericMath.mod(zCurrent, (double)chunkWidth)) == 0.0 && direction.getZ() < 0.0 ? (double)chunkWidth : zInChunk)));
                if (chunk.isPresent()) {
                    ((ChunkBridge)((Object)chunk.get())).bridge$getIntersectingEntities(start, direction, distance, filter, yCurrent, yNext, intersecting);
                }
                if ((nearIntersections = this.getChunkNearIntersections(xChunk, zChunk, xCurrent, zCurrent, xNext, zNext)) != null) {
                    nearIntersections.bridge$getIntersectingEntities(start, direction, distance, filter, yCurrent, yNext, intersecting);
                }
                remainingDistance -= nextT - Math.max(0.0, currentT);
            }
            currentT = nextT;
            xCurrent = xNext;
            yCurrent = yNext;
            zCurrent = zNext;
        } while (remainingDistance >= 0.0);
        return intersecting;
    }

    private ChunkBridge getChunkNearIntersections(int xChunk, int zChunk, double xCurrent, double zCurrent, double xNext, double zNext) {
        boolean d24;
        boolean d23;
        boolean d22;
        boolean d21;
        int chunkWidth = SpongeChunkLayout.CHUNK_SIZE.getX();
        Vector2d c1 = new Vector2d(xChunk, zChunk);
        Vector2d c2 = new Vector2d(xChunk + chunkWidth, zChunk);
        Vector2d c3 = new Vector2d(xChunk, zChunk + chunkWidth);
        Vector2d c4 = new Vector2d(xChunk + chunkWidth, zChunk + chunkWidth);
        int nearDistance2 = 4;
        boolean d11 = c1.distanceSquared(xCurrent, zCurrent) <= 4.0;
        boolean bl = d21 = c1.distanceSquared(xNext, zNext) <= 4.0;
        if (d11 && d21) {
            return this.getChunkAtBlock(xChunk - chunkWidth, 0, zChunk - chunkWidth).orElse(null);
        }
        boolean d12 = c2.distanceSquared(xCurrent, zCurrent) <= 4.0;
        boolean bl2 = d22 = c2.distanceSquared(xNext, zNext) <= 4.0;
        if (d12 && d22) {
            return this.getChunkAtBlock(xChunk + chunkWidth, 0, zChunk - chunkWidth).orElse(null);
        }
        boolean d13 = c3.distanceSquared(xCurrent, zCurrent) <= 4.0;
        boolean bl3 = d23 = c3.distanceSquared(xNext, zNext) <= 4.0;
        if (d13 && d23) {
            return this.getChunkAtBlock(xChunk - chunkWidth, 0, zChunk + chunkWidth).orElse(null);
        }
        boolean d14 = c4.distanceSquared(xCurrent, zCurrent) <= 4.0;
        boolean bl4 = d24 = c4.distanceSquared(xNext, zNext) <= 4.0;
        if (d14 && d24) {
            return this.getChunkAtBlock(xChunk + chunkWidth, 0, zChunk + chunkWidth).orElse(null);
        }
        if (d11 && d23 || d21 && d13) {
            return this.getChunkAtBlock(xChunk - chunkWidth, 0, zChunk).orElse(null);
        }
        if (d11 && d22 || d21 && d12) {
            return this.getChunkAtBlock(xChunk, 0, zChunk - chunkWidth).orElse(null);
        }
        if (d14 && d22 || d24 && d12) {
            return this.getChunkAtBlock(xChunk + chunkWidth, 0, zChunk).orElse(null);
        }
        if (d14 && d23 || d24 && d13) {
            return this.getChunkAtBlock(xChunk, 0, zChunk + chunkWidth).orElse(null);
        }
        return null;
    }

    private Set<EntityUniverse.EntityHit> getIntersectingEntities(Vector3d start, double yDirection, double distance, Predicate<EntityUniverse.EntityHit> filter) {
        HashSet<EntityUniverse.EntityHit> intersecting = new HashSet<EntityUniverse.EntityHit>();
        Vector3d direction = yDirection < 0.0 ? Vector3d.UNIT_Y.negate() : Vector3d.UNIT_Y;
        double endY = start.getY() + yDirection * distance;
        Vector3i chunkPos = SpongeChunkLayout.instance.forceToChunk(start.toInt());
        ((ChunkBridge)((Object)this.getChunk(chunkPos).get())).bridge$getIntersectingEntities(start, direction, distance, filter, start.getY(), endY, intersecting);
        int nearDistance = 2;
        Vector3i chunkBlockPos = SpongeChunkLayout.instance.forceToWorld(chunkPos);
        if (start.getX() - (double)chunkBlockPos.getX() <= 2.0) {
            ((ChunkBridge)((Object)this.getChunk(chunkPos.add(-1, 0, 0)).get())).bridge$getIntersectingEntities(start, direction, distance, filter, start.getY(), endY, intersecting);
        }
        if (start.getZ() - (double)chunkBlockPos.getZ() <= 2.0) {
            ((ChunkBridge)((Object)this.getChunk(chunkPos.add(0, 0, -1)).get())).bridge$getIntersectingEntities(start, direction, distance, filter, start.getY(), endY, intersecting);
        }
        int chunkWidth = SpongeChunkLayout.CHUNK_SIZE.getX();
        if ((double)(chunkBlockPos.getX() + chunkWidth) - start.getX() <= 2.0) {
            ((ChunkBridge)((Object)this.getChunk(chunkPos.add(1, 0, 0)).get())).bridge$getIntersectingEntities(start, direction, distance, filter, start.getY(), endY, intersecting);
        }
        if ((double)(chunkBlockPos.getZ() + chunkWidth) - start.getZ() <= 2.0) {
            ((ChunkBridge)((Object)this.getChunk(chunkPos.add(0, 0, 1)).get())).bridge$getIntersectingEntities(start, direction, distance, filter, start.getY(), endY, intersecting);
        }
        return intersecting;
    }

    @Override
    public void sendBlockChange(int x, int y, int z, BlockState state) {
        Preconditions.checkNotNull((Object)state, (Object)"state");
        SPacketBlockChange packet = new SPacketBlockChange();
        ((SPacketBlockChangeAccessor)packet).accessor$setBlockPosition(new BlockPos(x, y, z));
        ((SPacketBlockChangeAccessor)packet).accessor$setBlockState((IBlockState)state);
        for (EntityPlayer player : this.field_73010_i) {
            if (!(player instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        SPacketBlockChange packet = new SPacketBlockChange((net.minecraft.world.World)this, new BlockPos(x, y, z));
        for (EntityPlayer player : this.field_73010_i) {
            if (!(player instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    @Override
    public int getSeaLevel() {
        return this.field_181546_a;
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(int x, int y, int z, Class<T> propertyClass) {
        Optional<PropertyStore<PropertyStore>> optional = Sponge.getPropertyRegistry().getStore(propertyClass);
        return optional.flatMap(tPropertyStore -> tPropertyStore.getFor(new Location<World>((World)this, x, y, z)));
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(int x, int y, int z, Direction direction, Class<T> propertyClass) {
        Optional<PropertyStore<PropertyStore>> optional = Sponge.getPropertyRegistry().getStore(propertyClass);
        return optional.flatMap(tPropertyStore -> tPropertyStore.getFor(new Location<World>((World)this, x, y, z), direction));
    }

    @Override
    public Collection<Property<?, ?>> getProperties(int x, int y, int z) {
        return SpongeImpl.getPropertyRegistry().getPropertiesFor(new Location<WorldMixin_API>(this, x, y, z));
    }

    @Override
    public Collection<Direction> getFacesWithProperty(int x, int y, int z, Class<? extends Property<?, ?>> propertyClass) {
        Optional<PropertyStore<Property<?, ?>>> optional = Sponge.getPropertyRegistry().getStore(propertyClass);
        if (!optional.isPresent()) {
            return Collections.emptyList();
        }
        PropertyStore<Property<?, ?>> store = optional.get();
        Location<World> loc = new Location<World>((World)this, x, y, z);
        ImmutableList.Builder faces = ImmutableList.builder();
        for (EnumFacing facing : EnumFacing.values()) {
            Direction direction = DirectionFacingProvider.getInstance().getKey(facing).get();
            if (!store.getFor(loc, direction).isPresent()) continue;
            faces.add((Object)direction);
        }
        return faces.build();
    }

    @Override
    public <E> Optional<E> get(int x, int y, int z, Key<? extends BaseValue<E>> key) {
        Optional optional = this.getBlock(x, y, z).withExtendedProperties(new Location<World>((World)this, x, y, z)).get(key);
        if (optional.isPresent()) {
            return optional;
        }
        Optional<org.spongepowered.api.block.tileentity.TileEntity> tileEntityOptional = this.getTileEntity(x, y, z);
        return tileEntityOptional.flatMap(tileEntity -> tileEntity.get(key));
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> get(int x, int y, int z, Class<T> manipulatorClass) {
        Collection<DataManipulator<?, ?>> manipulators = this.getManipulators(x, y, z);
        for (DataManipulator<?, ?> manipulator : manipulators) {
            if (!manipulatorClass.isInstance(manipulator)) continue;
            return Optional.of(manipulator);
        }
        return Optional.empty();
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> getOrCreate(int x, int y, int z, Class<T> manipulatorClass) {
        Optional<T> optional = this.get(x, y, z, manipulatorClass);
        if (optional.isPresent()) {
            return optional;
        }
        Optional<org.spongepowered.api.block.tileentity.TileEntity> tileEntity = this.getTileEntity(x, y, z);
        return tileEntity.flatMap(tileEntity1 -> tileEntity1.getOrCreate(manipulatorClass));
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(int x, int y, int z, Key<V> key) {
        BlockState blockState = this.getBlock(x, y, z).withExtendedProperties(new Location<World>((World)this, x, y, z));
        if (blockState.supports(key)) {
            return blockState.getValue(key);
        }
        Optional<org.spongepowered.api.block.tileentity.TileEntity> tileEntity = this.getTileEntity(x, y, z);
        if (tileEntity.isPresent() && tileEntity.get().supports(key)) {
            return tileEntity.get().getValue(key);
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(int x, int y, int z, Key<?> key) {
        BlockState blockState = this.getBlock(x, y, z);
        boolean blockSupports = blockState.supports(key);
        Optional<org.spongepowered.api.block.tileentity.TileEntity> tileEntity = this.getTileEntity(x, y, z);
        boolean tileEntitySupports = tileEntity.isPresent() && tileEntity.get().supports(key);
        return blockSupports || tileEntitySupports;
    }

    @Override
    public boolean supports(int x, int y, int z, Class<? extends DataManipulator<?, ?>> manipulatorClass) {
        BlockState blockState = this.getBlock(x, y, z);
        List<ImmutableDataManipulator<?, ?>> immutableDataManipulators = blockState.getManipulators();
        boolean blockSupports = false;
        for (ImmutableDataManipulator<?, ?> manipulator : immutableDataManipulators) {
            if (!manipulator.asMutable().getClass().isAssignableFrom(manipulatorClass)) continue;
            blockSupports = true;
            break;
        }
        if (!blockSupports) {
            Optional<org.spongepowered.api.block.tileentity.TileEntity> tileEntity = this.getTileEntity(x, y, z);
            boolean tileEntitySupports = tileEntity.isPresent() && tileEntity.get().supports(manipulatorClass);
            return tileEntitySupports;
        }
        return true;
    }

    @Override
    public Set<Key<?>> getKeys(int x, int y, int z) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        BlockState blockState = this.getBlock(x, y, z).withExtendedProperties(new Location<World>((World)this, x, y, z));
        builder.addAll(blockState.getKeys());
        Optional<org.spongepowered.api.block.tileentity.TileEntity> tileEntity = this.getTileEntity(x, y, z);
        tileEntity.ifPresent(tileEntity1 -> builder.addAll(tileEntity1.getKeys()));
        return builder.build();
    }

    @Override
    public Set<ImmutableValue<?>> getValues(int x, int y, int z) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        BlockState blockState = this.getBlock(x, y, z).withExtendedProperties(new Location<World>((World)this, x, y, z));
        builder.addAll(blockState.getValues());
        Optional<org.spongepowered.api.block.tileentity.TileEntity> tileEntity = this.getTileEntity(x, y, z);
        tileEntity.ifPresent(tileEntity1 -> builder.addAll(tileEntity1.getValues()));
        return builder.build();
    }

    @Override
    public <E> DataTransactionResult offer(int x, int y, int z, Key<? extends BaseValue<E>> key, E value) {
        BlockState blockState = this.getBlock(x, y, z).withExtendedProperties(new Location<World>((World)this, x, y, z));
        if (blockState.supports(key)) {
            ImmutableValue old = this.getValue(x, y, z, key).map(v -> (Value)v).get().asImmutable();
            this.setBlock(x, y, z, (BlockState)blockState.with(key, value).get());
            ImmutableValue newVal = this.getValue(x, y, z, key).map(v -> (Value)v).get().asImmutable();
            return DataTransactionResult.successReplaceResult(newVal, old);
        }
        return this.getTileEntity(x, y, z).map(tileEntity -> tileEntity.offer(key, value)).orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    public DataTransactionResult offer(int x, int y, int z, DataManipulator<?, ?> manipulator, MergeFunction function) {
        Object immutableDataManipulator;
        BlockState blockState = this.getBlock(x, y, z).withExtendedProperties(new Location<World>((World)this, x, y, z));
        if (blockState.supports((immutableDataManipulator = manipulator.asImmutable()).getClass())) {
            ArrayList old = new ArrayList(blockState.getValues());
            BlockState newState = (BlockState)blockState.with(immutableDataManipulator).get();
            old.removeAll(newState.getValues());
            this.setBlock(x, y, z, newState);
            return DataTransactionResult.successReplaceResult(old, manipulator.getValues());
        }
        return this.getTileEntity(x, y, z).map(tileEntity -> tileEntity.offer(manipulator, function)).orElseGet(() -> DataTransactionResult.failResult(manipulator.getValues()));
    }

    @Override
    public DataTransactionResult remove(int x, int y, int z, Class<? extends DataManipulator<?, ?>> manipulatorClass) {
        Optional<org.spongepowered.api.block.tileentity.TileEntity> tileEntityOptional = this.getTileEntity(x, y, z);
        return tileEntityOptional.map(tileEntity -> tileEntity.remove(manipulatorClass)).orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    public DataTransactionResult remove(int x, int y, int z, Key<?> key) {
        Optional<org.spongepowered.api.block.tileentity.TileEntity> tileEntityOptional = this.getTileEntity(x, y, z);
        return tileEntityOptional.map(tileEntity -> tileEntity.remove(key)).orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    public DataTransactionResult undo(int x, int y, int z, DataTransactionResult result) {
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, DataHolder from) {
        return this.copyFrom(xTo, yTo, zTo, from, MergeFunction.IGNORE_ALL);
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, DataHolder from, MergeFunction function) {
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        Collection manipulators = from.getContainers();
        for (DataManipulator manipulator : manipulators) {
            builder.absorbResult(this.offer(xTo, yTo, zTo, manipulator, function));
        }
        return builder.build();
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, int xFrom, int yFrom, int zFrom, MergeFunction function) {
        return this.copyFrom(xTo, yTo, zTo, new Location<WorldMixin_API>(this, xFrom, yFrom, zFrom), function);
    }

    @Override
    public Collection<DataManipulator<?, ?>> getManipulators(int x, int y, int z) {
        ArrayList list = new ArrayList();
        List<ImmutableDataManipulator<?, ?>> manipulators = this.getBlock(x, y, z).withExtendedProperties(new Location<World>((World)this, x, y, z)).getManipulators();
        for (ImmutableDataManipulator immutableDataManipulator : manipulators) {
            list.add((DataManipulator<?, ?>)immutableDataManipulator.asMutable());
        }
        Optional<org.spongepowered.api.block.tileentity.TileEntity> optional = this.getTileEntity(x, y, z);
        optional.ifPresent(tileEntity -> list.addAll(tileEntity.getContainers()));
        return list;
    }

    @Override
    public boolean validateRawData(int x, int y, int z, DataView container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRawData(int x, int y, int z, DataView container) throws InvalidDataException {
        throw new UnsupportedOperationException();
    }
}

