/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.gen.feature;

import com.flowpowered.math.vector.Vector3i;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.BigMushroom;
import org.spongepowered.api.world.gen.type.MushroomTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.gen.feature.WorldGeneratorBridge;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={WorldGenBigMushroom.class})
public abstract class WorldGenBigMushroomMixin_API
extends WorldGenerator
implements BigMushroom,
PopulatorObject {
    @Shadow
    @Final
    private Block field_76523_a;
    private final WeightedTable<PopulatorObject> api$types = new WeightedTable();
    @Nullable
    private Function<Location<Extent>, PopulatorObject> api$override = null;
    private VariableAmount api$mushroomsPerChunk = VariableAmount.fixed(1.0);
    @Nullable
    private String api$id;
    @Nullable
    private String api$name;

    @Override
    public String getId() {
        if (this.api$id == null) {
            this.api$id = this.field_76523_a == Blocks.field_150419_aX ? "minecraft:red" : "minecraft:brown";
        }
        return this.api$id;
    }

    @Override
    public String getName() {
        if (this.api$name == null) {
            this.api$name = this.field_76523_a == Blocks.field_150419_aX ? "Red mushroom" : "Brown mushroom";
        }
        return this.api$name;
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.BIG_MUSHROOM;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.api$mushroomsPerChunk.getFlooredAmount(random);
        PopulatorObject type = MushroomTypes.BROWN.getPopulatorObject();
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            BlockPos pos = world.func_175645_m(chunkPos.func_177982_a(x, 0, z));
            if (this.api$override != null) {
                Location<Extent> pos2 = new Location<Extent>(extent, VecHelper.toVector3i(pos));
                type = this.api$override.apply(pos2);
            } else {
                List<PopulatorObject> result = this.api$types.get(random);
                if (result.isEmpty()) continue;
                type = result.get(0);
            }
            if (!type.canPlaceAt((org.spongepowered.api.world.World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) continue;
            type.placeObject((org.spongepowered.api.world.World)world, random, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    @Override
    public WeightedTable<PopulatorObject> getTypes() {
        return this.api$types;
    }

    @Override
    public VariableAmount getMushroomsPerChunk() {
        return this.api$mushroomsPerChunk;
    }

    @Override
    public void setMushroomsPerChunk(VariableAmount count) {
        this.api$mushroomsPerChunk = count;
    }

    @Override
    public boolean canPlaceAt(org.spongepowered.api.world.World world, int x, int y, int z) {
        World worldIn = (World)world;
        int j = 4;
        boolean flag = true;
        if (y >= 1 && y + 4 + 1 < 256) {
            Block block1;
            for (int k = y; k <= y + 1 + 4; ++k) {
                int b0 = 3;
                if (k <= y + 3) {
                    b0 = 0;
                }
                for (int l = x - b0; l <= x + b0 && flag; ++l) {
                    for (int i1 = z - b0; i1 <= z + b0 && flag; ++i1) {
                        if (k >= 0 && k < 256) {
                            BlockPos pos = new BlockPos(l, k, i1);
                            IBlockState state = worldIn.func_180495_p(pos);
                            if (((WorldGeneratorBridge)((Object)this)).bridge$isAir(state, worldIn, pos) || ((WorldGeneratorBridge)((Object)this)).bridge$isLeaves(state, worldIn, pos)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (flag && ((block1 = worldIn.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c()) == Blocks.field_150346_d || block1 == Blocks.field_150349_c || block1 == Blocks.field_150391_bh)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void placeObject(org.spongepowered.api.world.World world, Random random, int x, int y, int z) {
        this.func_180709_b((World)world, random, new BlockPos(x, y, z));
    }

    @Override
    public Optional<Function<Location<Extent>, PopulatorObject>> getSupplierOverride() {
        return Optional.ofNullable(this.api$override);
    }

    @Override
    public void setSupplierOverride(@Nullable Function<Location<Extent>, PopulatorObject> override) {
        this.api$override = override;
    }
}

