/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.gen.feature;

import com.flowpowered.math.vector.Vector3i;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.data.type.PlantType;
import org.spongepowered.api.data.type.PlantTypes;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Flower;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={WorldGenFlowers.class})
public abstract class WorldGenFlowersMixin_API
extends WorldGenerator
implements Flower {
    private final WeightedTable<PlantType> api$flowers = new WeightedTable();
    @Nullable
    private Function<Location<Extent>, PlantType> api$override = null;
    private VariableAmount api$count = VariableAmount.fixed(2.0);

    @Shadow
    public abstract void func_175914_a(BlockFlower var1, BlockFlower.EnumFlowerType var2);

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.FLOWER;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = (int)Math.ceil((float)this.api$count.getFlooredAmount(random) / 64.0f);
        PlantType type = PlantTypes.DANDELION;
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            int y = this.apiImpl$nextInt(random, world.func_175645_m(chunkPos.func_177982_a(x, 0, z)).func_177956_o() + 32);
            BlockPos blockpos = chunkPos.func_177982_a(x, y, z);
            if (this.api$override != null) {
                Location<Extent> pos = new Location<Extent>(extent, VecHelper.toVector3i(blockpos));
                type = this.api$override.apply(pos);
            } else {
                List<PlantType> result = this.api$flowers.get(random);
                if (result.isEmpty()) continue;
                type = result.get(0);
            }
            BlockFlower.EnumFlowerType enumflowertype = (BlockFlower.EnumFlowerType)type;
            BlockFlower blockflower = enumflowertype.func_176964_a().func_180346_a();
            if (enumflowertype == null || blockflower.func_176223_P().func_185904_a() == Material.field_151579_a) continue;
            this.func_175914_a(blockflower, enumflowertype);
            this.func_180709_b(world, random, blockpos);
        }
    }

    private int apiImpl$nextInt(Random rand, int i) {
        if (i <= 1) {
            return 0;
        }
        return rand.nextInt(i);
    }

    @Override
    public VariableAmount getFlowersPerChunk() {
        return this.api$count;
    }

    @Override
    public void setFlowersPerChunk(VariableAmount count) {
        this.api$count = count;
    }

    @Override
    public WeightedTable<PlantType> getFlowerTypes() {
        return this.api$flowers;
    }

    @Override
    public Optional<Function<Location<Extent>, PlantType>> getSupplierOverride() {
        return Optional.ofNullable(this.api$override);
    }

    @Override
    public void setSupplierOverride(@Nullable Function<Location<Extent>, PlantType> override) {
        this.api$override = override;
    }
}

