/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableAxisData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDirectionalData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutablePoweredData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeAxisData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeDirectionalData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongePoweredData;
import org.spongepowered.common.mixin.core.block.BlockMixin;
import org.spongepowered.common.util.Constants;

@Mixin(value={BlockLever.class})
public abstract class BlockLeverMixin
extends BlockMixin {
    public ImmutableList<ImmutableDataManipulator<?, ?>> bridge$getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.impl$getIsPoweredFor(blockState), (Object)this.impl$getDirectionalData(blockState), (Object)this.impl$getAxisData(blockState));
    }

    @Override
    public boolean bridge$supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutablePoweredData.class.isAssignableFrom(immutable) || ImmutableDirectionalData.class.isAssignableFrom(immutable) || ImmutableAxisData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> bridge$getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutablePoweredData) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)((ImmutablePoweredData)manipulator).powered().get()));
        }
        if (manipulator instanceof ImmutableDirectionalData) {
            Direction dir = (Direction)((Object)((ImmutableDirectionalData)manipulator).direction().get());
            Axis axis = this.impl$getAxisFromOrientation((BlockLever.EnumOrientation)blockState.func_177229_b((IProperty)BlockLever.field_176360_a));
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)Constants.DirectionFunctions.getAsOrientation(dir, axis)));
        }
        if (manipulator instanceof ImmutableAxisData) {
            Axis axis = (Axis)((ImmutableAxisData)manipulator).axis().get();
            Direction dir = Constants.DirectionFunctions.getFor((BlockLever.EnumOrientation)blockState.func_177229_b((IProperty)BlockLever.field_176360_a));
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)Constants.DirectionFunctions.getAsOrientation(dir, axis)));
        }
        return super.bridge$getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> bridge$getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.POWERED)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)((Boolean)value)));
        }
        if (key.equals(Keys.DIRECTION)) {
            Direction dir = (Direction)((Object)value);
            Axis axis = this.impl$getAxisFromOrientation((BlockLever.EnumOrientation)blockState.func_177229_b((IProperty)BlockLever.field_176360_a));
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)Constants.DirectionFunctions.getAsOrientation(dir, axis)));
        }
        if (key.equals(Keys.AXIS)) {
            Axis axis = (Axis)value;
            Direction dir = Constants.DirectionFunctions.getFor((BlockLever.EnumOrientation)blockState.func_177229_b((IProperty)BlockLever.field_176360_a));
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)Constants.DirectionFunctions.getAsOrientation(dir, axis)));
        }
        return super.bridge$getStateWithValue(blockState, key, value);
    }

    private ImmutablePoweredData impl$getIsPoweredFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongePoweredData.class, blockState.func_177229_b((IProperty)BlockLever.field_176359_b));
    }

    private ImmutableDirectionalData impl$getDirectionalData(IBlockState blockState) {
        BlockLever.EnumOrientation intDir = (BlockLever.EnumOrientation)blockState.func_177229_b((IProperty)BlockLever.field_176360_a);
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDirectionalData.class, new Object[]{Constants.DirectionFunctions.getFor(intDir)});
    }

    private ImmutableAxisData impl$getAxisData(IBlockState blockState) {
        BlockLever.EnumOrientation orientation = (BlockLever.EnumOrientation)blockState.func_177229_b((IProperty)BlockLever.field_176360_a);
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeAxisData.class, this.impl$getAxisFromOrientation(orientation));
    }

    private Axis impl$getAxisFromOrientation(BlockLever.EnumOrientation orientation) {
        Axis axis;
        switch (orientation) {
            case UP_X: {
                axis = Axis.X;
                break;
            }
            case DOWN_X: {
                axis = Axis.X;
                break;
            }
            case UP_Z: {
                axis = Axis.Z;
                break;
            }
            case DOWN_Z: {
                axis = Axis.Z;
                break;
            }
            default: {
                axis = Axis.Y;
            }
        }
        return axis;
    }
}

