/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableGrowthData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableStoneData;
import org.spongepowered.api.data.type.TreeType;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeGrowthData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeTreeData;
import org.spongepowered.common.mixin.core.block.BlockMixin;

@Mixin(value={BlockSapling.class})
public abstract class BlockSaplingMixin
extends BlockMixin {
    public ImmutableList<ImmutableDataManipulator<?, ?>> bridge$getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.impl$getTreeTypeFor(blockState), (Object)this.impl$getGrowthData(blockState));
    }

    @Override
    public boolean bridge$supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableStoneData.class.isAssignableFrom(immutable) || ImmutableGrowthData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> bridge$getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableStoneData) {
            BlockPlanks.EnumType treeType = (BlockPlanks.EnumType)((ImmutableStoneData)manipulator).type().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)treeType));
        }
        if (manipulator instanceof ImmutableGrowthData) {
            int growth = (Integer)((ImmutableGrowthData)manipulator).growthStage().get();
            if (growth > 1) {
                growth = 1;
            }
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(growth)));
        }
        return super.bridge$getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> bridge$getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.TREE_TYPE)) {
            BlockPlanks.EnumType treeType = (BlockPlanks.EnumType)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)treeType));
        }
        if (key.equals(Keys.GROWTH_STAGE)) {
            int growth = (Integer)value;
            if (growth > 1) {
                growth = 1;
            }
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(growth)));
        }
        return super.bridge$getStateWithValue(blockState, key, value);
    }

    private ImmutableSpongeTreeData impl$getTreeTypeFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeTreeData.class, (TreeType)((Object)blockState.func_177229_b((IProperty)BlockSapling.field_176480_a)));
    }

    private ImmutableGrowthData impl$getGrowthData(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeGrowthData.class, blockState.func_177229_b((IProperty)BlockSapling.field_176479_b), 0, 1);
    }
}

