/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.event.entity.ChangeEntityEquipmentEvent;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.item.inventory.UseItemStackEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.OwnershipTrackedBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.entity.LivingEntityBaseBridge;
import org.spongepowered.common.bridge.entity.player.EntityPlayerBridge;
import org.spongepowered.common.bridge.entity.player.EntityPlayerMPBridge;
import org.spongepowered.common.bridge.entity.player.InventoryPlayerBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.living.human.EntityHuman;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.damage.DamageEventHandler;
import org.spongepowered.common.event.damage.DamageObject;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.entity.BasicEntityContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityDeathContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhase;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.comp.HotbarLens;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.slots.SlotLensImpl;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.EntityMixin;
import org.spongepowered.common.registry.type.event.DamageSourceRegistryModule;

@NonnullByDefault
@Mixin(value={EntityLivingBase.class}, priority=999)
public abstract class EntityLivingBaseMixin
extends EntityMixin
implements LivingEntityBaseBridge {
    @Shadow
    public int field_70771_an;
    @Shadow
    public int field_70737_aN;
    @Shadow
    public int field_70738_aO;
    @Shadow
    public float field_70739_aP;
    @Shadow
    public float field_70721_aZ;
    @Shadow
    protected boolean field_70729_aU;
    @Shadow
    protected int field_70708_bq;
    @Shadow
    protected int field_70744_aE;
    @Shadow
    protected int field_70718_bc;
    @Shadow
    protected int field_184628_bn;
    @Shadow
    protected float field_110153_bc;
    @Shadow
    @Nullable
    protected EntityPlayer field_70717_bb;
    @Shadow
    protected ItemStack field_184627_bm;
    @Shadow
    private DamageSource field_189750_bF;
    @Shadow
    private long field_189751_bG;
    private int impl$deathEventsPosted;
    private int impl$maxAir = 300;
    @Nullable
    private ItemStack impl$activeItemStackCopy;
    private EnumMap<EntityEquipmentSlot, SlotLens> slotLens = new EnumMap(EntityEquipmentSlot.class);

    @Shadow
    public void func_184597_cx() {
    }

    @Shadow
    public abstract void func_70606_j(float var1);

    @Shadow
    public abstract void func_130011_c(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void func_70653_a(net.minecraft.entity.Entity var1, float var2, double var3, double var5);

    @Shadow
    public abstract void shadow$func_70604_c(EntityLivingBase var1);

    @Shadow
    public abstract void func_110149_m(float var1);

    @Shadow
    public abstract void func_184611_a(EnumHand var1, @Nullable ItemStack var2);

    @Shadow
    public abstract void func_70031_b(boolean var1);

    @Shadow
    public abstract void func_184602_cy();

    @Shadow
    public abstract int func_184605_cv();

    @Shadow
    public abstract float func_110139_bj();

    @Shadow
    public abstract float func_110143_aJ();

    @Shadow
    public abstract float func_110138_aP();

    @Shadow
    public abstract boolean func_70644_a(Potion var1);

    @Shadow
    public abstract boolean func_70617_f_();

    @Shadow
    protected abstract boolean func_184583_d(DamageSource var1);

    @Shadow
    public abstract IAttributeInstance func_110148_a(IAttribute var1);

    @Shadow
    public abstract ItemStack func_184582_a(EntityEquipmentSlot var1);

    @Shadow
    public abstract ItemStack func_184586_b(EnumHand var1);

    @Shadow
    public abstract ItemStack func_184614_ca();

    @Shadow
    public abstract CombatTracker func_110142_aN();

    @Shadow
    @Nullable
    public abstract EntityLivingBase func_94060_bK();

    @Shadow
    public abstract Random func_70681_au();

    @Shadow
    public void func_174812_G() {
    }

    @Shadow
    public abstract AbstractAttributeMap func_110140_aT();

    @Shadow
    public abstract EnumHand func_184600_cs();

    @Shadow
    protected abstract void func_70609_aI();

    @Shadow
    protected abstract void func_70018_K();

    @Shadow
    protected abstract void func_184590_k(float var1);

    @Shadow
    protected abstract void func_184581_c(DamageSource var1);

    @Shadow
    protected abstract void func_190629_c(EntityLivingBase var1);

    @Shadow
    protected abstract void func_184610_a(boolean var1, int var2, DamageSource var3);

    @Shadow
    protected abstract int func_70693_a(EntityPlayer var1);

    @Shadow
    protected abstract float func_70599_aP();

    @Shadow
    protected abstract float func_70647_i();

    @Shadow
    protected abstract boolean func_146066_aG();

    @Shadow
    protected abstract SoundEvent func_184615_bR();

    @Shadow
    private boolean func_190628_d(DamageSource p_190628_1_) {
        return false;
    }

    @Shadow
    protected abstract void shadow$func_85033_bc();

    @Override
    public int bridge$getMaxAir() {
        return this.impl$maxAir;
    }

    @Override
    public void bridge$setMaxAir(int air) {
        this.impl$maxAir = air;
        if (air != 300) {
            NBTTagCompound spongeData = ((DataCompoundHolder)((Object)this)).data$getSpongeCompound();
            spongeData.func_74768_a("maxAir", air);
        } else if (((DataCompoundHolder)((Object)this)).data$hasSpongeCompound()) {
            ((DataCompoundHolder)((Object)this)).data$getSpongeCompound().func_82580_o("maxAir");
        }
    }

    @Override
    public void spongeImpl$readFromSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$readFromSpongeCompound(compound);
        if (compound.func_74764_b("maxAir")) {
            this.impl$maxAir = compound.func_74762_e("maxAir");
        }
    }

    @Override
    public void spongeImpl$writeToSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$writeToSpongeCompound(compound);
        if (this.impl$maxAir != 300) {
            compound.func_74768_a("maxAir", this.impl$maxAir);
        }
    }

    @Overwrite
    public void func_70645_a(DamageSource cause) {
        boolean isMainThread;
        boolean bl = isMainThread = !((WorldBridge)this.field_70170_p).bridge$isFake() || Sponge.isServerAvailable() && Sponge.getServer().isMainThread();
        if (!this.field_70128_L) {
            if (isMainThread && this.impl$deathEventsPosted <= 3) {
                ++this.impl$deathEventsPosted;
                if (SpongeCommonEventFactory.callDestructEntityEventDeath((EntityLivingBase)this, cause, isMainThread).map(Cancellable::isCancelled).orElse(true).booleanValue()) {
                    return;
                }
            }
        } else {
            this.impl$deathEventsPosted = 0;
        }
        try (EntityDeathContext context = this.createOrNullDeathPhase(isMainThread, cause);){
            if (context != null) {
                context.buildAndSwitch();
            }
            if (this.field_70729_aU) {
                return;
            }
            net.minecraft.entity.Entity entity = cause.func_76346_g();
            EntityLivingBase entitylivingbase = this.func_94060_bK();
            if (this.field_70744_aE >= 0 && entitylivingbase != null) {
                entitylivingbase.func_191956_a((net.minecraft.entity.Entity)((EntityLivingBase)this), this.field_70744_aE, cause);
            }
            if (entity != null) {
                entity.func_70074_a((EntityLivingBase)this);
            }
            this.field_70729_aU = true;
            this.func_110142_aN().func_94549_h();
            if (!this.field_70170_p.field_72995_K) {
                int i = 0;
                if (entity instanceof EntityPlayer) {
                    i = SpongeImplHooks.getLootingEnchantmentModifier((EntityLivingBase)this, (EntityLivingBase)entity, cause);
                }
                if (this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                    boolean flag = this.field_70718_bc > 0;
                    this.func_184610_a(flag, i, cause);
                }
            }
            if (!((EntityLivingBase)this instanceof EntityHuman)) {
                this.field_70170_p.func_72960_a((net.minecraft.entity.Entity)((EntityLivingBase)this), (byte)3);
            }
        }
    }

    @Override
    public void bridge$resetDeathEventsPosted() {
        this.impl$deathEventsPosted = 0;
    }

    @Inject(method={"setHealth"}, at={@At(value="HEAD")})
    private void onSetHealthResetEvents(float health, CallbackInfo info) {
        if (this.func_110143_aJ() <= 0.0f && health > 0.0f) {
            this.bridge$resetDeathEventsPosted();
        }
    }

    @Nullable
    private EntityDeathContext createOrNullDeathPhase(boolean isMainThread, DamageSource source) {
        boolean tracksEntityDeaths;
        if (((WorldBridge)this.field_70170_p).bridge$isFake() || !isMainThread) {
            return null;
        }
        IPhaseState state = PhaseTracker.getInstance().getCurrentContext().state;
        boolean bl = tracksEntityDeaths = !state.tracksEntityDeaths() && state != EntityPhase.State.DEATH;
        if (tracksEntityDeaths) {
            EntityDeathContext context = (EntityDeathContext)((EntityDeathContext)EntityPhase.State.DEATH.createPhaseContext().setDamageSource((org.spongepowered.api.event.cause.entity.damage.source.DamageSource)source)).source(this);
            if (this instanceof OwnershipTrackedBridge) {
                ((OwnershipTrackedBridge)((Object)this)).tracked$getNotifierReference().ifPresent(context::notifier);
                ((OwnershipTrackedBridge)((Object)this)).tracked$getOwnerReference().ifPresent(context::owner);
            }
            return context;
        }
        return null;
    }

    @Redirect(method={"applyPotionDamageCalculations"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;isPotionActive(Lnet/minecraft/potion/Potion;)Z"))
    private boolean onIsPotionActive(EntityLivingBase entityIn, Potion potion) {
        return false;
    }

    @Redirect(method={"applyArmorCalculations"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;damageArmor(F)V"))
    private void onDamageArmor(EntityLivingBase entityIn, float damage) {
    }

    @Overwrite
    protected void func_70665_d(DamageSource damageSource, float damage) {
        this.bridge$damageEntityHook(damageSource, damage);
    }

    @Override
    @Overwrite
    public boolean func_70097_a(DamageSource source, float amount) {
        EntityTameable entitywolf;
        this.field_189750_bF = source;
        if (source == null) {
            new PrettyPrinter(60).centre().add("Null DamageSource").hr().addWrapped("Sponge has found a null damage source! This should NEVER happen as the DamageSource is used for all sorts of calculations. Usually this can be considered developer error. Please report the following stacktrace to the most appropriate mod/plugin available.", new Object[0]).add().add(new IllegalArgumentException("Null DamageSource")).log(SpongeImpl.getLogger(), Level.WARN);
            return false;
        }
        if (!this.bridge$hookModAttack((EntityLivingBase)this, source, amount)) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.field_70708_bq = 0;
        if (this.func_110143_aJ() <= 0.0f && source != DamageSourceRegistryModule.IGNORED_DAMAGE_SOURCE) {
            return false;
        }
        if (source.func_76347_k() && this.func_70644_a(MobEffects.field_76426_n)) {
            return false;
        }
        float f = amount;
        boolean flag = amount > 0.0f && this.func_184583_d(source);
        this.field_70721_aZ = 1.5f;
        boolean flag1 = true;
        if ((float)this.field_70172_ad > (float)this.field_70771_an / 2.0f) {
            if (amount <= this.field_110153_bc) {
                return false;
            }
            if (this.entityType.isModdedDamageEntityMethod) {
                this.func_70665_d(source, amount - this.field_110153_bc);
            } else {
                this.bridge$damageEntityHook(source, amount - this.field_110153_bc);
            }
            this.field_110153_bc = amount;
            flag1 = false;
        } else {
            if (this.entityType.isModdedDamageEntityMethod) {
                this.func_70665_d(source, amount);
            } else {
                this.bridge$damageEntityHook(source, amount);
            }
            this.field_110153_bc = amount;
            this.field_70172_ad = this.field_70771_an;
            this.field_70738_aO = 10;
            this.field_70737_aN = 10;
        }
        this.field_70739_aP = 0.0f;
        net.minecraft.entity.Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase) {
            this.shadow$func_70604_c((EntityLivingBase)entity);
        }
        if (entity instanceof EntityPlayer) {
            this.field_70718_bc = 100;
            this.field_70717_bb = (EntityPlayer)entity;
        } else if (entity instanceof EntityTameable && (entitywolf = (EntityTameable)entity).func_70909_n()) {
            this.field_70718_bc = 100;
            this.field_70717_bb = null;
        }
        if (flag1) {
            if (flag) {
                this.field_70170_p.func_72960_a((net.minecraft.entity.Entity)((EntityLivingBase)this), (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
                this.field_70170_p.func_72960_a((net.minecraft.entity.Entity)((EntityLivingBase)this), (byte)33);
            } else {
                byte b0 = source == DamageSource.field_76369_e ? (byte)36 : (source.func_76347_k() ? (byte)37 : 2);
                this.field_70170_p.func_72960_a((net.minecraft.entity.Entity)((EntityLivingBase)this), b0);
            }
            if (source != DamageSource.field_76369_e && !flag) {
                this.func_70018_K();
            }
            if (entity != null) {
                double d1 = entity.field_70165_t - this.field_70165_t;
                double d0 = entity.field_70161_v - this.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 180.0 / Math.PI - (double)this.field_70177_z);
                this.func_70653_a(entity, 0.4f, d1, d0);
            } else {
                this.field_70739_aP = (float)(Math.random() * 2.0 * 180.0);
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            if (!this.func_190628_d(source)) {
                SoundEvent soundevent = this.func_184615_bR();
                if (flag1 && soundevent != null) {
                    this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
                }
                try (EntityDeathContext context = this.createOrNullDeathPhase(true, source);){
                    if (context != null) {
                        context.buildAndSwitch();
                    }
                    this.func_70645_a(source);
                }
            }
        } else if (flag1) {
            this.func_184581_c(source);
        }
        if (!flag) {
            this.field_189750_bF = source;
            this.field_189751_bG = this.field_70170_p.func_82737_E();
        }
        if ((EntityLivingBase)this instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192128_h.func_192200_a((EntityPlayerMP)this, source, f, amount, flag);
        }
        if (entity instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192127_g.func_192220_a((EntityPlayerMP)entity, (net.minecraft.entity.Entity)this, source, f, amount, flag);
        }
        return !flag;
    }

    @Redirect(method={"updateItemUse"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnParticle(Lnet/minecraft/util/EnumParticleTypes;DDDDDD[I)V"))
    private void spawnItemParticle(net.minecraft.world.World world, EnumParticleTypes particleTypes, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset, int ... p_175688_14_) {
        if (!this.bridge$isVanished()) {
            this.field_70170_p.func_175688_a(particleTypes, xCoord, yCoord, zCoord, xOffset, yOffset, zOffset, p_175688_14_);
        }
    }

    @Override
    public boolean bridge$damageEntityHook(DamageSource damageSource, float damage) {
        if (!this.func_180431_b(damageSource)) {
            boolean human = (EntityLivingBase)this instanceof EntityPlayer;
            float originalDamage = damage = this.bridge$applyModDamage((EntityLivingBase)this, damageSource, damage);
            if (damage <= 0.0f) {
                return false;
            }
            ArrayList originalFunctions = new ArrayList();
            Optional<DamageFunction> hardHatFunction = DamageEventHandler.createHardHatModifier((EntityLivingBase)this, damageSource);
            Optional<List<DamageFunction>> armorFunction = this.bridge$provideArmorModifiers((EntityLivingBase)this, damageSource, damage);
            Optional<DamageFunction> resistanceFunction = DamageEventHandler.createResistanceModifier((EntityLivingBase)this, damageSource);
            Optional<List<DamageFunction>> armorEnchantments = DamageEventHandler.createEnchantmentModifiers((EntityLivingBase)this, damageSource);
            Optional<DamageFunction> absorptionFunction = DamageEventHandler.createAbsorptionModifier((EntityLivingBase)this, damageSource);
            Optional<DamageFunction> shieldFunction = DamageEventHandler.createShieldFunction((EntityLivingBase)this, damageSource, damage);
            hardHatFunction.ifPresent(originalFunctions::add);
            shieldFunction.ifPresent(originalFunctions::add);
            armorFunction.ifPresent(originalFunctions::addAll);
            resistanceFunction.ifPresent(originalFunctions::add);
            armorEnchantments.ifPresent(originalFunctions::addAll);
            absorptionFunction.ifPresent(originalFunctions::add);
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                DamageEventHandler.generateCauseFor(damageSource, frame);
                DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.getCurrentCause(), originalFunctions, (Entity)((Object)this), originalDamage);
                if (damageSource != DamageSourceRegistryModule.IGNORED_DAMAGE_SOURCE) {
                    Sponge.getEventManager().post(event);
                }
                if (event.isCancelled()) {
                    boolean bl = false;
                    return bl;
                }
                damage = (float)event.getFinalDamage();
                damage = this.bridge$applyModDamagePost((EntityLivingBase)this, damageSource, damage);
                ItemStack helmet = this.func_184582_a(EntityEquipmentSlot.HEAD);
                if (damageSource instanceof FallingBlockDamageSource || damageSource == DamageSource.field_82728_o || damageSource == DamageSource.field_82729_p && !helmet.func_190926_b()) {
                    helmet.func_77972_a((int)(event.getBaseDamage() * 4.0 + (double)this.field_70146_Z.nextFloat() * event.getBaseDamage() * 2.0), (EntityLivingBase)this);
                }
                if (shieldFunction.isPresent()) {
                    net.minecraft.entity.Entity entity;
                    this.func_184590_k((float)event.getBaseDamage());
                    if (!damageSource.func_76352_a() && (entity = damageSource.func_76364_f()) instanceof EntityLivingBase) {
                        this.func_190629_c((EntityLivingBase)entity);
                    }
                }
                if (!damageSource.func_76363_c()) {
                    for (DamageFunction modifier : event.getModifiers()) {
                        this.bridge$applyArmorDamage((EntityLivingBase)this, damageSource, event, modifier.getModifier());
                    }
                }
                double absorptionModifier = absorptionFunction.map(function -> event.getDamage(function.getModifier())).orElse(0.0);
                if (absorptionFunction.isPresent()) {
                    absorptionModifier = event.getDamage(absorptionFunction.get().getModifier());
                }
                this.func_110149_m(Math.max(this.func_110139_bj() + (float)absorptionModifier, 0.0f));
                if (damage != 0.0f) {
                    if (human) {
                        ((EntityPlayer)this).func_71020_j(damageSource.func_76345_d());
                    }
                    float f2 = this.func_110143_aJ();
                    this.func_70606_j(f2 - damage);
                    this.func_110142_aN().func_94547_a(damageSource, f2, damage);
                    if (human) {
                        boolean bl = true;
                        return bl;
                    }
                    this.func_110149_m(this.func_110139_bj() - damage);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Overwrite
    public boolean func_184595_k(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((net.minecraft.entity.Entity)this);
        net.minecraft.world.World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                if (!world.field_72995_K) {
                    Transform<World> toTransform;
                    Transform<World> fromTransform = ((Entity)((Object)this)).getTransform().setPosition(new Vector3d(d0, d1, d2));
                    MoveEntityEvent.Teleport event = EntityUtil.handleDisplaceEntityTeleportEvent((net.minecraft.entity.Entity)this, fromTransform, toTransform = ((Entity)((Object)this)).getTransform().setPosition(new Vector3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)));
                    if (event.isCancelled()) {
                        this.field_70165_t = d0;
                        this.field_70163_u = d1;
                        this.field_70161_v = d2;
                        return false;
                    }
                    Vector3d position = event.getToTransform().getPosition();
                    this.field_70177_z = (float)event.getToTransform().getYaw();
                    this.field_70125_A = (float)event.getToTransform().getPitch();
                    this.func_70634_a(position.getX(), position.getY(), position.getZ());
                } else {
                    this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                if (world.func_184144_a((net.minecraft.entity.Entity)this, this.func_174813_aQ()).isEmpty() && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            if (!world.field_72995_K) {
                Transform<World> transform = ((Entity)((Object)this)).getTransform().setPosition(new Vector3d(d0, d1, d2));
                MoveEntityEvent.Teleport event = EntityUtil.handleDisplaceEntityTeleportEvent((net.minecraft.entity.Entity)this, transform, transform);
                if (event.isCancelled()) {
                    return false;
                }
                Vector3d position = event.getToTransform().getPosition();
                this.field_70177_z = (float)event.getToTransform().getYaw();
                this.field_70125_A = (float)event.getToTransform().getPitch();
                this.func_70634_a(position.getX(), position.getY(), position.getZ());
            } else {
                this.func_70634_a(d0, d1, d2);
            }
            return false;
        }
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.field_70131_O;
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        if ((EntityLivingBase)this instanceof EntityCreature) {
            ((EntityCreature)this).func_70661_as().func_75499_g();
        }
        return true;
    }

    @Override
    public float bridge$applyModDamage(EntityLivingBase entityLivingBase, DamageSource source, float damage) {
        return damage;
    }

    @Override
    public Optional<List<DamageFunction>> bridge$provideArmorModifiers(EntityLivingBase entityLivingBase, DamageSource source, double damage) {
        return DamageEventHandler.createArmorModifiers(entityLivingBase, source, damage);
    }

    @Override
    public void bridge$applyArmorDamage(EntityLivingBase entityLivingBase, DamageSource source, DamageEntityEvent entityEvent, DamageModifier modifier) {
        Optional<DamageObject> optional = modifier.getCause().first(DamageObject.class);
        if (optional.isPresent()) {
            DamageEventHandler.acceptArmorModifier((EntityLivingBase)this, source, modifier, entityEvent.getDamage(modifier));
        }
    }

    @Override
    public float bridge$applyModDamagePost(EntityLivingBase entityLivingBase, DamageSource source, float damage) {
        return damage;
    }

    @Override
    public boolean bridge$hookModAttack(EntityLivingBase entityLivingBase, DamageSource source, float amount) {
        return true;
    }

    @Overwrite
    public boolean func_70067_L() {
        return (!this.bridge$isVanished() || !this.bridge$isUncollideable()) && !this.field_70128_L;
    }

    @Redirect(method={"updateFallState"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;spawnParticle(Lnet/minecraft/util/EnumParticleTypes;DDDIDDDD[I)V"))
    private void spongeSpawnParticleForFallState(WorldServer worldServer, EnumParticleTypes particleTypes, double xCoord, double yCoord, double zCoord, int numberOfParticles, double xOffset, double yOffset, double zOffset, double particleSpeed, int ... extraArgs) {
        if (!this.bridge$isVanished()) {
            worldServer.func_175739_a(particleTypes, xCoord, yCoord, zCoord, numberOfParticles, xOffset, yOffset, zOffset, particleSpeed, extraArgs);
        }
    }

    @Redirect(method={"onEntityUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;onDeathUpdate()V"))
    private void causeTrackDeathUpdate(EntityLivingBase entityLivingBase) {
        block25: {
            if (!this.field_70170_p.field_72995_K) {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
                     Object context = EntityPhase.State.DEATH_UPDATE.createPhaseContext().source(entityLivingBase);){
                    ((PhaseContext)context).buildAndSwitch();
                    frame.pushCause(this);
                    this.func_70609_aI();
                    break block25;
                }
            }
            this.func_70609_aI();
        }
    }

    @Surrogate
    private void onGetItemStackFromSlot(CallbackInfo ci, EntityEquipmentSlot[] slots, int j, int k, EntityEquipmentSlot entityEquipmentSlot, ItemStack before) {
        this.onGetItemStackFromSlot(ci, 0, slots, j, k, entityEquipmentSlot, before);
    }

    @Inject(method={"onUpdate"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;getItemStackFromSlot(Lnet/minecraft/inventory/EntityEquipmentSlot;)Lnet/minecraft/item/ItemStack;")})
    private void onGetItemStackFromSlot(CallbackInfo ci, int i_unused, EntityEquipmentSlot[] slots, int j, int k, EntityEquipmentSlot entityEquipmentSlot, ItemStack before) {
        if (this.field_70173_aa == 1 && (EntityLivingBase)this instanceof EntityPlayer) {
            return;
        }
        ItemStack after = this.func_184582_a(entityEquipmentSlot);
        EntityLivingBase entity = (EntityLivingBase)this;
        if (!ItemStack.func_77989_b((ItemStack)after, (ItemStack)before)) {
            InventoryAdapter slotAdapter;
            if (entity instanceof EntityPlayerMP) {
                SlotLens slotLens;
                InventoryPlayerBridge inventory = (InventoryPlayerBridge)((EntityPlayerMP)entity).field_71071_by;
                Lens inventoryLens = ((InventoryAdapter)((Object)inventory)).bridge$getRootLens();
                if (inventoryLens instanceof PlayerInventoryLens) {
                    switch (entityEquipmentSlot) {
                        case OFFHAND: {
                            slotLens = ((PlayerInventoryLens)inventoryLens).getOffhandLens();
                            break;
                        }
                        case MAINHAND: {
                            HotbarLens hotbarLens = ((PlayerInventoryLens)inventoryLens).getMainLens().getHotbar();
                            slotLens = hotbarLens.getSlot(hotbarLens.getSelectedSlotIndex(((InventoryAdapter)((Object)inventory)).bridge$getFabric()));
                            break;
                        }
                        default: {
                            slotLens = ((PlayerInventoryLens)inventoryLens).getEquipmentLens().getSlot(entityEquipmentSlot.func_188454_b());
                            break;
                        }
                    }
                } else {
                    slotLens = inventoryLens.getSlotLens(entityEquipmentSlot.func_188454_b());
                }
                slotAdapter = slotLens.getAdapter(((InventoryAdapter)((Object)inventory)).bridge$getFabric(), (Inventory)((Object)inventory));
            } else {
                SlotLens lens = this.slotLens.get(entityEquipmentSlot);
                if (lens == null) {
                    lens = new SlotLensImpl(entityEquipmentSlot.func_188452_c());
                    this.slotLens.put(entityEquipmentSlot, lens);
                }
                slotAdapter = lens.getAdapter((Fabric)((Object)this), null);
            }
            ChangeEntityEquipmentEvent event = SpongeCommonEventFactory.callChangeEntityEquipmentEvent(entity, ItemStackUtil.snapshotOf(before), ItemStackUtil.snapshotOf(after), (SlotAdapter)slotAdapter);
            if (event.isCancelled()) {
                this.func_184201_a(entityEquipmentSlot, before);
                return;
            }
            Transaction<ItemStackSnapshot> transaction = event.getTransaction();
            if (!transaction.isValid()) {
                this.func_184201_a(entityEquipmentSlot, before);
                return;
            }
            Optional<ItemStackSnapshot> optional = transaction.getCustom();
            if (optional.isPresent()) {
                ItemStack custom = ItemStackUtil.fromSnapshotToNative(optional.get());
                this.func_184201_a(entityEquipmentSlot, custom);
            }
        }
    }

    @Redirect(method={"onDeathUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;getExperiencePoints(Lnet/minecraft/entity/player/EntityPlayer;)I"))
    private int onGetExperiencePoints(EntityLivingBase entity, EntityPlayer attackingPlayer) {
        if (entity instanceof EntityPlayerBridge && ((EntityPlayerBridge)entity).bridge$keepInventory()) {
            return 0;
        }
        return this.func_70693_a(attackingPlayer);
    }

    @Inject(method={"onItemPickup"}, at={@At(value="HEAD")})
    public void onEntityItemPickup(net.minecraft.entity.Entity entityItem, int unused, CallbackInfo ci) {
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    @Inject(method={"onItemUseFinish"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;resetActiveHand()V")})
    private void updateHealthForUseFinish(CallbackInfo ci) {
        if (this instanceof EntityPlayerMPBridge) {
            ((EntityPlayerMPBridge)((Object)this)).bridge$refreshScaledHealth();
        }
    }

    @Inject(method={"setActiveHand"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="FIELD", target="Lnet/minecraft/entity/EntityLivingBase;activeItemStack:Lnet/minecraft/item/ItemStack;")})
    private void onSetActiveItemStack(EnumHand hand, CallbackInfo ci, ItemStack stack) {
        UseItemStackEvent.Start event;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            HandType handType = (HandType)hand;
            this.addSelfToFrame(frame, snapshot, handType);
            event = SpongeEventFactory.createUseItemStackEventStart(Sponge.getCauseStackManager().getCurrentCause(), stack.func_77988_m(), stack.func_77988_m(), snapshot);
        }
        if (SpongeImpl.postEvent(event)) {
            ci.cancel();
        } else {
            this.field_184628_bn = event.getRemainingDuration();
        }
    }

    @Redirect(method={"setActiveHand"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/EntityLivingBase;activeItemStackUseCount:I"))
    private void getItemDuration(EntityLivingBase this$0, int count) {
        if (this.field_70170_p.field_72995_K) {
            this.field_184628_bn = count;
        }
    }

    private void addSelfToFrame(CauseStackManager.StackFrame frame, ItemStackSnapshot snapshot, HandType hand) {
        frame.addContext(EventContextKeys.USED_HAND, hand);
        this.addSelfToFrame(frame, snapshot);
    }

    private void addSelfToFrame(CauseStackManager.StackFrame frame, ItemStackSnapshot snapshot) {
        frame.pushCause(this);
        frame.addContext(EventContextKeys.USED_ITEM, snapshot);
        if (this instanceof User) {
            frame.addContext(EventContextKeys.OWNER, (User)((Object)this));
            frame.addContext(EventContextKeys.NOTIFIER, (User)((Object)this));
        }
    }

    @Redirect(method={"updateActiveHand"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;getItemInUseCount()I", ordinal=0))
    private int onGetRemainingItemDuration(EntityLivingBase self) {
        UseItemStackEvent.Tick event;
        if (this.field_70170_p.field_72995_K) {
            return self.func_184605_cv();
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.field_184627_bm);
            HandType handType = (HandType)this.func_184600_cs();
            this.addSelfToFrame(frame, snapshot, handType);
            event = SpongeEventFactory.createUseItemStackEventTick(Sponge.getCauseStackManager().getCurrentCause(), this.field_184628_bn, this.field_184628_bn, snapshot);
            SpongeImpl.postEvent(event);
        }
        this.field_184628_bn = Math.max(event.getRemainingDuration(), 1);
        if (event.isCancelled()) {
            return 26;
        }
        SpongeImplHooks.onUseItemTick((EntityLivingBase)this, this.field_184627_bm, this.field_184628_bn);
        return this.func_184605_cv();
    }

    @Inject(method={"onItemUseFinish"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;updateItemUse(Lnet/minecraft/item/ItemStack;I)V")})
    private void onUpdateItemUse(CallbackInfo ci) {
        UseItemStackEvent.Finish event;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.field_184627_bm);
            HandType handType = (HandType)this.func_184600_cs();
            this.addSelfToFrame(frame, snapshot, handType);
            event = SpongeEventFactory.createUseItemStackEventFinish(Sponge.getCauseStackManager().getCurrentCause(), this.field_184628_bn, this.field_184628_bn, snapshot);
        }
        SpongeImpl.postEvent(event);
        if (event.getRemainingDuration() > 0) {
            this.field_184628_bn = event.getRemainingDuration();
            ci.cancel();
        } else if (event.isCancelled()) {
            this.func_184602_cy();
            ci.cancel();
        } else {
            this.impl$activeItemStackCopy = this.field_184627_bm.func_77946_l();
        }
    }

    @Redirect(method={"onItemUseFinish"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;setHeldItem(Lnet/minecraft/util/EnumHand;Lnet/minecraft/item/ItemStack;)V"))
    private void onSetHeldItem(EntityLivingBase self, EnumHand hand, ItemStack stack) {
        UseItemStackEvent.Replace event;
        if (this.field_70170_p.field_72995_K) {
            self.func_184611_a(hand, stack);
            return;
        }
        ItemStackSnapshot activeItemStackSnapshot = ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy == null ? ItemStack.field_190927_a : this.impl$activeItemStackCopy);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack == null ? ItemStack.field_190927_a : stack);
            HandType handType = (HandType)hand;
            this.addSelfToFrame(frame, activeItemStackSnapshot, handType);
            event = SpongeEventFactory.createUseItemStackEventReplace(Sponge.getCauseStackManager().getCurrentCause(), this.field_184628_bn, this.field_184628_bn, activeItemStackSnapshot, new Transaction<ItemStackSnapshot>(ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy), snapshot));
        }
        if (SpongeImpl.postEvent(event)) {
            this.func_184611_a(hand, this.impl$activeItemStackCopy.func_77946_l());
            return;
        }
        if (!event.getItemStackResult().isValid()) {
            this.func_184611_a(hand, this.impl$activeItemStackCopy.func_77946_l());
            return;
        }
        this.func_184611_a(hand, ItemStackUtil.fromSnapshotToNative(event.getItemStackResult().getFinal()));
    }

    @Redirect(method={"stopActiveHand"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;onPlayerStoppedUsing(Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;I)V"))
    private void onStopPlayerUsing(ItemStack stack, net.minecraft.world.World world, EntityLivingBase self, int duration) {
        if (this.field_70170_p.field_72995_K) {
            stack.func_77974_b(world, self, duration);
            return;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            HandType handType = (HandType)this.func_184600_cs();
            this.addSelfToFrame(frame, snapshot, handType);
            if (!SpongeImpl.postEvent(SpongeEventFactory.createUseItemStackEventStop(Sponge.getCauseStackManager().getCurrentCause(), duration, duration, snapshot))) {
                stack.func_77974_b(world, self, duration);
            }
        }
    }

    @Inject(method={"resetActiveHand"}, at={@At(value="HEAD")})
    private void onResetActiveHand(CallbackInfo ci) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy != null ? this.impl$activeItemStackCopy : this.field_184627_bm);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            this.addSelfToFrame(frame, snapshot);
            SpongeImpl.postEvent(SpongeEventFactory.createUseItemStackEventReset(Sponge.getCauseStackManager().getCurrentCause(), this.field_184628_bn, this.field_184628_bn, snapshot));
        }
        this.impl$activeItemStackCopy = null;
    }

    @Redirect(method={"onLivingUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;collideWithNearbyEntities()V"))
    private void impl$runCollisions(EntityLivingBase self) {
        if (((WorldBridge)this.field_70170_p).bridge$isFake()) {
            this.shadow$func_85033_bc();
        } else {
            try (Object ignored = ((BasicEntityContext)EntityPhase.State.COLLISION.createPhaseContext().source(this)).buildAndSwitch();){
                this.shadow$func_85033_bc();
            }
        }
    }
}

