/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item.inventory;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.item.inventory.InventoryBridge;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.impl.slots.SlotLensImpl;

@Mixin(value={EntityLivingBase.class})
public abstract class EntityLivingEquipmentFabricMixin
implements Fabric,
InventoryBridge {
    private static final EntityEquipmentSlot[] SLOTS;
    private static final int MAX_STACK_SIZE = 64;

    @Shadow
    public abstract ItemStack func_184582_a(EntityEquipmentSlot var1);

    @Shadow
    public abstract void func_184201_a(EntityEquipmentSlot var1, ItemStack var2);

    @Override
    public Collection<InventoryBridge> fabric$allInventories() {
        return Collections.singleton(this);
    }

    @Override
    public InventoryBridge fabric$get(int index) {
        return this;
    }

    @Override
    public ItemStack fabric$getStack(int index) {
        return this.func_184582_a(SLOTS[index]);
    }

    @Override
    public void fabric$setStack(int index, ItemStack stack) {
        this.func_184201_a(SLOTS[index], stack);
    }

    @Override
    public int fabric$getMaxStackSize() {
        return 64;
    }

    @Override
    public Translation fabric$getDisplayName() {
        return SlotLensImpl.SLOT_NAME;
    }

    @Override
    public int fabric$getSize() {
        return SLOTS.length;
    }

    @Override
    public void fabric$clear() {
        for (EntityEquipmentSlot slot : SLOTS) {
            this.func_184201_a(slot, ItemStack.field_190927_a);
        }
    }

    @Override
    public void fabric$markDirty() {
    }

    static {
        EntityEquipmentSlot[] values = EntityEquipmentSlot.values();
        SLOTS = new EntityEquipmentSlot[values.length];
        EntityEquipmentSlot[] entityEquipmentSlotArray = values;
        int n = entityEquipmentSlotArray.length;
        for (int i = 0; i < n; ++i) {
            EntityEquipmentSlot slot;
            EntityLivingEquipmentFabricMixin.SLOTS[slot.func_188452_c()] = slot = entityEquipmentSlotArray[i];
        }
    }
}

