/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataTranslators;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.persistence.ConfigurateTranslator;
import org.spongepowered.common.data.persistence.DataSerializers;
import org.spongepowered.common.data.persistence.DataTranslatorTypeSerializer;
import org.spongepowered.common.data.persistence.LegacySchematicTranslator;
import org.spongepowered.common.data.persistence.SchematicTranslator;

public class DataTranslatorRegistryModule
implements AlternateCatalogRegistryModule<DataTranslator>,
AdditionalCatalogRegistryModule<DataTranslator> {
    @RegisterCatalog(value=DataTranslators.class)
    private final Map<String, DataTranslator> dataTranslatorMappings = new HashMap<String, DataTranslator>();
    private final Map<Class<?>, DataTranslator> dataTranslatorByClass = new IdentityHashMap();

    public static DataTranslatorRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Map<String, DataTranslator> provideCatalogMap() {
        HashMap<String, DataTranslator> modifierMap = new HashMap<String, DataTranslator>();
        for (Map.Entry<String, DataTranslator> entry : this.dataTranslatorMappings.entrySet()) {
            modifierMap.put(entry.getKey().replace("sponge:", ""), entry.getValue());
        }
        return modifierMap;
    }

    @Override
    public Optional<DataTranslator> getById(String id) {
        return Optional.ofNullable(this.dataTranslatorMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    public <T> Optional<DataTranslator<T>> getByClass(Class<T> type) {
        return Optional.ofNullable(this.dataTranslatorByClass.get(Preconditions.checkNotNull(type, (Object)"type")));
    }

    @Override
    public Collection<DataTranslator> getAll() {
        return ImmutableList.copyOf(this.dataTranslatorMappings.values());
    }

    @Override
    public void registerAdditionalCatalog(DataTranslator dataTranslator) {
        Preconditions.checkNotNull((Object)dataTranslator, (Object)"DataTranslator cannot be null");
        Preconditions.checkArgument((!dataTranslator.getId().isEmpty() ? 1 : 0) != 0, (Object)"Id cannot be empty");
        Preconditions.checkArgument((!this.dataTranslatorMappings.containsKey(dataTranslator.getId()) ? 1 : 0) != 0, (Object)"Duplicate Id");
        TypeToken typeToken = dataTranslator.getToken();
        Preconditions.checkNotNull(typeToken, (Object)"DataTranslator type token cannot be null");
        Class type = typeToken.getRawType();
        if (this.dataTranslatorByClass.containsKey(type)) {
            throw new IllegalStateException("Already registered the DataTranslator for " + type.getCanonicalName());
        }
        this.dataTranslatorMappings.put(dataTranslator.getId(), dataTranslator);
        this.dataTranslatorByClass.put(type, dataTranslator);
        if (TypeSerializers.getDefaultSerializers().get(typeToken) == null) {
            TypeSerializers.getDefaultSerializers().registerType(typeToken, DataTranslatorTypeSerializer.from(dataTranslator));
        }
    }

    @Override
    public void registerDefaults() {
        DataSerializers.registerSerializers(this);
        this.registerAdditionalCatalog(SchematicTranslator.get());
        this.registerAdditionalCatalog(ConfigurateTranslator.instance());
        LegacySchematicTranslator legacySchematicTranslator = LegacySchematicTranslator.get();
        this.dataTranslatorMappings.put(legacySchematicTranslator.getId(), legacySchematicTranslator);
    }

    DataTranslatorRegistryModule() {
    }

    private static final class Holder {
        static final DataTranslatorRegistryModule INSTANCE = new DataTranslatorRegistryModule();

        private Holder() {
        }
    }
}

