/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.type.SpongeSpawnType;

public class SpawnTypeRegistryModule
implements AlternateCatalogRegistryModule<SpawnType>,
AdditionalCatalogRegistryModule<SpawnType> {
    public static final SpawnType FORCED = SpawnTypeRegistryModule.generateType("forced", "Forced");
    public static final SpawnType ENTITY_DEATH = SpawnTypeRegistryModule.generateType("entity_death", "EntityDeath");
    @RegisterCatalog(value=SpawnTypes.class)
    private final Map<String, SpawnType> spawnTypeMap = new HashMap<String, SpawnType>();

    @Override
    public void registerAdditionalCatalog(SpawnType extraCatalog) {
        Preconditions.checkArgument((!this.spawnTypeMap.containsKey(extraCatalog.getId().toLowerCase(Locale.ENGLISH)) ? 1 : 0) != 0, (String)"SpawnType with the same id is already registered: {}", (Object)extraCatalog.getId());
        this.spawnTypeMap.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    @Override
    public Optional<SpawnType> getById(String id) {
        String key = ((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH);
        if (!key.contains(":")) {
            key = "sponge:" + key;
        }
        return Optional.ofNullable(this.spawnTypeMap.get(key));
    }

    @Override
    public Collection<SpawnType> getAll() {
        return ImmutableSet.copyOf(this.spawnTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        this.registerDefault("dispense", "Dispense");
        this.registerDefault("block_spawning", "BlockSpawning");
        this.registerDefault("breeding", "Breeding");
        this.registerDefault("dropped_item", "DroppedItem");
        this.registerDefault("experience", "Experience");
        this.registerDefault("falling_block", "FallingBlock");
        this.registerDefault("mob_spawner", "MobSpawner");
        this.registerDefault("passive", "Passive");
        this.registerDefault("placement", "Placement");
        this.registerDefault("projectile", "Projectile");
        this.registerDefault("spawn_egg", "SpawnEgg");
        this.registerDefault("structure", "Structure");
        this.registerDefault("tnt_ignite", "TNTIgnite");
        this.registerDefault("weather", "Weather");
        this.registerDefault("custom", "Custom");
        this.registerDefault("chunk_load", "ChunkLoad");
        this.registerDefault("world_spawner", "WorldSpawner");
        this.registerDefault("plugin", "Plugin");
        this.registerAdditionalCatalog(FORCED);
        this.registerAdditionalCatalog(ENTITY_DEATH);
    }

    private static SpawnType generateType(String id, String name) {
        return new SpongeSpawnType(id, name);
    }

    private void registerDefault(String id, String name) {
        this.spawnTypeMap.put("sponge:" + id, SpawnTypeRegistryModule.generateType(id, name));
    }

    @Override
    public Map<String, SpawnType> provideCatalogMap() {
        HashMap<String, SpawnType> map = new HashMap<String, SpawnType>();
        for (Map.Entry<String, SpawnType> entry : this.spawnTypeMap.entrySet()) {
            map.put(entry.getKey().replace("sponge:", ""), entry.getValue());
        }
        return map;
    }
}

