/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.query.QueryOperationType;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.item.inventory.query.SpongeQueryOperationType;
import org.spongepowered.common.item.inventory.query.SpongeQueryOperationTypes;
import org.spongepowered.common.item.inventory.query.operation.InventoryPropertyQueryOperation;
import org.spongepowered.common.item.inventory.query.operation.InventoryTranslationQueryOperation;
import org.spongepowered.common.item.inventory.query.operation.InventoryTypeQueryOperation;
import org.spongepowered.common.item.inventory.query.operation.ItemStackCustomOperation;
import org.spongepowered.common.item.inventory.query.operation.ItemStackExactQueryOperation;
import org.spongepowered.common.item.inventory.query.operation.ItemStackIgnoreQuantityOperation;
import org.spongepowered.common.item.inventory.query.operation.ItemTypeQueryOperation;
import org.spongepowered.common.item.inventory.query.operation.TypeQueryOperation;

public final class QueryOperationRegistryModule
implements CatalogRegistryModule<QueryOperationType> {
    @RegisterCatalog(value=QueryOperationTypes.class)
    private final Map<String, QueryOperationType> types = new HashMap<String, QueryOperationType>();

    @Override
    public Optional<QueryOperationType> getById(String id) {
        return Optional.ofNullable(this.types.get(id));
    }

    @Override
    public Collection<QueryOperationType> getAll() {
        return this.types.values();
    }

    @Override
    public void registerDefaults() {
        this.register(new SpongeQueryOperationType<Class>("inventory_type", InventoryTypeQueryOperation::new));
        this.register(new SpongeQueryOperationType<Class>("type", TypeQueryOperation::new));
        this.register(new SpongeQueryOperationType<ItemType>("item_type", ItemTypeQueryOperation::new));
        this.register(new SpongeQueryOperationType<ItemStack>("item_stack_ignore_quantity", ItemStackIgnoreQuantityOperation::new));
        this.register(new SpongeQueryOperationType<ItemStack>("item_stack_exact", ItemStackExactQueryOperation::new));
        this.register(new SpongeQueryOperationType<Predicate>("item_stack_custom", ItemStackCustomOperation::new));
        this.register(new SpongeQueryOperationType<InventoryProperty>("inventory_property", InventoryPropertyQueryOperation::new));
        this.register(new SpongeQueryOperationType<Translation>("inventory_translation", InventoryTranslationQueryOperation::new));
        this.register(SpongeQueryOperationTypes.LENS);
        this.register(SpongeQueryOperationTypes.SLOT_LENS);
    }

    private void register(QueryOperationType<?> type) {
        this.types.put(type.getId(), type);
    }
}

