/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import org.spongepowered.api.registry.RegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class BlockChangeFlagRegistryModule
implements RegistryModule {
    @RegisterCatalog(value=BlockChangeFlags.class)
    private final Map<String, SpongeBlockChangeFlag> flags = new LinkedHashMap<String, SpongeBlockChangeFlag>();
    private final SpongeBlockChangeFlag[] maskedFlags = new SpongeBlockChangeFlag[64];
    private static BlockChangeFlagRegistryModule INSTANCE = new BlockChangeFlagRegistryModule();

    public static BlockChangeFlagRegistryModule getInstance() {
        return INSTANCE;
    }

    public static SpongeBlockChangeFlag fromNativeInt(int flag) {
        if (flag >= BlockChangeFlagRegistryModule.getInstance().maskedFlags.length) {
            return (SpongeBlockChangeFlag)BlockChangeFlags.ALL;
        }
        if (flag == 3) {
            return (SpongeBlockChangeFlag)BlockChangeFlags.ALL;
        }
        if (flag == 2) {
            return (SpongeBlockChangeFlag)BlockChangeFlags.PHYSICS_OBSERVER;
        }
        SpongeBlockChangeFlag spongeBlockChangeFlag = BlockChangeFlagRegistryModule.getInstance().maskedFlags[flag];
        return spongeBlockChangeFlag;
    }

    public static BlockChangeFlag andNotifyClients(BlockChangeFlag flag) {
        int rawFlag = ((SpongeBlockChangeFlag)flag).getRawFlag();
        if ((rawFlag & 2) != 0) {
            return flag;
        }
        return BlockChangeFlagRegistryModule.fromNativeInt(rawFlag & 0xFFFFFFFD);
    }

    private BlockChangeFlagRegistryModule() {
    }

    @Override
    public void registerDefaults() {
        for (int i = 0; i < 64; ++i) {
            StringJoiner builder = new StringJoiner("|");
            if ((i & 1) != 0) {
                builder.add("NEIGHBOR");
            }
            if ((i & 2) != 0) {
                builder.add("NOTIFY_CLIENTS");
            }
            if ((i & 4) != 0) {
                builder.add("IGNORE_RENDER");
            }
            if ((i & 8) != 0) {
                builder.add("FORCE_RE_RENDER");
            }
            if ((i & 0x10) == 0) {
                builder.add("OBSERVER");
            }
            if ((i & 0x20) == 0) {
                builder.add("PHYSICS");
            }
            if (58 == i) {
                this.register(new SpongeBlockChangeFlag("NONE".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (3 == i) {
                this.register(new SpongeBlockChangeFlag("ALL".toLowerCase(Locale.ENGLISH), i));
                this.register(new SpongeBlockChangeFlag("NEIGHBOR_PHYSICS_OBSERVER".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (51 == i) {
                this.register(new SpongeBlockChangeFlag("NEIGHBOR".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (18 == i) {
                this.register(new SpongeBlockChangeFlag("PHYSICS".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (34 == i) {
                this.register(new SpongeBlockChangeFlag("OBSERVER".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (19 == i) {
                this.register(new SpongeBlockChangeFlag("NEIGHBOR_PHYSICS".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (35 == i) {
                this.register(new SpongeBlockChangeFlag("NEIGHBOR_OBSERVER".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (2 == i) {
                this.register(new SpongeBlockChangeFlag("PHYSICS_OBSERVER".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            this.register(new SpongeBlockChangeFlag(builder.toString().toLowerCase(Locale.ENGLISH), i));
        }
    }

    private void register(SpongeBlockChangeFlag flag) {
        this.maskedFlags[flag.getRawFlag()] = flag;
        this.flags.put(flag.getName(), flag);
    }

    public Collection<SpongeBlockChangeFlag> getValues() {
        return Collections.unmodifiableCollection(this.flags.values());
    }
}

