/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.resourcepack;

import com.google.common.base.MoreObjects;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.common.resourcepack.SpongeURIResourcePack;
import org.spongepowered.common.resourcepack.SpongeWorldResourcePack;

public abstract class SpongeResourcePack
implements ResourcePack {
    private final Optional<String> hash;
    private final String id = UUID.randomUUID().toString();
    public static final int HASH_SIZE = 40;

    public SpongeResourcePack(@Nullable String hash) {
        this.hash = Optional.ofNullable(hash);
    }

    public abstract String getUrlString();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Optional<String> getHash() {
        return this.hash;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("uri", (Object)this.getUri()).toString();
    }

    public static SpongeResourcePack create(String uri, String hash) throws URISyntaxException {
        if (uri.startsWith("level://")) {
            return new SpongeWorldResourcePack(uri, hash);
        }
        if (hash != null && hash.length() != 40) {
            hash = null;
        }
        return new SpongeURIResourcePack(uri, hash);
    }

    public static SpongeResourcePack create(URI uri, String hash) {
        if (uri.toString().startsWith("level://")) {
            return new SpongeWorldResourcePack(uri, hash);
        }
        return new SpongeURIResourcePack(uri, hash);
    }
}

