/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.user;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.UserListBans;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.api.profile.ProfileNotFoundException;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.entity.player.EntityPlayerMPBridge;
import org.spongepowered.common.bridge.world.storage.SaveHandlerBridge;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.mixin.core.server.management.UserLIstEntryAccessor;
import org.spongepowered.common.mixin.core.server.management.UserListAccessor;
import org.spongepowered.common.mixin.core.world.storage.SaveHandlerAccessor;
import org.spongepowered.common.world.WorldManager;

class UserDiscoverer {
    private static final Map<String, MutableWatchEvent> updateCache = new HashMap<String, MutableWatchEvent>();
    private static final Set<UUID> detectedStoredUUIDs = new HashSet<UUID>();
    private static final Pattern DAT_FILENAME_SUFFIX = Pattern.compile("\\.dat$");
    @Nullable
    private static WatchService filesystemWatchService = null;
    @Nullable
    private static WatchKey watchKey = null;
    private static final Object lockingObject = new Object();
    private static boolean hasInitBeenStarted = false;
    private static boolean scanningIO = true;
    private static final Map<UUID, org.spongepowered.api.profile.GameProfile> gameProfileCache = new HashMap<UUID, org.spongepowered.api.profile.GameProfile>();
    private static final Multimap<String, User> caseInsensitiveUserByNameCache = HashMultimap.create();
    private static final Cache<String, User> userByNameCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();
    private static final Cache<UUID, User> userCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).removalListener(removalNotification -> {
        if (removalNotification.getCause() != RemovalCause.REPLACED) {
            UserDiscoverer.invalidateEntry(((User)removalNotification.getValue()).getProfile());
        } else {
            String name = ((User)removalNotification.getValue()).getName();
            if (name != null) {
                userByNameCache.invalidate((Object)name);
                caseInsensitiveUserByNameCache.remove((Object)name.toLowerCase(), removalNotification.getValue());
            }
        }
    }).build();
    private static final Set<UUID> nonExistentUsers = new HashSet<UUID>();

    UserDiscoverer() {
    }

    static User create(GameProfile profile) {
        User user = (User)((Object)new SpongeUser(profile));
        UserDiscoverer.createCacheEntry(user);
        return user;
    }

    static User forceRecreate(GameProfile profile) {
        SpongeUser user = (SpongeUser)userCache.getIfPresent((Object)profile.getId());
        if (user != null && SpongeUser.dirtyUsers.contains(user)) {
            user.save();
            user.invalidate();
        }
        return UserDiscoverer.create(profile);
    }

    @Nullable
    static User findByProfile(org.spongepowered.api.profile.GameProfile profile) {
        UUID uniqueId = profile.getUniqueId();
        User user = (User)userCache.getIfPresent((Object)uniqueId);
        if (user != null) {
            if (user.getName() == null && profile.getName().isPresent()) {
                user = UserDiscoverer.getFromStoredData(profile);
            }
            return user;
        }
        user = UserDiscoverer.getOnlinePlayer(uniqueId);
        if (user != null) {
            nonExistentUsers.remove(profile.getUniqueId());
            return user;
        }
        user = UserDiscoverer.getFromStoredData(profile);
        if (user != null) {
            return user;
        }
        user = UserDiscoverer.getFromWhitelist(uniqueId);
        if (user != null) {
            return user;
        }
        user = UserDiscoverer.getFromBanlist(uniqueId);
        return user;
    }

    @Nullable
    static User findByUsername(String username) {
        Object profile;
        User user = (User)userByNameCache.getIfPresent((Object)username);
        if (user != null) {
            return user;
        }
        Collection userCollection = caseInsensitiveUserByNameCache.get((Object)username.toLowerCase());
        if (userCollection.size() == 1) {
            return (User)userCollection.iterator().next();
        }
        PlayerProfileCache cache = SpongeImpl.getServer().func_152358_ax();
        HashSet names = Sets.newHashSet((Object[])cache.func_152654_a());
        if (names.contains(username.toLowerCase(Locale.ROOT)) && (profile = cache.func_152655_a(username)) != null) {
            return UserDiscoverer.findByProfile((org.spongepowered.api.profile.GameProfile)profile);
        }
        try {
            profile = Sponge.getServer().getGameProfileManager().get(username).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while looking up username " + username, e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ProfileNotFoundException) {
                return null;
            }
            throw new RuntimeException("Exception while looking up username " + username, e);
        }
        return UserDiscoverer.findByProfile((org.spongepowered.api.profile.GameProfile)profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<org.spongepowered.api.profile.GameProfile> getAllProfiles() {
        if (scanningIO) {
            return ((GameProfileCache)SpongeImpl.getServer().func_152358_ax()).getProfiles();
        }
        Preconditions.checkState((boolean)Sponge.isServerAvailable(), (Object)"Server is not available!");
        if (filesystemWatchService == null || watchKey == null || !watchKey.isValid()) {
            UserDiscoverer.startFilesystemWatchService();
            return ((GameProfileCache)SpongeImpl.getServer().func_152358_ax()).getProfiles();
        }
        Object object = lockingObject;
        synchronized (object) {
            HashMap<UUID, org.spongepowered.api.profile.GameProfile> profiles = new HashMap<UUID, org.spongepowered.api.profile.GameProfile>(gameProfileCache);
            PlayerProfileCache profileCache = SpongeImpl.getServer().func_152358_ax();
            UserDiscoverer.pollFilesystemWatcher();
            UserDiscoverer.getProfilesFromDetectedUUIDs(profileCache, profiles);
            PlayerList pl = SpongeImpl.getServer().func_184103_al();
            UserDiscoverer.addToProfiles(((UserListAccessor)pl.func_152599_k()).accessor$getValues().values(), profiles, profileCache);
            UserDiscoverer.addToProfiles(((UserListAccessor)pl.func_152608_h()).accessor$getValues().values(), profiles, profileCache);
            return profiles.values();
        }
    }

    static void init() {
        if (!hasInitBeenStarted) {
            hasInitBeenStarted = true;
            UserDiscoverer.startFilesystemWatchService();
        }
    }

    private static void startFilesystemWatchService() {
        Preconditions.checkState((boolean)Sponge.isServerAvailable(), (Object)"Server is not available!");
        scanningIO = true;
        SpongeImpl.getScheduler().createAsyncExecutor(SpongeImpl.getPlugin()).execute(UserDiscoverer::startFilesystemWatchServiceTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startFilesystemWatchServiceTask() {
        Object object = lockingObject;
        synchronized (object) {
            if (watchKey != null) {
                watchKey.cancel();
                watchKey = null;
            }
            if (filesystemWatchService != null) {
                try {
                    filesystemWatchService.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    filesystemWatchService = null;
                }
            }
            detectedStoredUUIDs.clear();
            nonExistentUsers.clear();
            SaveHandlerBridge saveHandler = (SaveHandlerBridge)WorldManager.getWorldByDimensionId(0).get().func_72860_G();
            Set<UUID> uuids = UserDiscoverer.getAvailablePlayerUUIDs(saveHandler.bridge$getPlayersDirectory().toPath());
            detectedStoredUUIDs.addAll(uuids);
            detectedStoredUUIDs.addAll(userCache.asMap().keySet());
            try {
                filesystemWatchService = FileSystems.getDefault().newWatchService();
                watchKey = saveHandler.bridge$getPlayersDirectory().toPath().register(filesystemWatchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                scanningIO = false;
            }
            catch (IOException e) {
                SpongeImpl.getLogger().warn("Could not start file watcher");
                if (filesystemWatchService != null) {
                    try {
                        filesystemWatchService.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                watchKey = null;
                filesystemWatchService = null;
            }
        }
    }

    private static Set<UUID> getAvailablePlayerUUIDs(Path playersDirectory) {
        HashSet<UUID> ret = new HashSet<UUID>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(playersDirectory, "*.dat");){
            for (Path entry : stream) {
                try {
                    String name = DAT_FILENAME_SUFFIX.matcher(entry.getFileName().toString()).replaceAll("");
                    ret.add(UUID.fromString(name));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (IOException ex) {
            SpongeImpl.getLogger().error("Could not get the available UUIDs", (Throwable)ex);
        }
        return ret;
    }

    private static void getProfilesFromDetectedUUIDs(PlayerProfileCache profileCache, Map<UUID, org.spongepowered.api.profile.GameProfile> profiles) {
        for (UUID uuid : detectedStoredUUIDs) {
            GameProfile profile = profileCache.func_152652_a(uuid);
            if (profile == null) continue;
            profiles.put(profile.getId(), (org.spongepowered.api.profile.GameProfile)profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pollFilesystemWatcher() {
        Map<String, MutableWatchEvent> map = updateCache;
        synchronized (map) {
            updateCache.clear();
            Iterator<Object> iterator = watchKey.pollEvents().iterator();
            while (iterator.hasNext()) {
                WatchEvent<?> watchEvent;
                WatchEvent<?> ev = watchEvent = iterator.next();
                Path file = (Path)ev.context();
                String filename = file.getFileName().toString();
                updateCache.computeIfAbsent(filename, f -> new MutableWatchEvent()).set(ev.kind());
            }
            for (Map.Entry entry : updateCache.entrySet()) {
                String name;
                WatchEvent.Kind kind = ((MutableWatchEvent)entry.getValue()).get();
                if (kind == null || !(name = (String)entry.getKey()).endsWith(".dat")) continue;
                try {
                    UUID uuid = UUID.fromString(name.substring(0, name.length() - 4));
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        detectedStoredUUIDs.add(uuid);
                        continue;
                    }
                    detectedStoredUUIDs.remove(uuid);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            updateCache.clear();
        }
    }

    private static void addToProfiles(Collection<? extends UserListEntry<GameProfile>> gameProfiles, Map<UUID, org.spongepowered.api.profile.GameProfile> profiles, PlayerProfileCache profileCache) {
        gameProfiles.stream().filter(x -> !profiles.containsKey(((GameProfile)((UserLIstEntryAccessor)x).accessor$getValue()).getId())).map(entry -> (GameProfile)((UserLIstEntryAccessor)entry).accessor$getValue()).forEach(x -> {
            GameProfile profile = profileCache.func_152652_a(x.getId());
            if (profile == null) {
                profile = x;
                profileCache.func_152649_a(profile);
            }
            profiles.put(profile.getId(), (org.spongepowered.api.profile.GameProfile)profile);
        });
    }

    static boolean delete(UUID uniqueId) {
        if (UserDiscoverer.getOnlinePlayer(uniqueId) != null) {
            return false;
        }
        boolean success = UserDiscoverer.deleteStoredPlayerData(uniqueId);
        success = success && UserDiscoverer.deleteWhitelistEntry(uniqueId);
        success = success && UserDiscoverer.deleteBanlistEntry(uniqueId);
        return success;
    }

    @Nullable
    private static User getOnlinePlayer(UUID uniqueId) {
        Optional<User> optional;
        Preconditions.checkState((boolean)Sponge.isServerAvailable(), (Object)"Server is not available!");
        PlayerList playerList = SpongeImpl.getServer().func_184103_al();
        Preconditions.checkNotNull((Object)playerList, (Object)"Server is not fully initialized yet! (Try a later event)");
        EntityPlayerMPBridge player = (EntityPlayerMPBridge)playerList.func_177451_a(uniqueId);
        if (player != null && (optional = player.bridge$getBackingUser()).isPresent()) {
            User user = optional.get();
            UserDiscoverer.createCacheEntry(user);
            return user;
        }
        return null;
    }

    @Nullable
    private static User getFromStoredData(org.spongepowered.api.profile.GameProfile profile) {
        if (nonExistentUsers.contains(profile.getUniqueId())) {
            return null;
        }
        File dataFile = UserDiscoverer.getPlayerDataFile(profile.getUniqueId());
        if (dataFile == null) {
            nonExistentUsers.add(profile.getUniqueId());
            return null;
        }
        User user = UserDiscoverer.create((GameProfile)profile);
        return user;
    }

    @Nullable
    private static User getFromWhitelist(UUID uniqueId) {
        UserListWhitelist whiteList = SpongeImpl.getServer().func_184103_al().func_152599_k();
        return UserDiscoverer.getFromEntry((UserListEntry<GameProfile>)whiteList.func_152683_b((Object)new GameProfile(uniqueId, "")));
    }

    @Nullable
    private static User getFromBanlist(UUID uniqueId) {
        UserListBans banList = SpongeImpl.getServer().func_184103_al().func_152608_h();
        return UserDiscoverer.getFromEntry((UserListEntry<GameProfile>)banList.func_152683_b((Object)new GameProfile(uniqueId, "")));
    }

    @Nullable
    private static User getFromEntry(@Nullable UserListEntry<GameProfile> entry) {
        GameProfile profile;
        if (entry != null && (profile = (GameProfile)((UserLIstEntryAccessor)entry).accessor$getValue()) != null) {
            return UserDiscoverer.create(profile);
        }
        return null;
    }

    @Nullable
    private static File getPlayerDataFile(UUID uniqueId) {
        Optional<WorldServer> worldServer = WorldManager.getWorldByDimensionId(0);
        if (!worldServer.isPresent()) {
            return null;
        }
        SaveHandlerAccessor saveHandler = (SaveHandlerAccessor)worldServer.get().func_72860_G();
        File file = new File(saveHandler.accessor$getPlayersDirectory(), uniqueId.toString() + ".dat");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static boolean deleteStoredPlayerData(UUID uniqueId) {
        File dataFile = UserDiscoverer.getPlayerDataFile(uniqueId);
        if (dataFile != null) {
            try {
                return dataFile.delete();
            }
            catch (SecurityException e) {
                SpongeImpl.getLogger().warn("Unable to delete file {} due to a security error", (Object)dataFile, (Object)e);
                return false;
            }
        }
        return true;
    }

    private static boolean deleteWhitelistEntry(UUID uniqueId) {
        UserListWhitelist whiteList = SpongeImpl.getServer().func_184103_al().func_152599_k();
        whiteList.func_152684_c((Object)new GameProfile(uniqueId, ""));
        return true;
    }

    private static boolean deleteBanlistEntry(UUID uniqueId) {
        UserListBans banList = SpongeImpl.getServer().func_184103_al().func_152608_h();
        banList.func_152684_c((Object)new GameProfile(uniqueId, ""));
        return true;
    }

    private static void createCacheEntry(User user) {
        UserDiscoverer.invalidateEntry(user.getProfile());
        userCache.put((Object)user.getUniqueId(), (Object)user);
        gameProfileCache.put(user.getUniqueId(), user.getProfile());
        if (user.getName() != null) {
            userByNameCache.put((Object)user.getName(), (Object)user);
            caseInsensitiveUserByNameCache.put((Object)user.getName().toLowerCase(), (Object)user);
        }
        nonExistentUsers.remove(user.getUniqueId());
    }

    private static void invalidateEntry(org.spongepowered.api.profile.GameProfile profile) {
        UUID uuid = profile.getUniqueId();
        gameProfileCache.remove(uuid);
        userCache.invalidate((Object)uuid);
        profile.getName().ifPresent(name -> {
            User user = (User)userByNameCache.getIfPresent(name);
            if (user != null && uuid.equals(user.getUniqueId())) {
                userByNameCache.invalidate(name);
                caseInsensitiveUserByNameCache.remove((Object)user.getName().toLowerCase(), (Object)user);
            }
        });
    }

    static class MutableWatchEvent {
        @Nullable
        private WatchEvent.Kind<?> kind = null;

        MutableWatchEvent() {
        }

        @Nullable
        public WatchEvent.Kind get() {
            return this.kind;
        }

        public void set(WatchEvent.Kind<?> kind) {
            if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                kind = StandardWatchEventKinds.ENTRY_CREATE;
            }
            if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_DELETE) {
                this.kind = this.kind != null && this.kind != kind ? null : kind;
            }
        }
    }
}

