/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.action;

import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.util.text.event.ClickEvent;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.common.bridge.util.text.event.ClickEventBridge;
import org.spongepowered.common.text.action.SpongeCallbackHolder;

public final class SpongeClickAction {
    private SpongeClickAction() {
    }

    private static ClickEvent.Action getType(ClickAction<?> action) {
        if (action instanceof ClickAction.OpenUrl) {
            return ClickEvent.Action.OPEN_URL;
        }
        if (action instanceof ClickAction.RunCommand || action instanceof ClickAction.ExecuteCallback) {
            return ClickEvent.Action.RUN_COMMAND;
        }
        if (action instanceof ClickAction.SuggestCommand) {
            return ClickEvent.Action.SUGGEST_COMMAND;
        }
        if (action instanceof ClickAction.ChangePage) {
            return ClickEvent.Action.CHANGE_PAGE;
        }
        throw new UnsupportedOperationException(action.getClass().toString());
    }

    public static ClickEvent getHandle(ClickAction<?> action) {
        String text;
        if (action instanceof ClickAction.ExecuteCallback) {
            UUID callbackId = SpongeCallbackHolder.getInstance().getOrCreateIdForCallback((Consumer)((ClickAction.ExecuteCallback)action).getResult());
            text = "/sponge:callback " + callbackId;
        } else {
            text = action.getResult().toString();
        }
        ClickEvent event = new ClickEvent(SpongeClickAction.getType(action), text);
        ((ClickEventBridge)event).bridge$setHandle(action);
        return event;
    }
}

