/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.collect.ImmutableList;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContextKey;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.common.config.category.LoggingCategory;
import org.spongepowered.common.event.ShouldFire;

public enum BlockChange {
    BREAK{

        @Override
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventBreak(cause, transactions);
        }

        @Override
        public boolean shouldFire() {
            return ShouldFire.CHANGE_BLOCK_EVENT_BREAK;
        }

        @Override
        public EventContextKey<? extends ChangeBlockEvent> getKey() {
            return EventContextKeys.BREAK_EVENT;
        }

        @Override
        public boolean allowsLogging(LoggingCategory category) {
            return category.blockBreakLogging();
        }
    }
    ,
    DECAY{

        @Override
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventDecay(cause, transactions);
        }

        @Override
        public boolean shouldFire() {
            return ShouldFire.CHANGE_BLOCK_EVENT_DECAY;
        }

        @Override
        public EventContextKey<? extends ChangeBlockEvent> getKey() {
            return EventContextKeys.DECAY_EVENT;
        }
    }
    ,
    MODIFY{

        @Override
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventModify(cause, transactions);
        }

        @Override
        public boolean shouldFire() {
            return ShouldFire.CHANGE_BLOCK_EVENT_MODIFY;
        }

        @Override
        public EventContextKey<? extends ChangeBlockEvent> getKey() {
            return EventContextKeys.MODIFY_EVENT;
        }

        @Override
        public boolean allowsLogging(LoggingCategory category) {
            return category.blockModifyLogging();
        }
    }
    ,
    PLACE{

        @Override
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventPlace(cause, transactions);
        }

        @Override
        public boolean shouldFire() {
            return ShouldFire.CHANGE_BLOCK_EVENT_PLACE;
        }

        @Override
        public EventContextKey<? extends ChangeBlockEvent> getKey() {
            return EventContextKeys.PLACE_EVENT;
        }

        @Override
        public boolean allowsLogging(LoggingCategory category) {
            return category.blockPlaceLogging();
        }
    }
    ,
    GROW{

        @Override
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventGrow(cause, transactions);
        }

        @Override
        public boolean shouldFire() {
            return ShouldFire.CHANGE_BLOCK_EVENT_GROW;
        }

        @Override
        public EventContextKey<? extends ChangeBlockEvent> getKey() {
            return EventContextKeys.GROW_EVENT;
        }
    };


    public boolean allowsLogging(LoggingCategory category) {
        return false;
    }

    public abstract ChangeBlockEvent createEvent(Cause var1, ImmutableList<Transaction<BlockSnapshot>> var2);

    public abstract boolean shouldFire();

    public abstract EventContextKey<? extends ChangeBlockEvent> getKey();
}

