/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import org.spongepowered.api.world.gen.populator.ChorusFlower;
import org.spongepowered.common.world.gen.populators.ChorusFlowerPopulator;

public class ChorusFlowerBuilder
implements ChorusFlower.Builder {
    private int exclusion = 1024;

    public ChorusFlowerBuilder() {
        this.reset();
    }

    @Override
    public ChorusFlower.Builder exclusionRadius(int radius) {
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (Object)"Exclusion radius must be postive or zero");
        this.exclusion = radius;
        return this;
    }

    @Override
    public ChorusFlower.Builder from(ChorusFlower value) {
        return this;
    }

    @Override
    public ChorusFlower.Builder reset() {
        this.exclusion = 1024;
        return this;
    }

    @Override
    public ChorusFlower build() throws IllegalStateException {
        ChorusFlowerPopulator pop = new ChorusFlowerPopulator();
        pop.setExclusionRadius(this.exclusion);
        return pop;
    }
}

