/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.pregen;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.world.ChunkPreGenerationEvent;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.ChunkPreGenerate;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderServerBridge;
import org.spongepowered.common.world.pregen.SpongeChunkPreGenerateListener;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

public class SpongeChunkPreGenerateTask
implements ChunkPreGenerate,
Consumer<Task> {
    private static final int DEFAULT_TICK_INTERVAL = 4;
    private static final float DEFAULT_TICK_PERCENT = 0.8f;
    private static final Vector3i[] OFFSETS = new Vector3i[]{Vector3i.UNIT_Z.negate().mul(2), Vector3i.UNIT_X.mul(2), Vector3i.UNIT_Z.mul(2), Vector3i.UNIT_X.negate().mul(2)};
    private final Scheduler scheduler = Sponge.getScheduler();
    private final World world;
    private final Predicate<Vector3i> doesChunkExistCheck;
    private final int chunkRadius;
    private final int chunkCount;
    private final float tickPercent;
    private final long tickTimeLimit;
    private final Cause cause;
    private final int totalChunksToGenerate;
    private final Task spongeTask;
    private final int tickInterval;
    private final Object plugin;
    @Nullable
    private final EventListener<ChunkPreGenerationEvent> eventListener;
    private Vector3i currentPosition;
    private int currentGenCount;
    private int currentLayer;
    private int currentIndex;
    private int nextJump;
    private int chunksSkipped = 0;
    private int chunksGenerated = 0;
    private long generationStartTime = 0L;
    private long generationEndTime = 0L;
    private boolean isCancelled = false;

    private SpongeChunkPreGenerateTask(Object plugin, World world, Vector3d center, double diameter, int chunkCount, float tickPercent, int tickInterval, Cause cause, List<Consumer<ChunkPreGenerationEvent>> eventListeners) {
        int preferredTickInterval = this.scheduler.getPreferredTickInterval();
        this.plugin = plugin;
        this.world = world;
        this.doesChunkExistCheck = world.getWorldStorage() instanceof ChunkProviderServerBridge ? this::checkChunkExistsAnvil : v -> false;
        this.chunkRadius = GenericMath.floor(diameter / 32.0);
        this.chunkCount = chunkCount;
        this.tickPercent = tickPercent;
        this.tickTimeLimit = Math.round((float)preferredTickInterval * tickPercent);
        this.cause = cause;
        this.tickInterval = tickInterval;
        Optional<Vector3i> currentPosition = SpongeChunkLayout.instance.toChunk(center.toInt());
        if (!currentPosition.isPresent()) {
            throw new IllegalArgumentException("Center is not a valid chunk coordinate");
        }
        this.currentPosition = currentPosition.get();
        this.currentGenCount = 4;
        this.currentLayer = 0;
        this.currentIndex = 0;
        this.nextJump = 0;
        this.totalChunksToGenerate = (int)Math.pow(this.chunkRadius * 2 + 1, 2.0);
        this.spongeTask = this.scheduler.createTaskBuilder().intervalTicks(tickInterval).execute(this).submit(plugin);
        if (!eventListeners.isEmpty()) {
            this.eventListener = new SpongeChunkPreGenerateListener(this.spongeTask.getUniqueId(), eventListeners);
            Sponge.getEventManager().registerListener(plugin, ChunkPreGenerationEvent.class, this.eventListener);
        } else {
            this.eventListener = null;
        }
    }

    Task getSpongeTask() {
        return this.spongeTask;
    }

    @Override
    public WorldProperties getWorldProperties() {
        return this.world.getProperties();
    }

    @Override
    public int getTotalGeneratedChunks() {
        return this.chunksGenerated;
    }

    @Override
    public int getTotalSkippedChunks() {
        return this.chunksSkipped;
    }

    @Override
    public int getTargetTotalChunks() {
        return this.totalChunksToGenerate;
    }

    @Override
    public Duration getTotalTime() {
        return Duration.of((this.isCancelled() ? this.generationEndTime : System.currentTimeMillis()) - this.generationStartTime, ChronoUnit.MILLIS);
    }

    @Override
    public boolean isCancelled() {
        if (this.isCancelled) {
            return true;
        }
        if (!this.scheduler.getTaskById(this.spongeTask.getUniqueId()).isPresent()) {
            this.cancel();
        }
        return this.isCancelled;
    }

    @Override
    public void cancel() {
        if (!this.isCancelled) {
            if (this.eventListener != null) {
                Sponge.getEventManager().unregisterListeners(this.eventListener);
            }
            this.spongeTask.cancel();
            this.isCancelled = true;
        }
    }

    @Override
    public void accept(Task task) {
        long stepStartTime = System.currentTimeMillis();
        if (this.generationStartTime == 0L) {
            this.generationStartTime = stepStartTime;
        }
        ChunkPreGenerationEvent.Pre preEvent = SpongeEventFactory.createChunkPreGenerationEventPre(this.cause, this, this.world, false);
        if (Sponge.getEventManager().post(preEvent)) {
            this.cancelTask(task);
            return;
        }
        if (preEvent.getSkipStep()) {
            return;
        }
        int count = 0;
        int skipped = 0;
        do {
            Vector3i pos3;
            Vector3i pos2;
            Vector3i pos1;
            Vector3i position;
            if (!this.areAllChunksLoaded(position = this.nextChunkPosition(), pos1 = position.sub(Vector3i.UNIT_X), pos2 = position.sub(Vector3i.UNIT_Z), pos3 = pos2.sub(Vector3i.UNIT_X))) {
                this.world.loadChunk(position, true);
                this.world.loadChunk(pos1, true);
                this.world.loadChunk(pos2, true);
                this.world.loadChunk(pos3, true);
                count += this.currentGenCount;
                continue;
            }
            skipped += this.currentGenCount;
        } while (this.hasNextChunkPosition() && this.checkChunkCount(count) && this.checkTickTime(System.currentTimeMillis() - stepStartTime));
        this.chunksGenerated += count;
        this.chunksSkipped += skipped;
        long deltaTime = System.currentTimeMillis() - stepStartTime;
        this.generationEndTime = System.currentTimeMillis();
        if (Sponge.getEventManager().post(SpongeEventFactory.createChunkPreGenerationEventPost(this.cause, this, this.world, Duration.ofMillis(deltaTime), count, skipped))) {
            this.cancelTask(task);
            return;
        }
        if (!this.hasNextChunkPosition()) {
            Sponge.getEventManager().post(SpongeEventFactory.createChunkPreGenerationEventComplete(this.cause, this, this.world));
            this.isCancelled = true;
            this.unregisterListener();
            task.cancel();
        }
    }

    private boolean areAllChunksLoaded(Vector3i chunk1, Vector3i chunk2, Vector3i chunk3, Vector3i chunk4) {
        return this.doesChunkExistCheck.test(chunk1) && this.doesChunkExistCheck.test(chunk2) && this.doesChunkExistCheck.test(chunk3) && this.doesChunkExistCheck.test(chunk4);
    }

    private void unregisterListener() {
        if (this.eventListener != null) {
            Sponge.getEventManager().unregisterListeners(this.eventListener);
        }
    }

    private void cancelTask(Task task) {
        if (this.scheduler.getTaskById(task.getUniqueId()).isPresent()) {
            Sponge.getEventManager().post(SpongeEventFactory.createChunkPreGenerationEventCancelled(this.cause, this, this.world));
            task.cancel();
        }
        this.isCancelled = true;
        this.unregisterListener();
    }

    private boolean hasNextChunkPosition() {
        return this.currentLayer <= this.chunkRadius;
    }

    private Vector3i nextChunkPosition() {
        int currentLayerIndex;
        Vector3i nextPosition = this.currentPosition;
        if (this.currentIndex >= this.nextJump) {
            this.currentPosition = this.currentPosition.sub(Vector3i.UNIT_X).sub(Vector3i.UNIT_Z);
            ++this.currentLayer;
            this.nextJump += this.currentLayer * 4;
            currentLayerIndex = 1;
        } else {
            currentLayerIndex = this.currentIndex - (this.nextJump - this.currentLayer * 4);
            this.currentPosition = this.currentPosition.add(OFFSETS[currentLayerIndex / this.currentLayer]);
        }
        this.currentGenCount = currentLayerIndex % this.currentLayer == 0 ? 3 : 2;
        ++this.currentIndex;
        return nextPosition;
    }

    private boolean checkChunkCount(int count) {
        return this.chunkCount <= 0 || count < this.chunkCount;
    }

    private boolean checkTickTime(long tickTime) {
        return this.tickPercent <= 0.0f || tickTime < this.tickTimeLimit;
    }

    private boolean checkChunkExistsAnvil(Vector3i v) {
        CompletableFuture<Boolean> ret = ((ChunkProviderServerBridge)((Object)this.world.getWorldStorage())).bridge$doesChunkExistSync(v);
        try {
            return ret.get();
        }
        catch (InterruptedException | ExecutionException e) {
            SpongeImpl.getLogger().error("Could not determine chunk's existence on world {}: {} {}. Assuming false.", (Object)this.world.getName(), (Object)v.getX(), (Object)v.getZ());
            return false;
        }
    }

    public static class Builder
    implements ChunkPreGenerate.Builder {
        private static final String TIME_FORMAT = "s's 'S'ms'";
        private final World world;
        private final Vector3d center;
        private final double diameter;
        private final List<Consumer<ChunkPreGenerationEvent>> eventListeners = new ArrayList<Consumer<ChunkPreGenerationEvent>>();
        @Nullable
        private Object plugin;
        private int tickInterval = 4;
        private float tickPercent = 0.8f;
        private int chunksPerTick = 0;

        public Builder(World world, Vector3d center, double diameter) {
            this.world = world;
            this.center = center;
            this.diameter = diameter;
        }

        public Builder(World world, WorldBorder worldBorder) {
            this(world, worldBorder.getCenter(), worldBorder.getNewDiameter());
        }

        @Override
        public ChunkPreGenerate.Builder owner(Object plugin) {
            Preconditions.checkNotNull((Object)plugin, (Object)"plugin cannot be null");
            this.plugin = plugin;
            return this;
        }

        @Override
        public ChunkPreGenerate.Builder logger(@Nullable Logger logger) {
            if (logger != null) {
                this.addListener(event -> {
                    if (event instanceof ChunkPreGenerationEvent.Post) {
                        ChunkPreGenerationEvent.Post post = (ChunkPreGenerationEvent.Post)event;
                        logger.info("Generated {} chunks in {}, {}% complete", post.getChunksGeneratedThisStep(), DurationFormatUtils.formatDuration((long)post.getTimeTakenForStep().toMillis(), (String)TIME_FORMAT, (boolean)false), GenericMath.floor(100 * (post.getChunkPreGenerate().getTotalGeneratedChunks() + post.getChunkPreGenerate().getTotalSkippedChunks()) / post.getChunkPreGenerate().getTargetTotalChunks()));
                    } else if (event instanceof ChunkPreGenerationEvent.Complete) {
                        logger.info("Done! Generated a total of {} chunks in {}", (Object)event.getChunkPreGenerate().getTargetTotalChunks(), (Object)DurationFormatUtils.formatDuration((long)event.getChunkPreGenerate().getTotalTime().toMillis(), (String)TIME_FORMAT, (boolean)false));
                    }
                });
            }
            return this;
        }

        @Override
        public ChunkPreGenerate.Builder tickInterval(int tickInterval) {
            Preconditions.checkArgument((tickInterval > 0 ? 1 : 0) != 0, (Object)"tickInterval must be greater than zero");
            this.tickInterval = tickInterval;
            return this;
        }

        @Override
        public ChunkPreGenerate.Builder chunksPerTick(int chunkCount) {
            this.chunksPerTick = chunkCount;
            return this;
        }

        @Override
        public ChunkPreGenerate.Builder tickPercentLimit(float tickPercent) {
            Preconditions.checkArgument((tickPercent <= 1.0f ? 1 : 0) != 0, (Object)"tickPercent must be smaller or equal to 1");
            Preconditions.checkArgument((tickPercent > 0.0f ? 1 : 0) != 0, (Object)"tickPercent must be greater than 0");
            this.tickPercent = tickPercent;
            return this;
        }

        @Override
        public ChunkPreGenerate.Builder addListener(Consumer<ChunkPreGenerationEvent> listener) {
            Preconditions.checkNotNull(listener, (Object)"listener cannot be null");
            this.eventListeners.add(listener);
            return this;
        }

        @Override
        public ChunkPreGenerate start() {
            Preconditions.checkNotNull((Object)this.plugin, (Object)"owner cannot be null");
            Preconditions.checkArgument((this.chunksPerTick > 0 || this.tickPercent > 0.0f ? 1 : 0) != 0, (Object)"Must use at least one of \"chunks per tick\" or \"tick percent limit\"");
            Sponge.getCauseStackManager().pushCause(this.plugin);
            Cause cause = Sponge.getCauseStackManager().getCurrentCause();
            Sponge.getCauseStackManager().popCause();
            return new SpongeChunkPreGenerateTask(this.plugin, this.world, this.center, this.diameter, this.chunksPerTick, this.tickPercent, this.tickInterval, cause, this.eventListeners);
        }

        @Override
        public ChunkPreGenerate.Builder from(ChunkPreGenerate value) {
            if (!(value instanceof SpongeChunkPreGenerateTask)) {
                throw new IllegalArgumentException("Not a Sponge chunk pre-gen task");
            }
            SpongeChunkPreGenerateTask other = (SpongeChunkPreGenerateTask)value;
            this.plugin = other.plugin;
            return this.tickInterval(other.tickInterval).chunksPerTick(other.chunkCount).tickPercentLimit(other.tickPercent);
        }

        @Override
        public ChunkPreGenerate.Builder reset() {
            this.plugin = null;
            this.tickInterval = 0;
            this.chunksPerTick = 0;
            this.tickPercent = 0.8f;
            this.eventListeners.clear();
            return this;
        }
    }
}

