/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.MultiBlockCaptureSupplier;
import org.spongepowered.common.registry.type.world.BlockChangeFlagRegistryModule;
import org.spongepowered.common.util.VecHelper;

public class CapturedSnapshotWrapperList
extends ArrayList<BlockSnapshot>
implements List<BlockSnapshot> {
    private static final long serialVersionUID = -8973153582753299054L;
    private final World worldPointer;
    private List<SpongeBlockSnapshot> wrappedList = new ArrayList<SpongeBlockSnapshot>();
    @Nullable
    private List<BlockSnapshot> cachedSnapshots;

    private static SpongeBlockSnapshot toSponge(BlockSnapshot blockSnapshot) {
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        SpongeBlockSnapshot sponge = builder.worldId(((org.spongepowered.api.world.World)blockSnapshot.getWorld()).getUniqueId()).position(VecHelper.toVector3i(blockSnapshot.getPos())).blockState((BlockState)blockSnapshot.getReplacedBlock()).flag(BlockChangeFlagRegistryModule.fromNativeInt(blockSnapshot.getFlag())).unsafeNbt(blockSnapshot.getNbt()).build();
        return sponge;
    }

    private static BlockSnapshot toForge(SpongeBlockSnapshot spongeSnapshot) {
        UUID worldUniqueId = spongeSnapshot.getWorldUniqueId();
        org.spongepowered.api.world.World spongeWorld = Sponge.getServer().getWorld(worldUniqueId).orElseThrow(() -> new IllegalStateException("World with uuid: " + worldUniqueId + " not registered for snapshot:" + spongeSnapshot));
        World mcWorld = (World)spongeWorld;
        BlockPos blockPos = VecHelper.toBlockPos(spongeSnapshot.getPosition());
        IBlockState blockState = (IBlockState)spongeSnapshot.getState();
        NBTTagCompound nbtTagCompound = spongeSnapshot.getCompound().orElse(null);
        return new BlockSnapshot(mcWorld, blockPos, blockState, nbtTagCompound);
    }

    public CapturedSnapshotWrapperList(World world) {
        this.worldPointer = world;
    }

    private List<SpongeBlockSnapshot> getUnderlyingList() {
        if (SpongeImplHooks.isMainThread()) {
            PhaseContext<?> data = PhaseTracker.getInstance().getCurrentContext();
            if (data.state.doesBulkBlockCapture(data)) {
                return data.getCapturedBlockSupplier().get();
            }
            return this.wrappedList;
        }
        return this.wrappedList;
    }

    @Override
    public int size() {
        return this.getUnderlyingList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getUnderlyingList().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getCachedForgeList().contains(o);
    }

    private List<BlockSnapshot> getCachedForgeList() {
        this.populateCachedList();
        return this.cachedSnapshots;
    }

    private void populateCachedList() {
        List<SpongeBlockSnapshot> underlying = this.getUnderlyingList();
        if (underlying.isEmpty()) {
            this.cachedSnapshots = new ArrayList<BlockSnapshot>();
        }
        this.cachedSnapshots = new ArrayList<BlockSnapshot>(underlying.size());
        for (SpongeBlockSnapshot spongeSnapshot : underlying) {
            BlockSnapshot forgeSnapshot = CapturedSnapshotWrapperList.toForge(spongeSnapshot);
            this.cachedSnapshots.add(forgeSnapshot);
        }
    }

    @Override
    public Iterator<BlockSnapshot> iterator() {
        return this.getCachedForgeList().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getCachedForgeList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getCachedForgeList().toArray(a);
    }

    @Override
    public boolean add(BlockSnapshot blockSnapshot) {
        List<SpongeBlockSnapshot> underlyingList = this.getUnderlyingList();
        List<BlockSnapshot> cachedForgeList = this.getCachedForgeList();
        cachedForgeList.add(blockSnapshot);
        SpongeBlockSnapshot sponge = CapturedSnapshotWrapperList.toSponge(blockSnapshot);
        return underlyingList.add(sponge);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof BlockSnapshot)) {
            return false;
        }
        BlockSnapshot forgeSnapshot = (BlockSnapshot)o;
        SpongeBlockSnapshot spongeSnapshot = CapturedSnapshotWrapperList.toSponge(forgeSnapshot);
        List<SpongeBlockSnapshot> underlyingList = this.getUnderlyingList();
        List<BlockSnapshot> cachedForgeList = this.getCachedForgeList();
        cachedForgeList.remove(forgeSnapshot);
        PhaseContext<?> data = PhaseTracker.getInstance().getCurrentContext();
        if (data.state.doesBulkBlockCapture(data)) {
            data.getCapturedBlockSupplier().prune(spongeSnapshot);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getCachedForgeList().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends BlockSnapshot> c) {
        c.forEach(this::add);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends BlockSnapshot> c) {
        throw new UnsupportedOperationException("Sorry, but injecting snapshots into the wrapped capture list is unsupported by Sponge. If this is an expected operation, please report to SpongeForge's GitHub and explain the reasoning for needing to set at indexes.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getCachedForgeList().retainAll(c);
    }

    @Override
    public void clear() {
        if (this.cachedSnapshots != null) {
            this.cachedSnapshots.clear();
            this.cachedSnapshots = null;
        }
        if (this.wrappedList != null) {
            this.wrappedList.clear();
        }
    }

    @Override
    public BlockSnapshot get(int index) {
        return this.getCachedForgeList().get(index);
    }

    @Override
    public BlockSnapshot set(int index, BlockSnapshot element) {
        throw new UnsupportedOperationException("Sorry, but injecting snapshots into the wrapped capture list is unsupported by Sponge. If this is an expected operation, please report to SpongeForge's GitHub and explain the reasoning for needing to set at indexes.");
    }

    @Override
    public void add(int index, BlockSnapshot element) {
        List<SpongeBlockSnapshot> underlyingList = this.getUnderlyingList();
        List<BlockSnapshot> forgeList = this.getCachedForgeList();
        forgeList.add(index, element);
        SpongeBlockSnapshot sponge = CapturedSnapshotWrapperList.toSponge(element);
        underlyingList.add(index, sponge);
    }

    @Override
    public BlockSnapshot remove(int index) {
        List<BlockSnapshot> cachedForgeList = this.getCachedForgeList();
        BlockSnapshot remove = cachedForgeList.remove(index);
        try {
            PhaseContext<?> data = PhaseTracker.getInstance().getCurrentContext();
            if (data.state.doesBulkBlockCapture(data)) {
                MultiBlockCaptureSupplier capturedBlockSupplier = data.getCapturedBlockSupplier();
                SpongeBlockSnapshot snapshot = capturedBlockSupplier.get().get(index);
                if (snapshot != null) {
                    capturedBlockSupplier.prune(snapshot);
                }
            } else {
                this.wrappedList.remove(index);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return remove;
    }

    @Override
    public int indexOf(Object o) {
        return this.getCachedForgeList().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getCachedForgeList().indexOf(o);
    }

    @Override
    public ListIterator<BlockSnapshot> listIterator() {
        return this.getCachedForgeList().listIterator();
    }

    @Override
    public ListIterator<BlockSnapshot> listIterator(int index) {
        return this.getCachedForgeList().listIterator(index);
    }

    @Override
    public List<BlockSnapshot> subList(int fromIndex, int toIndex) {
        return this.getCachedForgeList().subList(fromIndex, toIndex);
    }
}

