/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.item.inventory.fabric;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.spongepowered.common.SpongeImpl;

public class IItemHandlerFabricUtil {
    private static Set<Class<?>> setStackUnsupported = new ReferenceOpenHashSet();

    public static void setIItemHandlerStack(IItemHandler handler, int index, ItemStack stack) {
        if (setStackUnsupported.contains(handler.getClass())) {
            return;
        }
        if (handler instanceof IItemHandlerModifiable) {
            try {
                ((IItemHandlerModifiable)handler).setStackInSlot(index, stack);
            }
            catch (RuntimeException e) {
                setStackUnsupported.add(handler.getClass());
                SpongeImpl.getLogger().warn("Modded Inventory refused setting slot. Sponge cannot handle modified slot transactions for this type of Inventory. " + handler.getClass());
            }
            return;
        }
        ItemStack prev = handler.getStackInSlot(index);
        if (!prev.func_190926_b()) {
            ItemStack extracted;
            for (int cnt = prev.func_190916_E(); cnt > 0; cnt -= extracted.func_190916_E()) {
                extracted = handler.extractItem(index, cnt, false);
                if (extracted.func_190916_E() != 0) continue;
                prev = handler.getStackInSlot(index);
                if (prev.func_190926_b()) break;
                setStackUnsupported.add(handler.getClass());
                SpongeImpl.getLogger().warn("Modded Inventory refused extraction. Sponge cannot handle modified slot transactions for this type of Inventory. " + handler.getClass());
                return;
            }
        }
        prev = stack;
        while (!stack.func_190926_b() && prev != (stack = handler.insertItem(index, stack, false)) && prev.func_190916_E() != stack.func_190916_E()) {
            prev = stack;
        }
    }
}

