/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.forge.common;

import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.DungeonHooks;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.registry.type.world.gen.DungeonMobRegistryModule;

@Mixin(value={DungeonHooks.class})
public class DungeonHooksMixin_Forge {
    @Inject(method={"addDungeonMob(Lnet/minecraft/util/ResourceLocation;I)F"}, at={@At(value="RETURN")}, remap=false)
    private static void forgeImpl$ValidateMob(CallbackInfoReturnable<Float> ci, ResourceLocation name, int rarity) {
        Optional<EntityType> type = EntityUtil.fromLocationToType(name);
        if (!type.isPresent()) {
            SpongeImpl.getLogger().error("Mod tried to add a DungeonMob for a non existant mob " + name + " !");
            return;
        }
        Float ret = ci.getReturnValue();
        DungeonMobRegistryModule.getInstance().put(type.get(), ret.intValue());
    }

    @Inject(method={"removeDungeonMob(Lnet/minecraft/util/ResourceLocation;)I"}, at={@At(value="HEAD")}, remap=false)
    private static void forgeImpl$validateEntityType(CallbackInfoReturnable<Integer> ci, ResourceLocation name) {
        Optional<EntityType> type = EntityUtil.fromLocationToType(name);
        if (!type.isPresent()) {
            SpongeImpl.getLogger().error("Mod tried to remove a DungeonMob for a non existant mob " + name + " !");
            return;
        }
        DungeonMobRegistryModule.getInstance().remove(type.get());
    }
}

