/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.nbt;

import java.lang.reflect.Method;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.util.PEBKACException;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;

@Mixin(value={NBTTagCompound.class})
public class NBTTagCompoundMixin_Forge {
    @Inject(method={"setTag(Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V"}, at={@At(value="HEAD")})
    private void sponge$throwNPEForNullTag(String key, NBTBase value, CallbackInfo callbackInfo) {
        if (value == null) {
            PrettyPrinter printer = new PrettyPrinter(60);
            printer.add("Null being stored in NBT!").centre().hr();
            printer.addWrapped("Sponge is forcing a shutdown of the game because someone is storing nulls in an NBTTagCompound. Our implementation and Minecraft's strictly prevents this from happening, however, certain mods are not null checking. Please provide this report in a report to the associated mod!", new Object[0]);
            ModContainer mod = Loader.instance().activeModContainer();
            if (mod != null) {
                printer.add("Potential Culprit: " + mod.getModId());
            } else {
                printer.add("Potential Culprit: Not known, analyze stacktrace for clues");
            }
            printer.add("NBT Key: %s", key);
            printer.add("Exception!");
            PEBKACException pebkacException = new PEBKACException("Someone is trying to store a null to an NBTTagCompound!");
            printer.add(pebkacException);
            printer.log(SpongeImpl.getLogger(), Level.ERROR);
            try {
                Class<?> terminateVm = Class.forName("org.spongepowered.mixin.handler.TerminateVM");
                Method terminate = terminateVm.getMethod("terminate", new Class[0]);
                terminate.setAccessible(true);
                terminate.invoke(null, "net.minecraftforge.fml", -2);
            }
            catch (Exception e) {
                FMLCommonHandler.instance().exitJava(-2, true);
            }
        }
    }
}

