/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.world.storage;

import java.io.File;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.storage.SaveFormatOld;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.spongepowered.api.Sponge;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.world.storage.SaveHandlerBridge;
import org.spongepowered.common.plugin.PluginContainerExtension;
import org.spongepowered.mod.SpongeMod;

@Mixin(value={SaveHandler.class}, priority=1001)
public abstract class SaveHandlerMixin_Forge {
    @Shadow
    @Final
    protected DataFixer field_186341_a;
    @Shadow
    @Final
    private File field_75770_b;
    private File forgeImpl$modWorldDirectory = null;

    @Redirect(method={"saveWorldInfoWithPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/FMLCommonHandler;handleWorldDataSave(Lnet/minecraft/world/storage/SaveHandler;Lnet/minecraft/world/storage/WorldInfo;Lnet/minecraft/nbt/NBTTagCompound;)V", remap=false))
    private void forgeImpl$RedirectDataSaving(FMLCommonHandler fml, SaveHandler handler, WorldInfo worldInformation, NBTTagCompound compound) {
        if (fml.getSavesDirectory().equals(this.field_75770_b.getParentFile())) {
            fml.handleWorldDataSave(handler, worldInformation, compound);
        }
    }

    @Redirect(method={"loadWorldInfo"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/SaveFormatOld;loadAndFix(Ljava/io/File;Lnet/minecraft/util/datafix/DataFixer;Lnet/minecraft/world/storage/SaveHandler;)Lnet/minecraft/world/storage/WorldInfo;", remap=false))
    private WorldInfo forgeImpl$hookToUpdateSpongeLoadData(File file, DataFixer fixer, SaveHandler handler) {
        WorldInfo worldInfo = SaveFormatOld.loadAndFix((File)file, (DataFixer)fixer, (SaveHandler)handler);
        if (worldInfo != null) {
            try {
                ((SaveHandlerBridge)handler).bridge$loadSpongeDatData(worldInfo);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception trying to load level_sponge.dat, file corruption maybe?", e);
            }
        }
        return worldInfo;
    }

    @Inject(method={"getWorldDirectory"}, at={@At(value="HEAD")}, cancellable=true)
    private void forgeImpl$useWorldSaveDirectoryforMods(CallbackInfoReturnable<File> cir) {
        ModContainer activeContainer = Loader.instance().activeModContainer();
        if (activeContainer != null && activeContainer != SpongeMod.instance && !(activeContainer instanceof PluginContainerExtension)) {
            if (this.forgeImpl$modWorldDirectory != null) {
                cir.setReturnValue(this.forgeImpl$modWorldDirectory);
            } else {
                String defaultWorldName = Sponge.getServer().getDefaultWorldName();
                String defaultWorldPath = Sponge.getPlatform().getType().isClient() ? "saves" + File.separator + defaultWorldName : defaultWorldName;
                this.forgeImpl$modWorldDirectory = SpongeImpl.getGameDir().resolve(defaultWorldPath).toFile();
                cir.setReturnValue(this.forgeImpl$modWorldDirectory);
            }
        }
    }
}

