/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.network;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandler;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.relauncher.Side;
import org.spongepowered.api.Platform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelRegistrar;
import org.spongepowered.api.network.Message;
import org.spongepowered.api.network.MessageHandler;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.mod.network.SpongeMessageCodec;
import org.spongepowered.mod.network.SpongeMessageInboundHandler;
import org.spongepowered.mod.network.SpongeModChannelBinding;

class SpongeIndexedMessageChannel
extends SpongeModChannelBinding
implements ChannelBinding.IndexedMessageChannel {
    private SpongeMessageCodec packetCodec;
    private final Set<Class<? extends Message>> knownClasses = new ReferenceOpenHashSet();

    public SpongeIndexedMessageChannel(ChannelRegistrar registrar, String channelName, PluginContainer owner) {
        super(registrar, channelName, owner);
    }

    @Override
    protected ChannelHandler[] getHandlers() {
        ChannelHandler[] channelHandlerArray = new ChannelHandler[1];
        this.packetCodec = new SpongeMessageCodec();
        channelHandlerArray[0] = this.packetCodec;
        return channelHandlerArray;
    }

    @Override
    public void registerMessage(Class<? extends Message> messageClass, int messageId) {
        this.checkValidState();
        Preconditions.checkArgument((!this.knownClasses.contains(Preconditions.checkNotNull(messageClass, (Object)"messageClass")) ? 1 : 0) != 0, (Object)"Message class already registered");
        this.packetCodec.addDiscriminator(messageId, messageClass);
        this.knownClasses.add(messageClass);
    }

    @Override
    public <M extends Message> void registerMessage(Class<M> messageClass, int messageId, MessageHandler<M> handler) {
        Preconditions.checkNotNull(handler, (Object)"handler");
        this.registerMessage(messageClass, messageId);
        this.addHandlerForSide(Platform.Type.CLIENT, messageClass, handler);
        this.addHandlerForSide(Platform.Type.SERVER, messageClass, handler);
    }

    @Override
    public <M extends Message> void registerMessage(Class<M> messageClass, int messageId, Platform.Type side, MessageHandler<M> handler) {
        Preconditions.checkNotNull(handler, (Object)"handler");
        Preconditions.checkArgument((boolean)((Platform.Type)((Object)Preconditions.checkNotNull((Object)((Object)side), (Object)"side"))).isKnown(), (Object)"Invalid side");
        this.registerMessage(messageClass, messageId);
        this.addHandlerForSide(side, messageClass, handler);
    }

    @Override
    public <M extends Message> void addHandler(Class<M> messageClass, Platform.Type side, MessageHandler<M> handler) {
        Preconditions.checkArgument((boolean)this.knownClasses.contains(Preconditions.checkNotNull(messageClass, (Object)"messageClass")), (String)"Message class %s is not registered", messageClass);
        Preconditions.checkNotNull(handler, (Object)"handler");
        Preconditions.checkArgument((boolean)((Platform.Type)((Object)Preconditions.checkNotNull((Object)((Object)side), (Object)"side"))).isKnown(), (Object)"Invalid side");
        this.addHandlerForSide(side, messageClass, handler);
    }

    @Override
    public <M extends Message> void addHandler(Class<M> messageClass, MessageHandler<M> handler) {
        Preconditions.checkArgument((boolean)this.knownClasses.contains(Preconditions.checkNotNull(messageClass, (Object)"messageClass")), (String)"Message class %s is not registered", messageClass);
        Preconditions.checkNotNull(handler, (Object)"handler");
        this.addHandlerForSide(Platform.Type.CLIENT, messageClass, handler);
        this.addHandlerForSide(Platform.Type.SERVER, messageClass, handler);
    }

    private <M extends Message> void addHandlerForSide(Platform.Type side, Class<M> messageClass, MessageHandler<M> handler) {
        FMLEmbeddedChannel channel = (FMLEmbeddedChannel)this.channels.get(side.isClient() ? Side.CLIENT : Side.SERVER);
        String type = channel.findChannelHandlerNameForType(SpongeMessageCodec.class);
        SpongeMessageInboundHandler<M> channelHandler = new SpongeMessageInboundHandler<M>(handler, messageClass, side);
        channel.pipeline().addAfter(type, handler.getClass().getName(), channelHandler);
    }

    private Message checkMessage(Message message) {
        Preconditions.checkArgument((boolean)this.knownClasses.contains(((Message)Preconditions.checkNotNull((Object)message, (Object)"message")).getClass()), (Object)"unknown message type");
        return message;
    }

    @Override
    public void sendTo(Player player, Message message) {
        super.sendTo(player, this.checkMessage(message));
    }

    @Override
    public void sendToServer(Message message) {
        super.sendToServer(this.checkMessage(message));
    }

    @Override
    public void sendToAll(Message message) {
        super.sendToAll(this.checkMessage(message));
    }
}

