/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.service.permission;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.registry.RegistryHelper;

public enum SpongePermissionHandler implements IPermissionHandler
{
    INSTANCE;


    public void adopt() {
        PermissionAPI.setPermissionHandler((IPermissionHandler)this);
    }

    public void forceAdoption() {
        SpongeImpl.getLogger().debug("Forcing adoption of the Sponge permission handler - previous handler was '{}'", (Object)PermissionAPI.getPermissionHandler().getClass().getName());
        RegistryHelper.setFinalStatic(PermissionAPI.class, "permissionHandler", (Object)this);
    }

    public void registerNode(String node, DefaultPermissionLevel level, String desc) {
        PluginContainer activeContainer = SpongeImplHooks.getActiveModContainer();
        PermissionDescription.Builder builder = this.getService().newDescriptionBuilder(activeContainer);
        builder.id(node).description(Text.of(desc)).register();
    }

    public Collection<String> getRegisteredNodes() {
        return this.getService().getDescriptions().stream().map(desc -> desc.getId()).collect(Collectors.toCollection(() -> new LinkedList()));
    }

    public boolean hasPermission(GameProfile profile, String node, @Nullable IContext context) {
        Subject subject = this.getService().getUserSubjects().getSubject(profile.getId().toString()).orElse(null);
        if (subject != null) {
            if (context != null && context.getPlayer() != null) {
                return subject.hasPermission(((Player)context.getPlayer()).getActiveContexts(), node);
            }
            return subject.hasPermission(node);
        }
        return false;
    }

    public String getNodeDescription(String node) {
        PermissionDescription desc = this.getService().getDescription(node).orElse(null);
        return desc == null ? "" : TextSerializers.FORMATTING_CODE.serialize(desc.getDescription().orElse(Text.EMPTY));
    }

    private PermissionService getService() {
        return Sponge.getServiceManager().provideUnchecked(PermissionService.class);
    }
}

