/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.animation;

import java.lang.ref.WeakReference;

public enum Animation {
    INSTANCE;

    private float clientPartialTickTime;
    private static long epochTime;
    private static WeakReference<amu> worldRef;

    public static float getWorldTime(amu world) {
        return Animation.getWorldTime(world, 0.0f);
    }

    public static float getWorldTime(amu world, float tickProgress) {
        if (worldRef == null || worldRef.get() != world) {
            epochTime = world.R();
            worldRef = new WeakReference<amu>(world);
        }
        return ((float)(world.R() - epochTime) + tickProgress) / 20.0f;
    }

    public static float getPartialTickTime() {
        return Animation.INSTANCE.clientPartialTickTime;
    }

    public static void setClientPartialTickTime(float clientPartialTickTime) {
        Animation.INSTANCE.clientPartialTickTime = clientPartialTickTime;
    }
}

