/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidTankProperties
implements IFluidTankProperties {
    @Nullable
    private final FluidStack contents;
    private final int capacity;
    private final boolean canFill;
    private final boolean canDrain;

    public static FluidTankProperties[] convert(FluidTankInfo[] fluidTankInfos) {
        FluidTankProperties[] properties = new FluidTankProperties[fluidTankInfos.length];
        for (int i = 0; i < fluidTankInfos.length; ++i) {
            FluidTankInfo info = fluidTankInfos[i];
            properties[i] = new FluidTankProperties(info.fluid, info.capacity);
        }
        return properties;
    }

    public FluidTankProperties(@Nullable FluidStack contents, int capacity) {
        this(contents, capacity, true, true);
    }

    public FluidTankProperties(@Nullable FluidStack contents, int capacity, boolean canFill, boolean canDrain) {
        this.contents = contents;
        this.capacity = capacity;
        this.canFill = canFill;
        this.canDrain = canDrain;
    }

    @Override
    @Nullable
    public FluidStack getContents() {
        return this.contents == null ? null : this.contents.copy();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean canFill() {
        return this.canFill;
    }

    @Override
    public boolean canDrain() {
        return this.canDrain;
    }

    @Override
    public boolean canFillFluidType(FluidStack fluidStack) {
        return this.canFill;
    }

    @Override
    public boolean canDrainFluidType(FluidStack fluidStack) {
        return this.canDrain;
    }
}

