/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import org.apache.logging.log4j.Level;

public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private ListMultimap<ModContainer, EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private Map<String, ModContainer> entityNames = Maps.newHashMap();
    private BiMap<Class<? extends rw>, EntityRegistration> entityClassRegistrations = HashBiMap.create();

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
    }

    public static void registerModEntity(Class<? extends rw> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    public static void registerModEntity(Class<? extends rw> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        EntityRegistry.instance().doModEntityRegistration(entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntityRegistry.registerEgg(entityClass, eggPrimary, eggSecondary);
    }

    private void doModEntityRegistration(Class<? extends rw> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        EntityRegistration er = new EntityRegistration(mc, entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)er);
            this.entityNames.put(entityName, mc);
            if (!ry.d.containsKey(entityClass)) {
                String entityModName = String.format("%s.%s", mc.getModId(), entityName);
                ry.d.put(entityClass, entityModName);
                ry.c.put(entityModName, entityClass);
                FMLLog.finer("Automatically registered mod %s entity %s as %s", mc.getModId(), entityName, entityModName);
            } else {
                FMLLog.fine("Skipping automatic mod %s entity registration for already registered class %s", mc.getModId(), entityClass.getName());
            }
        }
        catch (IllegalArgumentException e2) {
            FMLLog.log(Level.WARN, e2, "The mod %s tried to register the entity (name,class) (%s,%s) one or both of which are already registered", mc.getModId(), entityName, entityClass.getName());
            return;
        }
        this.entityRegistrations.put((Object)mc, (Object)er);
    }

    public static void registerEgg(Class<? extends rw> entityClass, int primary, int secondary) {
        if (ry.d.containsKey(entityClass)) {
            String name = (String)ry.d.get(entityClass);
            ry.a.put(name, new ry.a(name, primary, secondary));
            FMLLog.fine("Registering entity egg '%s' for %s", name, entityClass);
        } else {
            FMLLog.fine("Failed registering entity egg %s (No entity found)", entityClass.getName());
        }
    }

    public static void addSpawn(Class<? extends sg> entityClass, int weightedProb, int min, int max, sh typeOfCreature, aiq ... biomes) {
        for (aiq biome : biomes) {
            List spawns = biome.a(typeOfCreature);
            boolean found = false;
            for (aiq.c entry : spawns) {
                if (entry.b != entityClass) continue;
                entry.a = weightedProb;
                entry.c = min;
                entry.d = max;
                found = true;
                break;
            }
            if (found) continue;
            spawns.add(new aiq.c(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, sh typeOfCreature, aiq ... biomes) {
        Class entityClazz = (Class)ry.c.get(entityName);
        if (sg.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.addSpawn(entityClazz, weightedProb, min, max, typeOfCreature, biomes);
        }
    }

    public static void removeSpawn(Class<? extends sg> entityClass, sh typeOfCreature, aiq ... biomes) {
        for (aiq biome : biomes) {
            Iterator spawns = biome.a(typeOfCreature).iterator();
            while (spawns.hasNext()) {
                aiq.c entry = (aiq.c)spawns.next();
                if (entry.b != entityClass) continue;
                spawns.remove();
            }
        }
    }

    public static void removeSpawn(String entityName, sh typeOfCreature, aiq ... biomes) {
        Class entityClazz = (Class)ry.c.get(entityName);
        if (sg.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.removeSpawn(entityClazz, typeOfCreature, biomes);
        }
    }

    public EntityRegistration lookupModSpawn(Class<? extends rw> clazz, boolean keepLooking) {
        Class<? extends rw> localClazz = clazz;
        do {
            EntityRegistration er;
            if ((er = (EntityRegistration)this.entityClassRegistrations.get(localClazz)) == null) continue;
            return er;
        } while (keepLooking &= !Object.class.equals(localClazz = localClazz.getSuperclass()));
        return null;
    }

    public EntityRegistration lookupModSpawn(ModContainer mc, int modEntityId) {
        for (EntityRegistration er : this.entityRegistrations.get((Object)mc)) {
            if (er.getModEntityId() != modEntityId) continue;
            return er;
        }
        return null;
    }

    public boolean tryTrackingEntity(lp entityTracker, rw entity) {
        EntityRegistration er = this.lookupModSpawn(entity.getClass(), true);
        if (er != null) {
            entityTracker.a(entity, er.getTrackingRange(), er.getUpdateFrequency(), er.sendsVelocityUpdates());
            return true;
        }
        return false;
    }

    public class EntityRegistration {
        private Class<? extends rw> entityClass;
        private ModContainer container;
        private String entityName;
        private int modId;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendsVelocityUpdates;
        private Function<FMLMessage.EntitySpawnMessage, rw> customSpawnCallback;
        private boolean usesVanillaSpawning;

        public EntityRegistration(ModContainer mc, Class<? extends rw> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this.container = mc;
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.modId = id;
            this.trackingRange = trackingRange;
            this.updateFrequency = updateFrequency;
            this.sendsVelocityUpdates = sendsVelocityUpdates;
        }

        public Class<? extends rw> getEntityClass() {
            return this.entityClass;
        }

        public ModContainer getContainer() {
            return this.container;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public int getModEntityId() {
            return this.modId;
        }

        public int getTrackingRange() {
            return this.trackingRange;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public boolean sendsVelocityUpdates() {
            return this.sendsVelocityUpdates;
        }

        public boolean usesVanillaSpawning() {
            return this.usesVanillaSpawning;
        }

        public boolean hasCustomSpawning() {
            return this.customSpawnCallback != null;
        }

        public rw doCustomSpawning(FMLMessage.EntitySpawnMessage spawnMsg) throws Exception {
            return (rw)this.customSpawnCallback.apply((Object)spawnMsg);
        }

        public void setCustomSpawning(Function<FMLMessage.EntitySpawnMessage, rw> callable, boolean usesVanillaSpawning) {
            this.customSpawnCallback = callable;
            this.usesVanillaSpawning = usesVanillaSpawning;
        }
    }
}

