/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Strings;
import com.google.common.collect.SetMultimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import net.minecraftforge.fml.relauncher.Side;

public class AutomaticEventSubscriber {
    private static final EnumSet<Side> DEFAULT = EnumSet.allOf(Side.class);

    public static void inject(ModContainer mod, ASMDataTable data, Side side) {
        FMLLog.log.debug("Attempting to inject @EventBusSubscriber classes into the eventbus for {}", new Object[]{mod.getModId()});
        SetMultimap<String, ASMDataTable.ASMData> modData = data.getAnnotationsFor(mod);
        Set mods = modData.get((Object)Mod.class.getName());
        Set targets = modData.get((Object)Mod.EventBusSubscriber.class.getName());
        ModClassLoader mcl = Loader.instance().getModClassLoader();
        for (ASMDataTable.ASMData targ : targets) {
            try {
                List sidesEnum = (List)targ.getAnnotationInfo().get("value");
                EnumSet<Side> sides = DEFAULT;
                if (sidesEnum != null) {
                    sides = EnumSet.noneOf(Side.class);
                    for (ModAnnotation.EnumHolder h2 : sidesEnum) {
                        sides.add(Side.valueOf(h2.getValue()));
                    }
                }
                if (sides != DEFAULT && !sides.contains((Object)side)) continue;
                FMLLog.log.debug("Found @EventBusSubscriber class {}", new Object[]{targ.getClassName()});
                String amodid = (String)targ.getAnnotationInfo().get("modid");
                if (Strings.isNullOrEmpty((String)amodid) && Strings.isNullOrEmpty((String)(amodid = ASMDataTable.getOwnerModID(mods, targ)))) {
                    FMLLog.bigWarning("Could not determine owning mod for @EventBusSubscriber on {} for mod {}", targ.getClassName(), mod.getModId());
                    continue;
                }
                if (!mod.getModId().equals(amodid)) {
                    FMLLog.log.debug("Skipping @EventBusSubscriber injection for {} since it is not for mod {}", new Object[]{targ.getClassName(), mod.getModId()});
                    continue;
                }
                Class<?> subscriptionTarget = Class.forName(targ.getClassName(), true, mcl);
                MinecraftForge.EVENT_BUS.register(subscriptionTarget);
                FMLLog.log.debug("Injected @EventBusSubscriber class {}", new Object[]{targ.getClassName()});
            }
            catch (Exception e) {
                FMLLog.log.error("An error occurred trying to load an EventBusSubscriber {} for modid {}", new Object[]{mod.getModId(), e});
                throw new LoaderException(e);
            }
        }
    }
}

