/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import java.util.Arrays;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ObfuscationReflectionHelper {
    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, int fieldIndex) {
        try {
            return ReflectionHelper.getPrivateValue(classToAccess, instance, fieldIndex);
        }
        catch (ReflectionHelper.UnableToAccessFieldException e2) {
            FMLLog.log.error("There was a problem getting field index {} from {}", new Object[]{classToAccess.getName(), e2});
            throw e2;
        }
    }

    public static String[] remapFieldNames(String className, String ... fieldNames) {
        String internalClassName = FMLDeobfuscatingRemapper.INSTANCE.unmap(className.replace('.', '/'));
        String[] mappedNames = new String[fieldNames.length];
        int i = 0;
        for (String fName : fieldNames) {
            mappedNames[i++] = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(internalClassName, fName, null);
        }
        return mappedNames;
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, String ... fieldNames) {
        try {
            return ReflectionHelper.getPrivateValue(classToAccess, instance, ObfuscationReflectionHelper.remapFieldNames(classToAccess.getName(), fieldNames));
        }
        catch (ReflectionHelper.UnableToFindFieldException e2) {
            FMLLog.log.error("Unable to locate any field {} on type {}", new Object[]{Arrays.toString(fieldNames), classToAccess.getName(), e2});
            throw e2;
        }
        catch (ReflectionHelper.UnableToAccessFieldException e3) {
            FMLLog.log.error("Unable to access any field {} on type {}", new Object[]{classToAccess.getName(), e3});
            throw e3;
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, int fieldIndex) {
        try {
            ReflectionHelper.setPrivateValue(classToAccess, instance, value, fieldIndex);
        }
        catch (ReflectionHelper.UnableToAccessFieldException e2) {
            FMLLog.log.error("There was a problem setting field index {} on type {}", new Object[]{classToAccess.getName(), e2});
            throw e2;
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, String ... fieldNames) {
        try {
            ReflectionHelper.setPrivateValue(classToAccess, instance, value, ObfuscationReflectionHelper.remapFieldNames(classToAccess.getName(), fieldNames));
        }
        catch (ReflectionHelper.UnableToFindFieldException e2) {
            FMLLog.log.error("Unable to locate any field {} on type {}", new Object[]{classToAccess.getName(), e2});
            throw e2;
        }
        catch (ReflectionHelper.UnableToAccessFieldException e3) {
            FMLLog.log.error("Unable to set any field {} on type {}", new Object[]{classToAccess.getName(), e3});
            throw e3;
        }
    }
}

