/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.handshake;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage;
import net.minecraftforge.fml.common.network.handshake.IHandshakeState;

public class HandshakeMessageHandler<S extends Enum<S>>
extends SimpleChannelInboundHandler<FMLHandshakeMessage> {
    private static final AttributeKey<IHandshakeState<?>> STATE = AttributeKey.valueOf((String)"fml:handshake-state");
    private final AttributeKey<S> fmlHandshakeState = STATE;
    private S initialState;
    private Class<S> stateType;

    public HandshakeMessageHandler(Class<S> stateType) {
        this.initialState = Enum.valueOf(stateType, "START");
        this.stateType = stateType;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FMLHandshakeMessage msg) throws Exception {
        Enum state = (Enum)ctx.attr(this.fmlHandshakeState).get();
        FMLLog.log.debug("{}: {}->{}:{}", new Object[]{this.stateType.getSimpleName(), msg.toString(this.stateType), state.getClass().getName().substring(state.getClass().getName().lastIndexOf(46) + 1), state});
        Enum newState = (Enum)((IHandshakeState)((Object)state)).accept(ctx, msg);
        FMLLog.log.debug("  Next: {}", new Object[]{newState.name()});
        ctx.attr(this.fmlHandshakeState).set((Object)newState);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.attr(this.fmlHandshakeState).set(this.initialState);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        Enum state = (Enum)ctx.attr(this.fmlHandshakeState).get();
        FMLLog.log.debug("{}: null->{}:{}", new Object[]{this.stateType.getSimpleName(), state.getClass().getName().substring(state.getClass().getName().lastIndexOf(46) + 1), state});
        Enum newState = (Enum)((IHandshakeState)((Object)state)).accept(ctx, null);
        FMLLog.log.debug("  Next: {}", new Object[]{newState.name()});
        ctx.attr(this.fmlHandshakeState).set((Object)newState);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log.error("HandshakeMessageHandler exception", cause);
        super.exceptionCaught(ctx, cause);
    }
}

