/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class RenderTooltipEvent
extends Event {
    @Nonnull
    protected final aip stack;
    protected final List<String> lines;
    protected int x;
    protected int y;
    protected bip fr;

    public RenderTooltipEvent(@Nonnull aip stack, @Nonnull List<String> lines, int x, int y, @Nonnull bip fr) {
        this.stack = stack;
        this.lines = Collections.unmodifiableList(lines);
        this.x = x;
        this.y = y;
        this.fr = fr;
    }

    @Nonnull
    public aip getStack() {
        return this.stack;
    }

    @Nonnull
    public List<String> getLines() {
        return this.lines;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Nonnull
    public bip getFontRenderer() {
        return this.fr;
    }

    public static class PostText
    extends Post {
        public PostText(@Nonnull aip stack, @Nonnull List<String> textLines, int x, int y, @Nonnull bip fr, int width, int height) {
            super(stack, textLines, x, y, fr, width, height);
        }
    }

    public static class PostBackground
    extends Post {
        public PostBackground(@Nonnull aip stack, @Nonnull List<String> textLines, int x, int y, @Nonnull bip fr, int width, int height) {
            super(stack, textLines, x, y, fr, width, height);
        }
    }

    protected static abstract class Post
    extends RenderTooltipEvent {
        private final int width;
        private final int height;

        public Post(@Nonnull aip stack, @Nonnull List<String> textLines, int x, int y, @Nonnull bip fr, int width, int height) {
            super(stack, textLines, x, y, fr);
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    @Cancelable
    public static class Pre
    extends RenderTooltipEvent {
        private int screenWidth;
        private int screenHeight;
        private int maxWidth;

        public Pre(@Nonnull aip stack, @Nonnull List<String> lines, int x, int y, int screenWidth, int screenHeight, int maxWidth, @Nonnull bip fr) {
            super(stack, lines, x, y, fr);
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            this.maxWidth = maxWidth;
        }

        public int getScreenWidth() {
            return this.screenWidth;
        }

        public void setScreenWidth(int screenWidth) {
            this.screenWidth = screenWidth;
        }

        public int getScreenHeight() {
            return this.screenHeight;
        }

        public void setScreenHeight(int screenHeight) {
            this.screenHeight = screenHeight;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        public void setFontRenderer(@Nonnull bip fr) {
            this.fr = fr;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }
    }
}

