/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.property;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ExtendedBlockState
extends awu {
    private final ImmutableSet<IUnlistedProperty<?>> unlistedProperties;

    public ExtendedBlockState(aow blockIn, axj<?>[] properties, IUnlistedProperty<?>[] unlistedProperties) {
        super(blockIn, properties, ExtendedBlockState.buildUnlistedMap(unlistedProperties));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IUnlistedProperty<?> property : unlistedProperties) {
            builder.add(property);
        }
        this.unlistedProperties = builder.build();
    }

    public Collection<IUnlistedProperty<?>> getUnlistedProperties() {
        return this.unlistedProperties;
    }

    private static ImmutableMap<IUnlistedProperty<?>, Optional<?>> buildUnlistedMap(IUnlistedProperty<?>[] unlistedProperties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IUnlistedProperty<?> p2 : unlistedProperties) {
            builder.put(p2, Optional.empty());
        }
        return builder.build();
    }

    @Nonnull
    protected awu.a createState(@Nonnull aow block, @Nonnull ImmutableMap<axj<?>, Comparable<?>> properties, @Nullable ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        if (unlistedProperties == null || unlistedProperties.isEmpty()) {
            return super.createState(block, properties, unlistedProperties);
        }
        return new ExtendedStateImplementation(block, properties, unlistedProperties, null, null);
    }

    protected static class ExtendedStateImplementation
    extends awu.a
    implements IExtendedBlockState {
        private final ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties;
        private awt cleanState;

        protected ExtendedStateImplementation(aow block, ImmutableMap<axj<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, @Nullable ImmutableTable<axj<?>, Comparable<?>, awt> table, awt clean) {
            super(block, properties, table);
            this.unlistedProperties = unlistedProperties;
            this.cleanState = clean == null ? this : clean;
        }

        @Nonnull
        public <T extends Comparable<T>, V extends T> awt a(@Nonnull axj<T> property, @Nonnull V value) {
            awt clean = super.a(property, value);
            if (clean == this.cleanState) {
                return this;
            }
            if (Iterables.all((Iterable)this.unlistedProperties.values(), (Predicate)Predicates.equalTo(Optional.empty()))) {
                return clean;
            }
            return new ExtendedStateImplementation(this.u(), clean.t(), this.unlistedProperties, ((awu.a)clean).getPropertyValueTable(), this.cleanState);
        }

        @Override
        public <V> IExtendedBlockState withProperty(IUnlistedProperty<V> property, V value) {
            if (!this.unlistedProperties.containsKey(property)) {
                throw new IllegalArgumentException("Cannot set unlisted property " + property + " as it does not exist in " + this.u().s());
            }
            if (!property.isValid(value)) {
                throw new IllegalArgumentException("Cannot set unlisted property " + property + " to " + value + " on block " + aow.h.b((Object)this.u()) + ", it is not an allowed value");
            }
            HashMap newMap = new HashMap((Map<IUnlistedProperty<?>, Optional<?>>)this.unlistedProperties);
            newMap.put(property, Optional.ofNullable(value));
            if (Iterables.all(newMap.values(), (Predicate)Predicates.equalTo(Optional.empty()))) {
                return (IExtendedBlockState)this.cleanState;
            }
            return new ExtendedStateImplementation(this.u(), this.t(), ImmutableMap.copyOf(newMap), this.c, this.cleanState);
        }

        @Override
        public Collection<IUnlistedProperty<?>> getUnlistedNames() {
            return Collections.unmodifiableCollection(this.unlistedProperties.keySet());
        }

        @Override
        public <V> V getValue(IUnlistedProperty<V> property) {
            if (!this.unlistedProperties.containsKey(property)) {
                throw new IllegalArgumentException("Cannot get unlisted property " + property + " as it does not exist in " + this.u().s());
            }
            return property.getType().cast(((Optional)this.unlistedProperties.get(property)).orElse(null));
        }

        @Override
        public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
            return this.unlistedProperties;
        }

        @Override
        public awt getClean() {
            return this.cleanState;
        }
    }
}

