/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ModCandidate;

public class ASMDataTable {
    private SetMultimap<String, ASMData> globalAnnotationData = HashMultimap.create();
    private Map<ModContainer, SetMultimap<String, ASMData>> containerAnnotationData;
    private List<ModContainer> containers = Lists.newArrayList();
    private SetMultimap<String, ModCandidate> packageMap = HashMultimap.create();

    public SetMultimap<String, ASMData> getAnnotationsFor(ModContainer container) {
        if (this.containerAnnotationData == null) {
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (ModContainer cont : this.containers) {
                SetMultimap values = Multimaps.filterValues(this.globalAnnotationData, (Predicate)new ModContainerPredicate(cont));
                mapBuilder.put((Object)cont, (Object)ImmutableSetMultimap.copyOf((Multimap)values));
            }
            this.containerAnnotationData = mapBuilder.build();
        }
        return this.containerAnnotationData.get(container);
    }

    public Set<ASMData> getAll(String annotation) {
        return this.globalAnnotationData.get((Object)annotation);
    }

    public void addASMData(ModCandidate candidate, String annotation, String className, @Nullable String objectName, @Nullable Map<String, Object> annotationInfo) {
        this.globalAnnotationData.put((Object)annotation, (Object)new ASMData(candidate, annotation, className, objectName, annotationInfo));
    }

    public void addContainer(ModContainer container) {
        this.containers.add(container);
    }

    public void registerPackage(ModCandidate modCandidate, String pkg) {
        this.packageMap.put((Object)pkg, (Object)modCandidate);
    }

    public Set<ModCandidate> getCandidatesFor(String pkg) {
        return this.packageMap.get((Object)pkg);
    }

    @Nullable
    public static String getOwnerModID(Set<ASMData> mods, ASMData targ) {
        if (mods.size() == 1) {
            return (String)mods.iterator().next().getAnnotationInfo().get("modid");
        }
        for (ASMData m : mods) {
            if (!targ.getClassName().startsWith(m.getClassName())) continue;
            return (String)m.getAnnotationInfo().get("modid");
        }
        return null;
    }

    private static class ModContainerPredicate
    implements Predicate<ASMData> {
        private ModContainer container;

        public ModContainerPredicate(ModContainer container) {
            this.container = container;
        }

        public boolean apply(ASMData data) {
            return this.container.getSource().equals(data.candidate.getModContainer());
        }
    }

    public static final class ASMData
    implements Cloneable {
        private ModCandidate candidate;
        private String annotationName;
        private String className;
        private String objectName;
        private int classVersion;
        private Map<String, Object> annotationInfo;

        public ASMData(ModCandidate candidate, String annotationName, String className, @Nullable String objectName, @Nullable Map<String, Object> info) {
            this.candidate = candidate;
            this.annotationName = annotationName;
            this.className = className;
            this.objectName = objectName;
            this.annotationInfo = info;
        }

        public ModCandidate getCandidate() {
            return this.candidate;
        }

        public String getAnnotationName() {
            return this.annotationName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public Map<String, Object> getAnnotationInfo() {
            return this.annotationInfo;
        }

        public ASMData copy(Map<String, Object> newAnnotationInfo) {
            try {
                ASMData clone = (ASMData)this.clone();
                clone.annotationInfo = newAnnotationInfo;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Unpossible", e);
            }
        }
    }
}

