/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.handshake;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage;
import net.minecraftforge.fml.common.network.handshake.IHandshakeState;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;

enum FMLHandshakeClientState implements IHandshakeState<FMLHandshakeClientState>
{
    START{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeClientState> cons) {
            cons.accept(HELLO);
            NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
            dispatcher.clientListenForServerHandshake();
        }
    }
    ,
    HELLO{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeClientState> cons) {
            boolean isVanilla;
            boolean bl2 = isVanilla = msg == null;
            if (isVanilla) {
                cons.accept(DONE);
            } else {
                cons.accept(WAITINGSERVERDATA);
            }
            ctx.writeAndFlush((Object)FMLHandshakeMessage.makeCustomChannelRegistration(NetworkRegistry.INSTANCE.channelNamesFor(Side.CLIENT)));
            if (isVanilla) {
                NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                dispatcher.abortClientHandshake("VANILLA");
                return;
            }
            FMLHandshakeMessage.ServerHello serverHelloPacket = (FMLHandshakeMessage.ServerHello)msg;
            FMLLog.log.info("Server protocol version {}", (Object)Integer.toHexString(serverHelloPacket.protocolVersion()));
            if (serverHelloPacket.protocolVersion() > 1) {
                NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                dispatcher.setOverrideDimension(serverHelloPacket.overrideDim());
            }
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.ClientHello()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.ModList(Loader.instance().getActiveModList())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }
    ,
    WAITINGSERVERDATA{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeClientState> cons) {
            String result = FMLNetworkHandler.checkModList((FMLHandshakeMessage.ModList)msg, Side.SERVER);
            if (result != null) {
                cons.accept(ERROR);
                NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                dispatcher.rejectHandshake(result);
                return;
            }
            if (!((Boolean)ctx.channel().attr(NetworkDispatcher.IS_LOCAL).get()).booleanValue()) {
                cons.accept(WAITINGSERVERCOMPLETE);
            } else {
                cons.accept(PENDINGCOMPLETE);
            }
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }
    ,
    WAITINGSERVERCOMPLETE{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeClientState> cons) {
            FMLHandshakeMessage.RegistryData pkt = (FMLHandshakeMessage.RegistryData)msg;
            Map snap = (Map)ctx.channel().attr(NetworkDispatcher.FML_GAMEDATA_SNAPSHOT).get();
            if (snap == null) {
                snap = Maps.newHashMap();
                ctx.channel().attr(NetworkDispatcher.FML_GAMEDATA_SNAPSHOT).set((Object)snap);
            }
            ForgeRegistry.Snapshot entry = new ForgeRegistry.Snapshot();
            entry.ids.putAll(pkt.getIdMap());
            entry.dummied.addAll(pkt.getDummied());
            entry.overrides.putAll(pkt.getOverrides());
            snap.put(pkt.getName(), entry);
            if (pkt.hasMore()) {
                cons.accept(WAITINGSERVERCOMPLETE);
                FMLLog.log.debug("Received Mod Registry mapping for {}: {} IDs {} overrides {} dummied", (Object)pkt.getName(), (Object)entry.ids.size(), (Object)entry.overrides.size(), (Object)entry.dummied.size());
                return;
            }
            ctx.channel().attr(NetworkDispatcher.FML_GAMEDATA_SNAPSHOT).set(null);
            Multimap<nf, nf> locallyMissing = GameData.injectSnapshot(snap, false, false);
            if (!locallyMissing.isEmpty()) {
                cons.accept(ERROR);
                NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                dispatcher.rejectHandshake("Fatally missing registry entries");
                FMLLog.log.fatal("Failed to connect to server: there are {} missing registry items", (Object)locallyMissing.size());
                locallyMissing.asMap().forEach((key, value) -> FMLLog.log.debug("Missing {} Entries: {}", key, value));
                return;
            }
            cons.accept(PENDINGCOMPLETE);
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }
    ,
    PENDINGCOMPLETE{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeClientState> cons) {
            cons.accept(COMPLETE);
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }
    ,
    COMPLETE{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeClientState> cons) {
            cons.accept(DONE);
            NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
            dispatcher.completeClientHandshake();
            FMLMessage.CompleteHandshake complete = new FMLMessage.CompleteHandshake(Side.CLIENT);
            ctx.fireChannelRead((Object)complete);
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }
    ,
    DONE{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeClientState> cons) {
            if (msg instanceof FMLHandshakeMessage.HandshakeReset) {
                cons.accept(HELLO);
                GameData.revertToFrozen();
            }
        }
    }
    ,
    ERROR{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeClientState> cons) {
        }
    };

}

