/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.server.ForgeTimeTracker;
import net.minecraftforge.server.command.ChunkGenWorker;

public class ForgeCommand
extends bi {
    private static final DecimalFormat timeFormatter = new DecimalFormat("########0.000");

    public String c() {
        return "forge";
    }

    public String b(bn icommandsender) {
        return "commands.forge.usage";
    }

    public int a() {
        return 2;
    }

    public void a(MinecraftServer server, bn sender, String[] args) throws ei {
        if (args.length == 0) {
            throw new ep("commands.forge.usage", new Object[0]);
        }
        if ("help".equals(args[0])) {
            throw new ep("commands.forge.usage", new Object[0]);
        }
        if ("tps".equals(args[0])) {
            this.displayTPS(server, sender, args);
        } else if ("track".equals(args[0])) {
            this.handleTracking(server, sender, args);
        } else if ("gen".equals(args[0])) {
            this.handleGen(server, sender, args);
        } else {
            throw new ep("commands.forge.usage", new Object[0]);
        }
    }

    public List<String> a(MinecraftServer server, bn sender, String[] args, @Nullable et targetPos) {
        if (args.length <= 1) {
            return ForgeCommand.a((String[])args, (String[])new String[]{"help", "tps", "track", "gen"});
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "gen": {
                if (args.length > 1 && args.length <= 4) {
                    return ForgeCommand.a((String[])args, (int)1, (et)targetPos);
                }
                if (args.length == 5) {
                    return Collections.emptyList();
                }
                if (args.length != 6) break;
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private void handleTracking(MinecraftServer server, bn sender, String[] args) throws ei {
        if (args.length != 3) {
            throw new ep("commands.forge.usage.tracking", new Object[0]);
        }
        String type = args[1];
        int duration = ForgeCommand.a((String)args[2], (int)1, (int)60);
        if (!"te".equals(type)) {
            throw new ep("commands.forge.usage.tracking", new Object[0]);
        }
        this.doTurnOnTileEntityTracking(server, sender, duration);
    }

    private void doTurnOnTileEntityTracking(MinecraftServer server, bn sender, int duration) {
        ForgeTimeTracker.tileEntityTrackingDuration = duration;
        ForgeTimeTracker.tileEntityTracking = true;
        sender.a((hh)new hp("commands.forge.tracking.te.enabled", new Object[]{duration}));
    }

    private void doTPSLog(MinecraftServer server, bn sender, String[] args) {
    }

    private void displayTPS(MinecraftServer server, bn sender, String[] args) throws ei {
        int dim = 0;
        boolean summary = true;
        if (args.length > 1) {
            dim = ForgeCommand.a((String)args[1]);
            summary = false;
        }
        if (summary) {
            for (Integer dimId : DimensionManager.getIDs()) {
                double worldTickTime = (double)ForgeCommand.mean((long[])server.worldTickTimes.get(dimId)) * 1.0E-6;
                double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
                sender.a((hh)new hp("commands.forge.tps.summary", new Object[]{String.format("Dim %d", dimId), timeFormatter.format(worldTickTime), timeFormatter.format(worldTPS)}));
            }
            double meanTickTime = (double)ForgeCommand.mean(server.h) * 1.0E-6;
            double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
            sender.a((hh)new hp("commands.forge.tps.summary", new Object[]{"Overall", timeFormatter.format(meanTickTime), timeFormatter.format(meanTPS)}));
        } else {
            double worldTickTime = (double)ForgeCommand.mean((long[])server.worldTickTimes.get(dim)) * 1.0E-6;
            double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
            sender.a((hh)new hp("commands.forge.tps.summary", new Object[]{String.format("Dim %d", dim), timeFormatter.format(worldTickTime), timeFormatter.format(worldTPS)}));
        }
    }

    private void handleGen(MinecraftServer server, bn sender, String[] args) throws ei {
        if (args.length < 5) {
            throw new ep("commands.forge.gen.usage", new Object[0]);
        }
        et blockpos = ForgeCommand.a((bn)sender, (String[])args, (int)1, (boolean)false);
        int count = ForgeCommand.a((String)args[4], (int)10);
        int dim = args.length >= 6 ? ForgeCommand.a((String)args[5]) : sender.e().s.getDimension();
        int interval = args.length >= 7 ? ForgeCommand.a((String)args[6]) : -1;
        et chunkpos = new et(blockpos.p() >> 4, 0, blockpos.r() >> 4);
        ChunkGenWorker worker = new ChunkGenWorker(sender, chunkpos, count, dim, interval);
        sender.a((hh)worker.getStartMessage());
        WorldWorkerManager.addWorker(worker);
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }
}

