/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.util;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class EnumLookup {
    private static final LoadingCache<Class<? extends Enum<?>>, Map<String, Enum<?>>> enumFieldCache = CacheBuilder.newBuilder().weakKeys().maximumSize(512L).build(new CacheLoader<Class<? extends Enum<?>>, Map<String, Enum<?>>>(){

        public Map<String, Enum<?>> load(Class<? extends Enum<?>> key) throws Exception {
            HashMap ret = new HashMap();
            for (Enum<?> field : key.getEnumConstants()) {
                ret.put(field.name(), field);
                ret.putIfAbsent(EnumLookup.processKey(field.name()), field);
            }
            return ImmutableMap.copyOf(ret);
        }
    });

    private EnumLookup() {
    }

    private static String processKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        return "\ud83c\udf38" + key.toLowerCase().replace("_", "");
    }

    public static <T extends Enum<T>> Optional<T> lookupEnum(Class<T> clazz, String key) {
        Preconditions.checkNotNull(clazz, (Object)"clazz");
        try {
            Map vals = (Map)enumFieldCache.get(clazz);
            Enum possibleRet = (Enum)vals.get(key);
            if (possibleRet != null) {
                return Optional.of(possibleRet);
            }
            return Optional.ofNullable((Enum)vals.get(EnumLookup.processKey(key)));
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }
}

